/*
 * Decompiled with CFR 0.152.
 */
package cascading.util;

import cascading.flow.FlowElement;
import cascading.flow.FlowException;
import cascading.flow.Scope;
import cascading.operation.BaseOperation;
import cascading.operation.Operation;
import cascading.pipe.Pipe;
import cascading.scheme.Scheme;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;
import org.jgrapht.ext.DOTExporter;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.MatrixExporter;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.SimpleDirectedGraph;

public class Util {
    private static final Logger LOG = Logger.getLogger(Util.class);

    public static String serializeBase64(Object object) throws IOException {
        return Util.serializeBase64(object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serializeBase64(Object object, boolean compress) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(compress ? new GZIPOutputStream(bytes) : bytes);
        try {
            out.writeObject(object);
        }
        finally {
            out.close();
        }
        return new String(Base64.encodeBase64((byte[])bytes.toByteArray()));
    }

    public static Object deserializeBase64(String string) throws IOException {
        return Util.deserializeBase64(string, true);
    }

    public static Object deserializeBase64(String string, boolean decompress) throws IOException {
        if (string == null || string.length() == 0) {
            return null;
        }
        ObjectInputStream in = null;
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(Base64.decodeBase64((byte[])string.getBytes()));
            in = new ObjectInputStream(decompress ? new GZIPInputStream(bytes) : bytes){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    try {
                        return Class.forName(desc.getName(), false, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException exception) {
                        return super.resolveClass(desc);
                    }
                }
            };
            Object object = in.readObject();
            return object;
        }
        catch (ClassNotFoundException exception) {
            throw new FlowException("unable to deserialize data", exception);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static String createUniqueID(String seed) {
        String base = String.format("%s%d%.10f", seed, System.currentTimeMillis(), Math.random());
        return DigestUtils.md5Hex((String)base);
    }

    public static String join(int[] list, String delim) {
        return Util.join(list, delim, false);
    }

    public static String join(int[] list, String delim, boolean printNull) {
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        int[] arr$ = list;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer s = arr$[i$];
            if (count != 0) {
                buffer.append(delim);
            }
            if (printNull || s != null) {
                buffer.append(s);
            }
            ++count;
        }
        return buffer.toString();
    }

    public static String join(String delim, String ... strings) {
        return Util.join(delim, false, strings);
    }

    public static String join(String delim, boolean printNull, String ... strings) {
        return Util.join(strings, delim, printNull);
    }

    public static String join(Object[] list, String delim) {
        return Util.join(list, delim, false);
    }

    public static String join(Object[] list, String delim, boolean printNull) {
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        for (Object s : list) {
            if (count != 0) {
                buffer.append(delim);
            }
            if (printNull || s != null) {
                buffer.append(s);
            }
            ++count;
        }
        return buffer.toString();
    }

    public static String join(Collection collection) {
        return Util.join(collection, "\t");
    }

    public static String join(Collection collection, String delim) {
        return Util.join(collection, delim, false);
    }

    public static String join(Collection collection, String delim, boolean printNull) {
        StringBuffer buffer = new StringBuffer();
        Util.join(buffer, collection, delim, printNull);
        return buffer.toString();
    }

    public static void join(StringBuffer buffer, Collection collection, String delim) {
        Util.join(buffer, collection, delim, false);
    }

    public static void join(StringBuffer buffer, Collection collection, String delim, boolean printNull) {
        int count = 0;
        for (Object s : collection) {
            if (count != 0) {
                buffer.append(delim);
            }
            if (printNull || s != null) {
                buffer.append(s);
            }
            ++count;
        }
    }

    public static String[] removeNulls(String ... strings) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : strings) {
            if (string == null) continue;
            list.add(string);
        }
        return list.toArray(new String[list.size()]);
    }

    public static Collection<String> quote(Collection<String> collection, String quote) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : collection) {
            list.add(quote + string + quote);
        }
        return list;
    }

    public static String print(Collection collection, String delim) {
        StringBuffer buffer = new StringBuffer();
        Util.print(buffer, collection, delim);
        return buffer.toString();
    }

    public static void print(StringBuffer buffer, Collection collection, String delim) {
        int count = 0;
        for (Object s : collection) {
            if (count != 0) {
                buffer.append(delim);
            }
            buffer.append("[");
            buffer.append(s);
            buffer.append("]");
            ++count;
        }
    }

    public static String sanitizeUrl(String url) {
        if (url == null) {
            return null;
        }
        return url.replaceAll("(?<=//).*:.*@", "") + "\"]";
    }

    public static String normalizeUrl(String url) {
        if (url == null) {
            return null;
        }
        return url.replaceAll("([^:]/)/{2,}", "$1/");
    }

    public static String toNull(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String truncate(String string, int maxSize) {
        if ((string = Util.toNull(string)).length() <= maxSize) {
            return string;
        }
        return String.format("%s...", string.subSequence(0, maxSize - 3));
    }

    public static <A> A getProperty(Map<Object, Object> properties, String key, A defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        Object value = properties.get(key);
        return (A)(value == null ? defaultValue : value);
    }

    public static String printGraph(SimpleDirectedGraph graph) {
        StringWriter writer = new StringWriter();
        Util.printGraph(writer, graph);
        return writer.toString();
    }

    public static void printGraph(PrintStream out, SimpleDirectedGraph graph) {
        PrintWriter printWriter = new PrintWriter(out);
        Util.printGraph(printWriter, graph);
    }

    public static void printGraph(String filename, SimpleDirectedGraph graph) {
        try {
            FileWriter writer = new FileWriter(filename);
            Util.printGraph(writer, graph);
            ((Writer)writer).close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private static void printGraph(Writer writer, SimpleDirectedGraph graph) {
        DOTExporter dot = new DOTExporter(new IntegerNameProvider(), new VertexNameProvider(){

            public String getVertexName(Object object) {
                return object.toString().replaceAll("\"", "'");
            }
        }, new EdgeNameProvider<Object>(){

            @Override
            public String getEdgeName(Object object) {
                return object.toString().replaceAll("\"", "'");
            }
        });
        dot.export(writer, graph);
    }

    public static void printMatrix(PrintStream out, SimpleDirectedGraph<FlowElement, Scope> graph) {
        new MatrixExporter<FlowElement, Scope>().exportAdjacencyMatrix((Writer)new PrintWriter(out), graph);
    }

    public static void removeAllNulls(List list) {
        while (list.remove(null)) {
        }
    }

    public static String formatTrace(Scheme scheme, String message) {
        if (scheme == null) {
            return message;
        }
        String trace = scheme.getTrace();
        if (trace == null) {
            return message;
        }
        return "[" + Util.truncate(scheme.toString(), 25) + "][" + trace + "] " + message;
    }

    public static String formatTrace(Pipe pipe, String message) {
        if (pipe == null) {
            return message;
        }
        String trace = pipe.getTrace();
        if (trace == null) {
            return message;
        }
        return "[" + Util.truncate(pipe.getName(), 25) + "][" + trace + "] " + message;
    }

    public static String formatTrace(Operation operation, String message) {
        if (!(operation instanceof BaseOperation)) {
            return message;
        }
        String trace = ((BaseOperation)operation).getTrace();
        if (trace == null) {
            return message;
        }
        return "[" + trace + "] " + message;
    }

    public static String captureDebugTrace(Class type) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 3; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            Package aPackage = type.getPackage();
            if (aPackage != null && stackTraceElement.getClassName().startsWith(aPackage.getName())) continue;
            return stackTraceElement.toString();
        }
        return null;
    }

    public static Class findMainClass(Class defaultType) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.getMethodName().equals("main") || stackTraceElement.getClassName().startsWith("org.apache.hadoop")) continue;
            try {
                LOG.info((Object)("resolving application jar from found main method on: " + stackTraceElement.getClassName()));
                return Thread.currentThread().getContextClassLoader().loadClass(stackTraceElement.getClassName());
            }
            catch (ClassNotFoundException exception) {
                LOG.warn((Object)("unable to load class while discovering application jar: " + stackTraceElement.getClassName()), (Throwable)exception);
            }
        }
        LOG.info((Object)"using default application jar, may cause class not found exceptions on the cluster");
        return defaultType;
    }

    public static void writeDOT(Writer writer, SimpleDirectedGraph graph, IntegerNameProvider vertexIdProvider, VertexNameProvider vertexNameProvider, EdgeNameProvider edgeNameProvider) {
        new DOTExporter(vertexIdProvider, vertexNameProvider, edgeNameProvider).export(writer, graph);
    }

    public static <T> T retry(Logger logger, int retries, int secondsDelay, String message, RetryOperator<T> operator) throws Exception {
        Exception saved = null;
        for (int i = 0; i < retries; ++i) {
            try {
                return operator.operate();
            }
            catch (Exception exception) {
                if (operator.rethrow(exception)) {
                    logger.warn((Object)(message + ", but not retrying"), (Throwable)exception);
                    throw exception;
                }
                saved = exception;
                logger.warn((Object)(message + ", attempt: " + (i + 1)), (Throwable)exception);
                try {
                    Thread.sleep(secondsDelay * 1000);
                }
                catch (InterruptedException exception1) {
                    // empty catch block
                }
                continue;
            }
        }
        logger.warn((Object)(message + ", done retrying after attempts: " + retries), (Throwable)saved);
        throw saved;
    }

    public static Object createProtectedObject(Class type, Object[] parameters, Class[] parameterTypes) {
        try {
            Constructor constructor = type.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(parameters);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new FlowException("unable to instantiate type: " + type.getName(), exception);
        }
    }

    public static Thread getHDFSShutdownHook() {
        Exception caughtException = null;
        try {
            FileSystem.getLocal((Configuration)new JobConf());
            Field field = FileSystem.class.getDeclaredField("clientFinalizer");
            field.setAccessible(true);
            Thread finalizer = (Thread)field.get(null);
            if (finalizer != null) {
                Runtime.getRuntime().removeShutdownHook(finalizer);
            }
            return finalizer;
        }
        catch (NoSuchFieldException exception) {
            caughtException = exception;
        }
        catch (IllegalAccessException exception) {
            caughtException = exception;
        }
        catch (IOException exception) {
            caughtException = exception;
        }
        LOG.info((Object)("unable to find and remove client hdfs shutdown hook, received exception: " + caughtException.getClass().getName()));
        return null;
    }

    public static Object invokeStaticMethod(Class type, String methodName, Object[] parameters, Class[] parameterTypes) {
        try {
            Method method = type.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method.invoke(null, parameters);
        }
        catch (Exception exception) {
            throw new FlowException("unable to invoke static method: " + type.getName() + "." + methodName, exception);
        }
    }

    public static interface RetryOperator<T> {
        public T operate() throws Exception;

        public boolean rethrow(Exception var1);
    }
}

