/*
 * Decompiled with CFR 0.152.
 */
package cascading.cascade;

import cascading.cascade.Cascade;
import cascading.cascade.CascadeException;
import cascading.flow.Flow;
import cascading.tap.CompositeTap;
import cascading.tap.Tap;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;
import org.jgrapht.Graphs;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class CascadeConnector {
    private static final Logger LOG = Logger.getLogger(CascadeConnector.class);
    private Map<Object, Object> properties;

    public CascadeConnector() {
    }

    @ConstructorProperties(value={"properties"})
    public CascadeConnector(Map<Object, Object> properties) {
        this.properties = properties;
    }

    public Cascade connect(Flow ... flows) {
        return this.connect((String)null, flows);
    }

    public Cascade connect(String name, Flow ... flows) {
        this.verifyUniqueFlowNames(flows);
        name = name == null ? this.makeName(flows) : name;
        SimpleDirectedGraph<Tap, Flow.FlowHolder> tapGraph = new SimpleDirectedGraph<Tap, Flow.FlowHolder>(Flow.FlowHolder.class);
        SimpleDirectedGraph<Flow, Integer> flowGraph = new SimpleDirectedGraph<Flow, Integer>(Integer.class);
        this.makeTapGraph(tapGraph, flows);
        this.makeFlowGraph(flowGraph, tapGraph);
        return new Cascade(name, flowGraph);
    }

    private void verifyUniqueFlowNames(Flow[] flows) {
        HashSet<String> set = new HashSet<String>();
        for (Flow flow : flows) {
            if (set.contains(flow.getName())) {
                throw new CascadeException("all flow names must be unique, found duplicate: " + flow.getName());
            }
            set.add(flow.getName());
        }
    }

    private String makeName(Flow[] flows) {
        Object[] names = new String[flows.length];
        for (int i = 0; i < flows.length; ++i) {
            names[i] = flows[i].getName();
        }
        return Util.join(names, "+");
    }

    private void makeTapGraph(SimpleDirectedGraph<Tap, Flow.FlowHolder> tapGraph, Flow[] flows) {
        for (Flow flow : flows) {
            LinkedList<Tap> sources = new LinkedList<Tap>(flow.getSources().values());
            Collection<Tap> sinks = flow.getSinks().values();
            ListIterator<Tap> iterator = sources.listIterator();
            while (iterator.hasNext()) {
                Tap source = (Tap)iterator.next();
                if (!(source instanceof CompositeTap)) continue;
                iterator.remove();
                for (Tap tap : ((CompositeTap)((Object)source)).getChildTaps()) {
                    iterator.add(tap);
                }
            }
            for (Tap source : sources) {
                tapGraph.addVertex(source);
            }
            for (Tap sink : sinks) {
                tapGraph.addVertex(sink);
            }
            for (Tap source : sources) {
                for (Tap sink : sinks) {
                    tapGraph.addEdge(source, sink, flow.getHolder());
                }
            }
        }
    }

    private void makeFlowGraph(SimpleDirectedGraph<Flow, Integer> jobGraph, SimpleDirectedGraph<Tap, Flow.FlowHolder> tapGraph) {
        TopologicalOrderIterator<Tap, Flow.FlowHolder> topoIterator = new TopologicalOrderIterator<Tap, Flow.FlowHolder>(tapGraph);
        int count = 0;
        while (topoIterator.hasNext()) {
            Tap source = (Tap)topoIterator.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("handling flow source: " + source));
            }
            List<Tap> sinks = Graphs.successorListOf(tapGraph, source);
            for (Tap sink : sinks) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("handling flow path: " + source + " -> " + sink));
                }
                Flow flow = ((Flow.FlowHolder)tapGraph.getEdge((Tap)source, (Tap)sink)).flow;
                jobGraph.addVertex(flow);
                Set previous = tapGraph.incomingEdgesOf(source);
                for (Flow.FlowHolder previousFlow : previous) {
                    jobGraph.addEdge(previousFlow.flow, flow, count++);
                }
            }
        }
    }

    static class RootTap
    extends Tap {
        private static final long serialVersionUID = 1L;

        RootTap() {
        }

        @Override
        public Path getPath() {
            return null;
        }

        @Override
        public boolean makeDirs(JobConf conf) throws IOException {
            return false;
        }

        @Override
        public boolean deletePath(JobConf conf) throws IOException {
            return false;
        }

        @Override
        public boolean pathExists(JobConf conf) throws IOException {
            return false;
        }

        @Override
        public long getPathModified(JobConf conf) throws IOException {
            return 0L;
        }

        @Override
        public TupleEntryIterator openForRead(JobConf conf) throws IOException {
            return null;
        }

        @Override
        public TupleEntryCollector openForWrite(JobConf conf) throws IOException {
            return null;
        }
    }
}

