/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.flow.ElementGraph;
import cascading.flow.FlowConnector;
import cascading.flow.FlowElement;
import cascading.flow.PlannerException;
import cascading.flow.Scope;
import cascading.operation.AssertionLevel;
import cascading.operation.DebugLevel;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.Group;
import cascading.pipe.Pipe;
import cascading.pipe.SubAssembly;
import cascading.tap.Tap;
import cascading.util.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;

public class FlowPlanner {
    private static final Logger LOG = Logger.getLogger(FlowPlanner.class);
    protected final Map<Object, Object> properties;
    protected AssertionLevel assertionLevel;
    protected DebugLevel debugLevel;

    FlowPlanner(Map<Object, Object> properties) {
        this.properties = properties;
        this.assertionLevel = FlowConnector.getAssertionLevel(properties);
        this.debugLevel = FlowConnector.getDebugLevel(properties);
    }

    protected void verifyAssembly(Pipe[] pipes, Map<String, Tap> sources, Map<String, Tap> sinks, Map<String, Tap> traps) {
        this.verifySourceNotSinks(sources, sinks);
        this.verifyTaps(sources, true, true);
        this.verifyTaps(sinks, false, true);
        this.verifyTaps(traps, false, false);
        this.verifyPipeAssemblyEndPoints(sources, sinks, pipes);
        this.verifyTraps(traps, pipes, sources, sinks);
    }

    protected ElementGraph createElementGraph(Pipe[] pipes, Map<String, Tap> sources, Map<String, Tap> sinks, Map<String, Tap> traps) {
        return new ElementGraph(pipes, sources, sinks, traps, this.assertionLevel, this.debugLevel);
    }

    protected void verifySourceNotSinks(Map<String, Tap> sources, Map<String, Tap> sinks) {
        Collection<Tap> sourcesSet = sources.values();
        for (Tap tap : sinks.values()) {
            if (!sourcesSet.contains(tap)) continue;
            throw new PlannerException("tap may not be used as both source and sink in the same Flow: " + tap);
        }
    }

    protected void verifyTaps(Map<String, Tap> taps, boolean areSources, boolean mayNotBeEmpty) {
        if (mayNotBeEmpty && taps.isEmpty()) {
            throw new PlannerException((areSources ? "source" : "sink") + " taps are required");
        }
        for (String tapName : taps.keySet()) {
            if (areSources && !taps.get(tapName).isSource()) {
                throw new PlannerException("tap named: '" + tapName + "', cannot be used as a source: " + taps.get(tapName));
            }
            if (areSources || taps.get(tapName).isSink()) continue;
            throw new PlannerException("tap named: '" + tapName + "', cannot be used as a sink: " + taps.get(tapName));
        }
    }

    protected void verifyPipeAssemblyEndPoints(Map<String, Tap> sources, Map<String, Tap> sinks, Pipe[] pipes) {
        HashSet<String> tapNames = new HashSet<String>();
        tapNames.addAll(sources.keySet());
        tapNames.addAll(sinks.keySet());
        HashSet<Pipe> tails = new HashSet<Pipe>();
        HashSet<String> tailNames = new HashSet<String>();
        for (Pipe pipe : pipes) {
            if (pipe instanceof SubAssembly) {
                for (Pipe tail : ((SubAssembly)pipe).getTails()) {
                    String tailName = tail.getName();
                    if (!tapNames.contains(tailName)) {
                        throw new PlannerException(tail, "pipe name not found in either sink or source map: '" + tailName + "'");
                    }
                    if (tailNames.contains(tailName) && !tails.contains(tail)) {
                        LOG.warn((Object)("duplicate tail name found: '" + tailName + "'"));
                    }
                    tailNames.add(tailName);
                    tails.add(tail);
                }
                continue;
            }
            String tailName = pipe.getName();
            if (!tapNames.contains(tailName)) {
                throw new PlannerException(pipe, "pipe name not found in either sink or source map: '" + tailName + "'");
            }
            if (tailNames.contains(tailName) && !tails.contains(pipe)) {
                LOG.warn((Object)("duplicate tail name found: '" + tailName + "'"));
            }
            tailNames.add(tailName);
            tails.add(pipe);
        }
        tailNames.removeAll(sinks.keySet());
        HashSet<String> remainingSinks = new HashSet<String>(sinks.keySet());
        remainingSinks.removeAll(tailNames);
        if (tailNames.size() != 0) {
            throw new PlannerException("not all tail pipes bound to sink taps, remaining tail pipe names: [" + Util.join(Util.quote(tailNames, "'"), ", ") + "], remaining sink tap names: [" + Util.join(Util.quote(remainingSinks, "'"), ", ") + "]");
        }
        remainingSinks = new HashSet<String>(sinks.keySet());
        remainingSinks.removeAll(Arrays.asList(Pipe.names(pipes)));
        if (remainingSinks.size() != 0) {
            throw new PlannerException("not all sink taps bound to tail pipes, remaining sink tap names: [" + Util.join(Util.quote(remainingSinks, "'"), ", ") + "]");
        }
        HashSet<Pipe> heads = new HashSet<Pipe>();
        HashSet<String> headNames = new HashSet<String>();
        for (Pipe pipe : pipes) {
            for (Pipe head : pipe.getHeads()) {
                String headName = head.getName();
                if (!tapNames.contains(headName)) {
                    throw new PlannerException(head, "pipe name not found in either sink or source map: '" + headName + "'");
                }
                if (headNames.contains(headName) && !heads.contains(head)) {
                    LOG.warn((Object)("duplicate head name found, not an error but heads should have unique names: '" + headName + "'"));
                }
                headNames.add(headName);
                heads.add(head);
            }
        }
        HashSet allHeadNames = new HashSet(headNames);
        headNames.removeAll(sources.keySet());
        HashSet<String> remainingSources = new HashSet<String>(sources.keySet());
        remainingSources.removeAll(headNames);
        if (headNames.size() != 0) {
            throw new PlannerException("not all head pipes bound to source taps, remaining head pipe names: [" + Util.join(Util.quote(headNames, "'"), ", ") + "], remaining source tap names: [" + Util.join(Util.quote(remainingSources, "'"), ", ") + "]");
        }
        remainingSources = new HashSet<String>(sources.keySet());
        remainingSources.removeAll(allHeadNames);
        if (remainingSources.size() != 0) {
            throw new PlannerException("not all source taps bound to head pipes, remaining source tap names: [" + Util.join(Util.quote(remainingSources, "'"), ", ") + "], remaining head pipe names: [" + Util.join(Util.quote(headNames, "'"), ", ") + "]");
        }
    }

    protected void verifyTraps(Map<String, Tap> traps, Pipe[] pipes, Map<String, Tap> sources, Map<String, Tap> sinks) {
        this.verifyTrapsNotSourcesSinks(traps, sources, sinks);
        HashSet names = new HashSet();
        Collections.addAll(names, Pipe.names(pipes));
        for (String name : traps.keySet()) {
            if (names.contains(name)) continue;
            throw new PlannerException("trap name not found in assembly: '" + name + "'");
        }
    }

    private void verifyTrapsNotSourcesSinks(Map<String, Tap> traps, Map<String, Tap> sources, Map<String, Tap> sinks) {
        Collection<Tap> sourceTaps = sources.values();
        Collection<Tap> sinkTaps = sinks.values();
        for (Tap tap : traps.values()) {
            if (sourceTaps.contains(tap)) {
                throw new PlannerException("tap may not be used as both a trap and a source in the same Flow: " + tap);
            }
            if (!sinkTaps.contains(tap)) continue;
            throw new PlannerException("tap may not be used as both a trap and a sink in the same Flow: " + tap);
        }
    }

    protected void failOnLoneGroupAssertion(ElementGraph elementGraph) {
        List<Group> groups = elementGraph.findAllGroups();
        for (Group group : groups) {
            for (GraphPath<FlowElement, Scope> path : elementGraph.getAllShortestPathsFrom(group)) {
                List<FlowElement> flowElements = Graphs.getPathVertexList(path);
                int everies = 0;
                int assertions = 0;
                for (FlowElement flowElement : flowElements) {
                    if (flowElement instanceof Group) continue;
                    if (!(flowElement instanceof Every)) break;
                    ++everies;
                    Every every = (Every)flowElement;
                    if (every.getPlannerLevel() == null) continue;
                    ++assertions;
                }
                if (everies == 0 || everies != assertions) continue;
                throw new PlannerException("group assertions must be accompanied by aggregator operations");
            }
        }
    }

    protected void failOnMissingGroup(ElementGraph elementGraph) {
        List<Every> everies = elementGraph.findAllEveries();
        for (Every every : everies) {
            block1: for (GraphPath<FlowElement, Scope> path : elementGraph.getAllShortestPathsTo(every)) {
                List<FlowElement> flowElements = Graphs.getPathVertexList(path);
                Collections.reverse(flowElements);
                for (FlowElement flowElement : flowElements) {
                    if (flowElement instanceof Each) {
                        throw new PlannerException((Pipe)flowElement, "Every may only be preceded by another Every or a Group pipe, found: " + flowElement);
                    }
                    if (flowElement instanceof Every || !(flowElement instanceof Group)) continue;
                    continue block1;
                }
            }
        }
    }

    protected void failOnMisusedBuffer(ElementGraph elementGraph) {
        List<Every> everies = elementGraph.findAllEveries();
        for (Every every : everies) {
            block1: for (GraphPath<FlowElement, Scope> path : elementGraph.getAllShortestPathsTo(every)) {
                List<FlowElement> flowElements = Graphs.getPathVertexList(path);
                Collections.reverse(flowElements);
                Every last = null;
                boolean foundBuffer = false;
                int foundEveries = -1;
                for (FlowElement flowElement : flowElements) {
                    if (flowElement instanceof Each) {
                        throw new PlannerException((Pipe)flowElement, "Every may only be preceded by another Every or a Group pipe, found: " + flowElement);
                    }
                    if (flowElement instanceof Every) {
                        boolean isBuffer = ((Every)flowElement).isBuffer();
                        if (++foundEveries != 0 && (isBuffer || foundBuffer)) {
                            throw new PlannerException((Pipe)flowElement, "Only one Every Buffer may follow a Group pipe, found: " + flowElement + " before: " + last);
                        }
                        if (!foundBuffer) {
                            foundBuffer = isBuffer;
                        }
                        last = (Every)flowElement;
                    }
                    if (!(flowElement instanceof Group)) continue;
                    continue block1;
                }
            }
        }
    }
}

