/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class HadoopUtil {
    public static void initLog4j(JobConf jobConf) {
        String[] elements;
        String values = jobConf.get("log4j.logger", null);
        if (values == null || values.length() == 0) {
            return;
        }
        for (String element : elements = values.split(",")) {
            String[] logger = element.split("=");
            Logger.getLogger((String)logger[0]).setLevel(Level.toLevel((String)logger[1]));
        }
    }

    public static JobConf createJobConf(Map<Object, Object> properties, JobConf defaultJobconf) {
        JobConf jobConf;
        JobConf jobConf2 = jobConf = defaultJobconf == null ? new JobConf() : new JobConf((Configuration)defaultJobconf);
        if (properties == null) {
            return jobConf;
        }
        HashSet<Object> keys = new HashSet<Object>(properties.keySet());
        if (properties instanceof Properties) {
            keys.addAll(((Properties)properties).stringPropertyNames());
        }
        for (Object e : keys) {
            Object value = properties.get(e);
            if (value == null || value instanceof Class || value instanceof JobConf) continue;
            jobConf.set(e.toString(), value.toString());
        }
        return jobConf;
    }

    public static Map<Object, Object> createProperties(JobConf jobConf) {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        for (Map.Entry entry : jobConf) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }
}

