/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.assertion;

import cascading.flow.FlowProcess;
import cascading.operation.AssertionLevel;
import cascading.operation.PlannerLevel;
import cascading.operation.ValueAssertion;
import cascading.operation.ValueAssertionCall;
import cascading.operation.assertion.BaseAssertion;
import cascading.operation.regex.RegexMatcher;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.util.regex.Matcher;

public class AssertMatchesAll
extends RegexMatcher
implements ValueAssertion<Matcher> {
    private final String message = "argument '%s' value was: %s, did not match: %s, in tuple: %s";

    @ConstructorProperties(value={"patternString"})
    public AssertMatchesAll(String patternString) {
        super(patternString, false);
    }

    @ConstructorProperties(value={"patternString", "negateMatch"})
    public AssertMatchesAll(String patternString, boolean negateMatch) {
        super(patternString, negateMatch);
    }

    @Override
    public boolean supportsPlannerLevel(PlannerLevel plannerLevel) {
        return plannerLevel instanceof AssertionLevel;
    }

    @Override
    public void doAssert(FlowProcess flowProcess, ValueAssertionCall<Matcher> assertionCall) {
        TupleEntry input = assertionCall.getArguments();
        int pos = this.matchEachElementPos((Matcher)assertionCall.getContext(), input.getTuple());
        if (pos != -1) {
            BaseAssertion.throwFail("argument '%s' value was: %s, did not match: %s, in tuple: %s", input.getFields().get(pos), input.getObject(Integer.valueOf(pos)), this.patternString, input.getTuple().print());
        }
    }
}

