/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe;

import cascading.flow.Scope;
import cascading.operation.AssertionLevel;
import cascading.operation.BaseOperation;
import cascading.operation.Operation;
import cascading.operation.PlannedOperation;
import cascading.operation.PlannerLevel;
import cascading.pipe.OperatorException;
import cascading.pipe.Pipe;
import cascading.tuple.Fields;
import cascading.tuple.FieldsResolverException;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleException;
import java.util.Set;

public abstract class Operator
extends Pipe {
    protected final Operation operation;
    protected Fields argumentSelector = Fields.ALL;
    protected Fields outputSelector = Fields.RESULTS;
    protected PlannerLevel plannerLevel;

    protected Operator(Operation operation) {
        this.operation = operation;
        this.verifyOperation();
    }

    protected Operator(String name, Operation operation) {
        super(name);
        this.operation = operation;
        this.verifyOperation();
    }

    protected Operator(String name, Operation operation, Fields outputSelector) {
        super(name);
        this.operation = operation;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected Operator(String name, Fields argumentSelector, Operation operation) {
        super(name);
        this.operation = operation;
        this.argumentSelector = argumentSelector;
        this.verifyOperation();
    }

    protected Operator(String name, Fields argumentSelector, Operation operation, Fields outputSelector) {
        super(name);
        this.operation = operation;
        this.argumentSelector = argumentSelector;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected Operator(Pipe previous, Operation operation) {
        super(previous);
        this.operation = operation;
        this.verifyOperation();
    }

    protected Operator(Pipe previous, Fields argumentSelector, Operation operation) {
        super(previous);
        this.operation = operation;
        this.argumentSelector = argumentSelector;
        this.verifyOperation();
    }

    protected Operator(Pipe previous, Fields argumentSelector, Operation operation, Fields outputSelector) {
        super(previous);
        this.operation = operation;
        this.argumentSelector = argumentSelector;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected Operator(Pipe previous, Operation operation, Fields outputSelector) {
        super(previous);
        this.operation = operation;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected Operator(String name, PlannerLevel plannerLevel, PlannedOperation operation, Fields outputSelector) {
        super(name);
        this.plannerLevel = plannerLevel;
        this.operation = operation;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected Operator(String name, Fields argumentSelector, PlannerLevel plannerLevel, PlannedOperation operation, Fields outputSelector) {
        super(name);
        this.plannerLevel = plannerLevel;
        this.operation = operation;
        this.argumentSelector = argumentSelector;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected Operator(Pipe previous, PlannerLevel plannerLevel, PlannedOperation operation, Fields outputSelector) {
        super(previous);
        this.plannerLevel = plannerLevel;
        this.operation = operation;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected Operator(Pipe previous, Fields argumentSelector, PlannerLevel plannerLevel, PlannedOperation operation, Fields outputSelector) {
        super(previous);
        this.plannerLevel = plannerLevel;
        this.operation = operation;
        this.argumentSelector = argumentSelector;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected void verifyOperation() {
        if (this.operation == null) {
            throw new IllegalArgumentException("operation may not be null");
        }
        if (this.argumentSelector == null) {
            throw new IllegalArgumentException("argumentSelector may not be null");
        }
        if (this.outputSelector == null) {
            throw new IllegalArgumentException("outputSelector may not be null");
        }
        if (this.operation instanceof PlannedOperation) {
            if (this.plannerLevel == null) {
                throw new IllegalArgumentException("planner level may not be null");
            }
            if (this.plannerLevel.isNoneLevel()) {
                throw new IllegalArgumentException("given planner level: " + this.plannerLevel.getClass().getName() + ", may not be NONE");
            }
        }
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Fields getArgumentSelector() {
        return this.argumentSelector;
    }

    public Fields getFieldDeclaration() {
        return this.operation.getFieldDeclaration();
    }

    public Fields getOutputSelector() {
        return this.outputSelector;
    }

    @Deprecated
    public AssertionLevel getAssertionLevel() {
        return (AssertionLevel)this.plannerLevel;
    }

    public PlannerLevel getPlannerLevel() {
        return this.plannerLevel;
    }

    @Deprecated
    public boolean isAssertion() {
        return this.plannerLevel instanceof AssertionLevel;
    }

    public boolean hasPlannerLevel() {
        return this.plannerLevel != null;
    }

    protected Tuple makeResult(Fields outgoingSelector, TupleEntry inputEntry, Fields remainderFields, TupleEntry declaredEntry, Tuple output) {
        if (this.getOutputSelector().isResults()) {
            return output;
        }
        if (this.getOutputSelector().isAll()) {
            return inputEntry.getTuple().append(output);
        }
        if (this.getOutputSelector().isReplace()) {
            Tuple result = new Tuple(inputEntry.getTuple());
            result.set(inputEntry.getFields(), declaredEntry.getFields(), output);
            return result;
        }
        if (this.getOutputSelector().isSwap()) {
            if (remainderFields.size() == 0) {
                return output;
            }
            return inputEntry.selectTuple(remainderFields).append(output);
        }
        declaredEntry.setTuple(output);
        return TupleEntry.select(outgoingSelector, inputEntry, declaredEntry);
    }

    protected Fields resolveRemainderFields(Set<Scope> incomingScopes, Fields argumentFields) {
        Fields fields = this.resolveIncomingOperationFields(this.getFirst(incomingScopes));
        if (fields.isUnknown()) {
            return fields;
        }
        return fields.subtract(argumentFields);
    }

    @Override
    public abstract Scope outgoingScopeFor(Set<Scope> var1);

    void verifyDeclaredFields(Fields declared) {
        if (declared.isDefined() && declared.size() == 0) {
            throw new OperatorException(this, "field declaration: " + this.getFieldDeclaration().printVerbose() + ", resolves to an empty field set, current grouping is on all fields");
        }
    }

    void verifyOutputSelector(Fields outputSelector) {
        if (outputSelector.isDefined() && outputSelector.size() == 0) {
            throw new OperatorException(this, "output selector: " + this.getOutputSelector().printVerbose() + ", resolves to an empty field set, current grouping is on all fields");
        }
    }

    void verifyArguments(Fields argumentSelector) {
        if (argumentSelector.isUnknown()) {
            return;
        }
        if (this.operation.getNumArgs() != Integer.MAX_VALUE && argumentSelector.size() < this.operation.getNumArgs()) {
            throw new OperatorException(this, "resolved wrong number of arguments: " + argumentSelector.printVerbose() + ", expected: " + this.operation.getNumArgs());
        }
    }

    Fields resolveOutgoingSelector(Set<Scope> incomingScopes, Fields argumentFields, Fields declaredFields) {
        Scope incomingScope = this.getFirst(incomingScopes);
        Fields outputSelector = this.getOutputSelector();
        if (outputSelector.isResults()) {
            return declaredFields;
        }
        if (outputSelector.isArguments()) {
            return argumentFields;
        }
        if (outputSelector.isGroup()) {
            return incomingScope.getOutGroupingFields();
        }
        if (outputSelector.isValues()) {
            return incomingScope.getOutValuesFields().subtract(incomingScope.getOutGroupingFields());
        }
        if (outputSelector.isSwap()) {
            return incomingScope.getOutValuesFields().subtract(argumentFields).append(declaredFields);
        }
        Fields incomingFields = this.resolveFields(incomingScope);
        try {
            return Fields.resolve(outputSelector, incomingFields, declaredFields);
        }
        catch (TupleException exception) {
            throw new OperatorException((Pipe)this, incomingFields, declaredFields, outputSelector, (Throwable)exception);
        }
    }

    Fields resolveArgumentSelector(Set<Scope> incomingScopes) {
        Fields argumentSelector = this.getArgumentSelector();
        try {
            Scope incomingScope = this.getFirst(incomingScopes);
            if (argumentSelector.isAll()) {
                return this.resolveIncomingOperationFields(incomingScope);
            }
            if (argumentSelector.isGroup()) {
                return incomingScope.getOutGroupingFields();
            }
            if (argumentSelector.isValues()) {
                return incomingScope.getOutValuesFields().subtract(incomingScope.getOutGroupingFields());
            }
            return this.resolveIncomingOperationFields(incomingScope).select(argumentSelector);
        }
        catch (FieldsResolverException exception) {
            throw new OperatorException((Pipe)this, OperatorException.Kind.argument, exception.getSourceFields(), argumentSelector, (Throwable)exception);
        }
        catch (Exception exception) {
            throw new OperatorException(this, "unable to resolve argument selector: " + argumentSelector.printVerbose(), exception);
        }
    }

    Fields resolveDeclared(Set<Scope> incomingScopes, Fields arguments) {
        Fields fieldDeclaration = this.getFieldDeclaration();
        try {
            Scope incomingScope = this.getFirst(incomingScopes);
            if (fieldDeclaration.isUnknown()) {
                return fieldDeclaration;
            }
            if (fieldDeclaration.isArguments()) {
                return Fields.asDeclaration(arguments);
            }
            if (fieldDeclaration.isAll()) {
                return this.resolveFields(incomingScope);
            }
            if (fieldDeclaration.isGroup()) {
                return incomingScope.getOutGroupingFields();
            }
            if (fieldDeclaration.isValues()) {
                return incomingScope.getOutValuesFields().subtract(incomingScope.getOutGroupingFields());
            }
        }
        catch (Exception exception) {
            throw new OperatorException(this, "could not resolve declared fields in:  " + this, exception);
        }
        if (this.getOutputSelector().isReplace()) {
            if (arguments.isDefined() && fieldDeclaration.isDefined() && arguments.size() != fieldDeclaration.size()) {
                throw new OperatorException(this, "during REPLACE both the arguments selector and field declaration must be the same size, arguments: " + arguments.printVerbose() + " declaration: " + fieldDeclaration.printVerbose());
            }
            return arguments.project(fieldDeclaration);
        }
        return fieldDeclaration;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.operation + "]";
    }

    @Override
    protected void printInternal(StringBuffer buffer, Scope scope) {
        super.printInternal(buffer, scope);
        buffer.append("[");
        BaseOperation.printOperationInternal(this.operation, buffer, scope);
        buffer.append("]");
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Operator operator = (Operator)object;
        if (this.argumentSelector != null ? !this.argumentSelector.equals(operator.argumentSelector) : operator.argumentSelector != null) {
            return false;
        }
        if (this.operation != null ? !this.operation.equals(operator.operation) : operator.operation != null) {
            return false;
        }
        return !(this.outputSelector != null ? !this.outputSelector.equals(operator.outputSelector) : operator.outputSelector != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.operation != null ? this.operation.hashCode() : 0);
        result = 31 * result + (this.argumentSelector != null ? this.argumentSelector.hashCode() : 0);
        result = 31 * result + (this.outputSelector != null ? this.outputSelector.hashCode() : 0);
        return result;
    }
}

