/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.flow.hadoop.HadoopUtil;
import cascading.scheme.Scheme;
import cascading.scheme.SequenceFile;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.hadoop.TapCollector;
import cascading.tap.hadoop.TapIterator;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3native.NativeS3FileSystem;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;

public class Hfs
extends Tap {
    private static final Logger LOG = Logger.getLogger(Hfs.class);
    private static final long serialVersionUID = 1L;
    private static final String TEMPORARY_DIRECTORY = "cascading.tmp.dir";
    String stringPath;
    transient URI uriScheme;
    transient Path path;
    private transient FileStatus[] statuses;

    public static void setTemporaryDirectory(Map<Object, Object> properties, String tempDir) {
        properties.put(TEMPORARY_DIRECTORY, tempDir);
    }

    public static String getTemporaryDirectory(Map<Object, Object> properties) {
        return (String)properties.get(TEMPORARY_DIRECTORY);
    }

    protected Hfs() {
    }

    @ConstructorProperties(value={"scheme"})
    protected Hfs(Scheme scheme) {
        super(scheme);
    }

    @ConstructorProperties(value={"fields", "stringPath"})
    public Hfs(Fields fields, String stringPath) {
        super(new SequenceFile(fields));
        this.setStringPath(stringPath);
    }

    @ConstructorProperties(value={"fields", "stringPath", "replace"})
    public Hfs(Fields fields, String stringPath, boolean replace) {
        super(new SequenceFile(fields), replace ? SinkMode.REPLACE : SinkMode.KEEP);
        this.setStringPath(stringPath);
    }

    @ConstructorProperties(value={"fields", "stringPath", "sinkMode"})
    public Hfs(Fields fields, String stringPath, SinkMode sinkMode) {
        super(new SequenceFile(fields), sinkMode);
        this.setStringPath(stringPath);
        if (sinkMode == SinkMode.UPDATE) {
            throw new IllegalArgumentException("updates are not supported");
        }
    }

    @ConstructorProperties(value={"scheme", "stringPath"})
    public Hfs(Scheme scheme, String stringPath) {
        super(scheme);
        this.setStringPath(stringPath);
    }

    @ConstructorProperties(value={"scheme", "stringPath", "replace"})
    public Hfs(Scheme scheme, String stringPath, boolean replace) {
        super(scheme, replace ? SinkMode.REPLACE : SinkMode.KEEP);
        this.setStringPath(stringPath);
    }

    @ConstructorProperties(value={"scheme", "stringPath", "sinkMode"})
    public Hfs(Scheme scheme, String stringPath, SinkMode sinkMode) {
        super(scheme, sinkMode);
        this.setStringPath(stringPath);
    }

    protected void setStringPath(String stringPath) {
        this.stringPath = Util.normalizeUrl(stringPath);
    }

    protected void setUriScheme(URI uriScheme) {
        this.uriScheme = uriScheme;
    }

    public URI getURIScheme(JobConf jobConf) throws IOException {
        if (this.uriScheme != null) {
            return this.uriScheme;
        }
        this.uriScheme = this.makeURIScheme(jobConf);
        return this.uriScheme;
    }

    protected URI makeURIScheme(JobConf jobConf) throws IOException {
        try {
            URI uriScheme = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("handling path: " + this.stringPath));
            }
            URI uri = new URI(this.stringPath);
            String schemeString = uri.getScheme();
            String authority = uri.getAuthority();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("found scheme: " + schemeString));
                LOG.debug((Object)("found authority: " + authority));
            }
            uriScheme = schemeString != null && authority != null ? new URI(schemeString + "://" + uri.getAuthority()) : (schemeString != null ? new URI(schemeString + ":///") : this.getDefaultFileSystemURIScheme(jobConf));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("using uri scheme: " + uriScheme));
            }
            return uriScheme;
        }
        catch (URISyntaxException exception) {
            throw new TapException("could not determine scheme from path: " + this.getPath(), exception);
        }
    }

    public URI getDefaultFileSystemURIScheme(JobConf jobConf) throws IOException {
        return this.getDefaultFileSystem(jobConf).getUri();
    }

    @Override
    public boolean isWriteDirect() {
        return super.isWriteDirect() || this.stringPath != null && this.stringPath.matches("(^https?://.*$)|(^s3tp://.*$)");
    }

    protected FileSystem getDefaultFileSystem(JobConf jobConf) throws IOException {
        return FileSystem.get((Configuration)jobConf);
    }

    protected FileSystem getFileSystem(JobConf jobConf) throws IOException {
        return FileSystem.get((URI)this.getURIScheme(jobConf), (Configuration)jobConf);
    }

    @Override
    public Path getPath() {
        if (this.path != null) {
            return this.path;
        }
        if (this.stringPath == null) {
            throw new IllegalStateException("path not initialized");
        }
        this.path = new Path(this.stringPath);
        return this.path;
    }

    @Override
    public Path getQualifiedPath(JobConf conf) throws IOException {
        return this.getPath().makeQualified(this.getFileSystem(conf));
    }

    @Override
    public void sourceInit(JobConf conf) throws IOException {
        Path qualifiedPath = this.getQualifiedPath(conf);
        for (Path exitingPath : FileInputFormat.getInputPaths((JobConf)conf)) {
            if (!exitingPath.equals((Object)qualifiedPath)) continue;
            throw new TapException("may not add duplicate paths, found: " + exitingPath);
        }
        FileInputFormat.addInputPath((JobConf)conf, (Path)qualifiedPath);
        super.sourceInit(conf);
        this.makeLocal(conf, qualifiedPath, "forcing job to local mode, via source: ");
        TupleSerialization.setSerializations(conf);
    }

    @Override
    public void sinkInit(JobConf conf) throws IOException {
        if (this.isReplace() && conf.get("mapred.task.partition") == null) {
            this.deletePath(conf);
        }
        Path qualifiedPath = this.getQualifiedPath(conf);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)qualifiedPath);
        super.sinkInit(conf);
        this.makeLocal(conf, qualifiedPath, "forcing job to local mode, via sink: ");
        TupleSerialization.setSerializations(conf);
    }

    private void makeLocal(JobConf conf, Path qualifiedPath, String infoMessage) {
        if (!conf.get("mapred.job.tracker", "").equalsIgnoreCase("local") && qualifiedPath.toUri().getScheme().equalsIgnoreCase("file")) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(infoMessage + this.toString()));
            }
            conf.set("mapred.job.tracker", "local");
        }
    }

    @Override
    public boolean makeDirs(JobConf conf) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("making dirs: " + this.getQualifiedPath(conf)));
        }
        return this.getFileSystem(conf).mkdirs(this.getPath());
    }

    @Override
    public boolean deletePath(JobConf conf) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deleting: " + this.getQualifiedPath(conf)));
        }
        if (this.getQualifiedPath(conf).depth() == 0) {
            return true;
        }
        FileSystem fileSystem = this.getFileSystem(conf);
        try {
            return fileSystem.delete(this.getPath(), true);
        }
        catch (NullPointerException exception) {
            if (!(fileSystem instanceof NativeS3FileSystem)) {
                throw exception;
            }
            return true;
        }
    }

    @Override
    public boolean pathExists(JobConf conf) throws IOException {
        return this.getFileSystem(conf).exists(this.getPath());
    }

    @Override
    public long getPathModified(JobConf conf) throws IOException {
        FileStatus fileStatus = this.getFileSystem(conf).getFileStatus(this.getPath());
        if (!fileStatus.isDir()) {
            return fileStatus.getModificationTime();
        }
        this.makeStatuses(conf);
        if (this.statuses == null || this.statuses.length == 0) {
            return 0L;
        }
        long date = 0L;
        for (FileStatus status : this.statuses) {
            if (status.isDir()) continue;
            date = Math.max(date, status.getModificationTime());
        }
        return date;
    }

    protected Path getTempPath(JobConf conf) {
        String tempDir = conf.get(TEMPORARY_DIRECTORY);
        if (tempDir == null) {
            tempDir = conf.get("hadoop.tmp.dir");
        }
        return new Path(tempDir);
    }

    protected String makeTemporaryPathDir(String name) {
        if ((name = name.replaceAll("^[_\\W\\s]+", "")).isEmpty()) {
            name = "temp-path";
        }
        return name.replaceAll("[\\W\\s]+", "_") + Integer.toString((int)(1.0E7 * Math.random()));
    }

    private void makeStatuses(JobConf conf) throws IOException {
        if (this.statuses != null) {
            return;
        }
        this.statuses = this.getFileSystem(conf).listStatus(this.getPath());
    }

    public String toString() {
        if (this.stringPath != null) {
            return this.getClass().getSimpleName() + "[\"" + this.getScheme() + "\"]" + "[\"" + Util.sanitizeUrl(this.stringPath) + "\"]";
        }
        return this.getClass().getSimpleName() + "[\"" + this.getScheme() + "\"]" + "[not initialized]";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Hfs hfs = (Hfs)object;
        return !(this.stringPath != null ? !this.stringPath.equals(hfs.stringPath) : hfs.stringPath != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.stringPath != null ? this.stringPath.hashCode() : 0);
        return result;
    }

    @Override
    public TupleEntryIterator openForRead(JobConf conf) throws IOException {
        Map<Object, Object> properties = HadoopUtil.createProperties(conf);
        properties.remove("mapred.input.dir");
        conf = HadoopUtil.createJobConf(properties, null);
        return new TupleEntryIterator(this.getSourceFields(), new TapIterator(this, conf));
    }

    @Override
    public TupleEntryCollector openForWrite(JobConf conf) throws IOException {
        return new TapCollector(this, conf);
    }
}

