/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.operation.OperationException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleException;

public class Tuples {
    public static final Tuple NULL = Tuples.asUnmodifiable(new Tuple());

    public static Object[] asArray(Tuple tuple, Object[] destination) {
        if (tuple.size() != destination.length) {
            throw new OperationException("number of input tuple values: " + tuple.size() + ", does not match destination array size: " + destination.length);
        }
        return tuple.elements(destination);
    }

    public static Object[] asArray(Tuple tuple, Class[] types) {
        return Tuples.asArray(tuple, types, new Object[tuple.size()]);
    }

    public static Object[] asArray(Tuple tuple, Class[] types, Object[] destination) {
        if (tuple.size() != types.length) {
            throw new OperationException("number of input tuple values: " + tuple.size() + ", does not match number of coercion types: " + types.length);
        }
        for (int i = 0; i < types.length; ++i) {
            destination[i] = Tuples.coerce(tuple, i, types[i]);
        }
        return destination;
    }

    public static Object coerce(Tuple tuple, int pos, Class type) {
        Object value = tuple.getObject(pos);
        return Tuples.coerce(value, type);
    }

    public static Object coerce(Object value, Class type) {
        if (value != null && type == value.getClass()) {
            return value;
        }
        if (type == Object.class) {
            return value;
        }
        if (type == String.class) {
            return Tuples.toString(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Tuples.toInteger(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return Tuples.toLong(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return Tuples.toDouble(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(Tuples.toFloat(value));
        }
        if (type == Short.class || type == Short.TYPE) {
            return Tuples.toShort(value);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Tuples.toBoolean(value);
        }
        if (type != null) {
            throw new OperationException("could not coerce value, " + value + " to type: " + type.getName());
        }
        return null;
    }

    public static final String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static final int toInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value.toString());
    }

    public static final long toLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value == null) {
            return 0L;
        }
        return Long.parseLong(value.toString());
    }

    public static final double toDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value == null) {
            return 0.0;
        }
        return Double.parseDouble(value.toString());
    }

    public static final float toFloat(Object value) {
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value == null) {
            return 0.0f;
        }
        return Float.parseFloat(value.toString());
    }

    public static final short toShort(Object value) {
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value == null) {
            return 0;
        }
        return Short.parseShort(value.toString());
    }

    public static final boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public static Tuple coerce(Tuple tuple, Class[] types) {
        return new Tuple(Tuples.asArray(tuple, types, new Object[types.length]));
    }

    public static Tuple extractTuple(TupleEntry tupleEntry, Fields selector) {
        if (selector == null || selector.isAll()) {
            Tuple result = tupleEntry.tuple;
            tupleEntry.tuple = Tuple.size(result.size());
            return result;
        }
        try {
            return Tuples.extract(tupleEntry, selector);
        }
        catch (Exception exception) {
            throw new TupleException("unable to select from: " + tupleEntry.fields.print() + ", using selector: " + selector.print(), exception);
        }
    }

    public static Tuple extract(TupleEntry tupleEntry, Fields selector) {
        return tupleEntry.tuple.extract(tupleEntry.fields.getPos(selector, tupleEntry.fields.size()));
    }

    public static Tuple setOnEmpty(TupleEntry baseEntry, TupleEntry valuesEntry) {
        Tuple emptyTuple = Tuple.size(baseEntry.getFields().size());
        emptyTuple.set(baseEntry.getFields(), valuesEntry.getFields(), valuesEntry.getTuple());
        return emptyTuple;
    }

    public static Tuple asUnmodifiable(Tuple tuple) {
        tuple.isUnmodifiable = true;
        return tuple;
    }

    public static Tuple asModifiable(Tuple tuple) {
        tuple.isUnmodifiable = false;
        return tuple;
    }
}

