/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stack;

import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.Scope;
import cascading.flow.stack.MapperStackElement;
import cascading.flow.stack.StackElement;
import cascading.pipe.Each;
import cascading.tap.Tap;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.Tuples;

class EachMapperStackElement
extends MapperStackElement {
    private final Each each;
    private Each.EachHandler eachHandler;

    public EachMapperStackElement(MapperStackElement previous, FlowProcess flowProcess, Scope incomingScope, Tap trap, Each each) {
        super(previous, flowProcess, incomingScope, each.getName(), trap);
        this.each = each;
    }

    @Override
    protected FlowElement getFlowElement() {
        return this.each;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    StackElement setNext(StackElement next) {
        try {
            StackElement stackElement = super.setNext(next);
            return stackElement;
        }
        finally {
            this.eachHandler = this.each.getHandler(next, ((MapperStackElement)next).getIncomingScope());
        }
    }

    @Override
    public void prepare() {
        this.eachHandler.prepare(this.flowProcess);
    }

    @Override
    public void cleanup() {
        this.eachHandler.cleanup(this.flowProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collect(Tuple tuple) {
        super.collect(tuple);
        try {
            this.operateEach(this.getTupleEntry(tuple));
        }
        finally {
            Tuples.asModifiable(tuple);
        }
    }

    private void operateEach(TupleEntry tupleEntry) {
        try {
            this.eachHandler.operate(this.flowProcess, tupleEntry);
        }
        catch (Exception exception) {
            this.handleException(exception, tupleEntry);
        }
    }
}

