/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stack;

import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.Scope;
import cascading.flow.stack.ReducerStackElement;
import cascading.flow.stack.StackElement;
import cascading.pipe.Every;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class EveryAllAggregatorReducerStackElement
extends ReducerStackElement {
    private final Map<String, Tap> traps;
    private final List<Every.EveryHandler> everyHandlers;

    public EveryAllAggregatorReducerStackElement(StackElement previous, FlowProcess flowProcess, Scope incomingScope, Map<String, Tap> traps, List<Every.EveryHandler> everyHandlers) {
        super(previous, flowProcess, incomingScope, null, null);
        this.traps = traps;
        this.everyHandlers = everyHandlers;
    }

    @Override
    public FlowElement getFlowElement() {
        return null;
    }

    @Override
    protected Fields resolveIncomingOperationFields() {
        return ((ReducerStackElement)this.next).resolveIncomingOperationFields();
    }

    @Override
    public void collect(Tuple key, Iterator values) {
        this.operateEveryHandlers(this.getGroupingTupleEntry(key), values);
    }

    private void operateEveryHandlers(TupleEntry keyEntry, Iterator values) {
        if (!values.hasNext()) {
            return;
        }
        for (Every.EveryHandler handler : this.everyHandlers) {
            try {
                handler.start(this.flowProcess, keyEntry);
            }
            catch (Exception exception) {
                String trapName = handler.getEvery().getName();
                this.handleException(trapName, this.traps.get(trapName), exception, keyEntry);
            }
        }
        while (values.hasNext()) {
            TupleEntry valueEntry = (TupleEntry)values.next();
            for (Every.EveryHandler handler : this.everyHandlers) {
                try {
                    handler.operate(this.flowProcess, null, valueEntry, null);
                }
                catch (Exception exception) {
                    String trapName = handler.getEvery().getName();
                    this.handleException(trapName, this.traps.get(trapName), exception, valueEntry);
                }
            }
        }
        this.next.collect(keyEntry.getTuple());
    }

    @Override
    public void prepare() {
    }

    @Override
    public void cleanup() {
    }
}

