/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.assertion;

import cascading.operation.AssertionException;
import cascading.operation.AssertionLevel;
import cascading.operation.BaseOperation;
import cascading.operation.PlannedOperation;
import cascading.operation.PlannerLevel;
import cascading.util.Util;
import java.beans.ConstructorProperties;

public abstract class BaseAssertion<C>
extends BaseOperation<C>
implements PlannedOperation<C> {
    private String message;

    protected BaseAssertion() {
    }

    @ConstructorProperties(value={"message"})
    protected BaseAssertion(String message) {
        this.message = message;
    }

    @ConstructorProperties(value={"numArgs"})
    protected BaseAssertion(int numArgs) {
        super(numArgs);
    }

    @ConstructorProperties(value={"numArgs", "message"})
    protected BaseAssertion(int numArgs, String message) {
        super(numArgs);
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public boolean supportsPlannerLevel(PlannerLevel plannerLevel) {
        return plannerLevel instanceof AssertionLevel;
    }

    protected void fail() {
        BaseAssertion.throwFail(Util.formatTrace(this, this.getMessage()));
    }

    protected void fail(Object ... args) {
        BaseAssertion.throwFail(Util.formatTrace(this, this.getMessage()), args);
    }

    public static void throwFail(String message) {
        throw new AssertionException(message);
    }

    public static void throwFail(String message, Object ... args) {
        throw new AssertionException(String.format(message, args));
    }
}

