/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.function;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;
import java.io.Serializable;

public class SetValue
extends BaseOperation
implements Function {
    private final Filter filter;
    private Serializable[] values = new Serializable[]{Boolean.valueOf(true), Boolean.valueOf(false)};

    @ConstructorProperties(value={"fieldDeclaration", "filter"})
    public SetValue(Fields fieldDeclaration, Filter filter) {
        super(fieldDeclaration);
        this.filter = filter;
        this.verify();
    }

    @ConstructorProperties(value={"fieldDeclaration", "filter", "values"})
    public SetValue(Fields fieldDeclaration, Filter filter, Serializable firstValue, Serializable secondValue) {
        super(fieldDeclaration);
        this.filter = filter;
        this.values = new Serializable[]{firstValue, secondValue};
        this.verify();
    }

    private void verify() {
        if (this.fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("fieldDeclaration may only declare one field, was " + this.fieldDeclaration.print());
        }
        if (this.filter == null) {
            throw new IllegalArgumentException("filter may not be null");
        }
        if (this.values == null || this.values.length != 2) {
            throw new IllegalArgumentException("values argument must contain two values");
        }
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall operationCall) {
        this.filter.prepare(flowProcess, operationCall);
    }

    @Override
    public void cleanup(FlowProcess flowProcess, OperationCall operationCall) {
        this.filter.cleanup(flowProcess, operationCall);
    }

    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        boolean isRemove = !this.filter.isRemove(flowProcess, (FilterCall)((Object)functionCall));
        int pos = isRemove ? 0 : 1;
        functionCall.getOutputCollector().add(new Tuple(this.values[pos]));
    }
}

