/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.function;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class UnGroup
extends BaseOperation
implements Function {
    private static final Logger LOG = Logger.getLogger(UnGroup.class);
    private Fields groupFieldSelector;
    private Fields[] resultFieldSelectors;
    private int size = 1;

    @ConstructorProperties(value={"groupSelector", "valueSelectors"})
    public UnGroup(Fields groupSelector, Fields[] valueSelectors) {
        int size = 0;
        for (Fields resultFieldSelector : valueSelectors) {
            size = resultFieldSelector.size();
            this.numArgs = groupSelector.size() + size;
            if (this.fieldDeclaration.size() == this.numArgs) continue;
            throw new IllegalArgumentException("all field selectors must be the same size, and this size plus group selector size must equal the declared field size");
        }
        this.groupFieldSelector = groupSelector;
        this.resultFieldSelectors = Arrays.copyOf(valueSelectors, valueSelectors.length);
        this.fieldDeclaration = Fields.size(groupSelector.size() + size);
    }

    @ConstructorProperties(value={"fieldDeclaration", "groupSelector", "valueSelectors"})
    public UnGroup(Fields fieldDeclaration, Fields groupSelector, Fields[] valueSelectors) {
        super(fieldDeclaration);
        this.numArgs = groupSelector.size();
        int selectorSize = -1;
        for (Fields resultFieldSelector : valueSelectors) {
            this.numArgs += resultFieldSelector.size();
            int fieldSize = groupSelector.size() + resultFieldSelector.size();
            if (selectorSize != -1 && selectorSize != resultFieldSelector.size()) {
                throw new IllegalArgumentException("all field selectors must be the same size, and this size plus group selector size must equal the declared field size");
            }
            selectorSize = resultFieldSelector.size();
            if (fieldDeclaration.size() == fieldSize) continue;
            throw new IllegalArgumentException("all field selectors must be the same size, and this size plus group selector size must equal the declared field size");
        }
        this.groupFieldSelector = groupSelector;
        this.resultFieldSelectors = Arrays.copyOf(valueSelectors, valueSelectors.length);
    }

    @ConstructorProperties(value={"fieldDeclaration", "groupSelector", "numValues"})
    public UnGroup(Fields fieldDeclaration, Fields groupSelector, int numValues) {
        super(fieldDeclaration);
        this.groupFieldSelector = groupSelector;
        this.size = numValues;
    }

    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        if (this.resultFieldSelectors != null) {
            this.useResultSelectors(functionCall.getArguments(), functionCall.getOutputCollector());
        } else {
            this.useSize(functionCall.getArguments(), functionCall.getOutputCollector());
        }
    }

    private void useSize(TupleEntry input, TupleEntryCollector outputCollector) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("using size: " + this.size));
        }
        Tuple tuple = new Tuple(input.getTuple());
        Tuple group = tuple.remove(input.getFields(), this.groupFieldSelector);
        for (int i = 0; i < tuple.size(); i += this.size) {
            Tuple result = new Tuple(group);
            result.addAll(tuple.get(Fields.offsetSelector(this.size, i).getPos()));
            outputCollector.add(result);
        }
    }

    private void useResultSelectors(TupleEntry input, TupleEntryCollector outputCollector) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("using result selectors: " + this.resultFieldSelectors.length));
        }
        for (Fields resultFieldSelector : this.resultFieldSelectors) {
            Tuple group = input.selectTuple(this.groupFieldSelector);
            group.addAll(input.selectTuple(resultFieldSelector));
            outputCollector.add(group);
        }
    }
}

