/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.flow.FlowProcess;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.operation.regex.RegexOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;
import java.util.regex.Matcher;

public class RegexGenerator
extends RegexOperation<Matcher>
implements Function<Matcher> {
    @ConstructorProperties(value={"patternString"})
    public RegexGenerator(String patternString) {
        super(1, Fields.size(1), patternString);
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString"})
    public RegexGenerator(Fields fieldDeclaration, String patternString) {
        super(1, fieldDeclaration, patternString);
        if (fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("fieldDeclaration may only declare one field, was " + fieldDeclaration.print());
        }
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Matcher> operationCall) {
        operationCall.setContext(this.getPattern().matcher(""));
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Matcher> functionCall) {
        String value = functionCall.getArguments().getString(Integer.valueOf(0));
        if (value == null) {
            value = "";
        }
        Matcher matcher = ((Matcher)functionCall.getContext()).reset(value);
        while (matcher.find()) {
            functionCall.getOutputCollector().add(new Tuple(matcher.group()));
        }
    }
}

