/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.flow.FlowProcess;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.operation.OperationException;
import cascading.operation.regex.RegexOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.regex.Matcher;

public class RegexParser
extends RegexOperation<Matcher>
implements Function<Matcher> {
    private int[] groups = null;

    @ConstructorProperties(value={"patternString"})
    public RegexParser(String patternString) {
        super(1, patternString);
    }

    @ConstructorProperties(value={"fieldDeclaration", "pattenString"})
    public RegexParser(Fields fieldDeclaration, String patternString) {
        super(1, fieldDeclaration, patternString);
    }

    @ConstructorProperties(value={"patternString", "groups"})
    public RegexParser(String patternString, int[] groups) {
        super(1, Fields.size(groups.length), patternString);
        this.groups = Arrays.copyOf(groups, groups.length);
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString", "groups"})
    public RegexParser(Fields fieldDeclaration, String patternString, int[] groups) {
        super(1, fieldDeclaration, patternString);
        this.groups = Arrays.copyOf(groups, groups.length);
        if (!fieldDeclaration.isUnknown() && fieldDeclaration.size() != groups.length) {
            throw new IllegalArgumentException("fieldDeclaration must equal number of groups to be captured, fields: " + fieldDeclaration.print());
        }
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Matcher> operationCall) {
        operationCall.setContext(this.getPattern().matcher(""));
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Matcher> functionCall) {
        Matcher matcher;
        String value = functionCall.getArguments().getString(Integer.valueOf(0));
        if (value == null) {
            value = "";
        }
        if (!(matcher = ((Matcher)functionCall.getContext()).reset(value)).find()) {
            throw new OperationException("could not match pattern: [" + this.getPattern() + "] with value: [" + value + "]");
        }
        Tuple output = new Tuple();
        if (this.groups != null) {
            this.onGivenGroups(functionCall, matcher, output);
        } else {
            this.onFoundGroups(functionCall, matcher, output);
        }
    }

    private final void onFoundGroups(FunctionCall<Matcher> functionCall, Matcher matcher, Tuple output) {
        int count = matcher.groupCount();
        if (count == 0) {
            output.add(matcher.group(0));
        } else {
            for (int i = 0; i < count; ++i) {
                output.add(matcher.group(i + 1));
            }
        }
        functionCall.getOutputCollector().add(output);
    }

    private final void onGivenGroups(FunctionCall<Matcher> functionCall, Matcher matcher, Tuple output) {
        for (int pos : this.groups) {
            output.add(matcher.group(pos));
        }
        functionCall.getOutputCollector().add(output);
    }
}

