/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.text;

import cascading.operation.BaseOperation;
import cascading.tuple.Fields;
import java.beans.ConstructorProperties;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateOperation
extends BaseOperation {
    protected TimeZone zone;
    protected Locale locale;
    final String dateFormatString;
    transient SimpleDateFormat dateFormat;

    @ConstructorProperties(value={"numArgs", "fieldDeclaration", "dateFormatString"})
    public DateOperation(int numArgs, Fields fieldDeclaration, String dateFormatString) {
        super(numArgs, fieldDeclaration);
        this.dateFormatString = dateFormatString;
        if (!fieldDeclaration.isSubstitution() && fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("fieldDeclaration may only declare one field name, got " + fieldDeclaration.print());
        }
    }

    @ConstructorProperties(value={"numArgs", "fieldDeclaration", "dateFormatString", "zone", "locale"})
    public DateOperation(int numArgs, Fields fieldDeclaration, String dateFormatString, TimeZone zone, Locale locale) {
        super(numArgs, fieldDeclaration);
        this.dateFormatString = dateFormatString;
        this.zone = zone;
        this.locale = locale;
    }

    public SimpleDateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat(this.dateFormatString, this.getLocale());
            this.dateFormat.setTimeZone(this.getZone());
        }
        return this.dateFormat;
    }

    private Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return Locale.getDefault();
    }

    private TimeZone getZone() {
        if (this.zone != null) {
            return this.zone;
        }
        return TimeZone.getTimeZone("UTC");
    }

    protected Calendar getCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"), this.getLocale());
    }
}

