/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.text;

import cascading.flow.FlowProcess;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationException;
import cascading.operation.text.DateOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateParser
extends DateOperation
implements Function {
    public static final String FIELD_NAME = "ts";
    private int[] calendarFields;

    @ConstructorProperties(value={"dateFormatString"})
    public DateParser(String dateFormatString) {
        super(1, new Fields(new Comparable[]{FIELD_NAME}), dateFormatString);
    }

    @ConstructorProperties(value={"fieldDeclaration", "dateFormatString"})
    public DateParser(Fields fieldDeclaration, String dateFormatString) {
        super(1, fieldDeclaration, dateFormatString);
    }

    @ConstructorProperties(value={"fieldDeclaration", "calendarFields", "dateFormatString"})
    public DateParser(Fields fieldDeclaration, int[] calendarFields, String dateFormatString) {
        this(fieldDeclaration, calendarFields, null, null, dateFormatString);
    }

    @ConstructorProperties(value={"fieldDeclaration", "zone", "locale", "dateFormatString"})
    public DateParser(Fields fieldDeclaration, TimeZone zone, Locale locale, String dateFormatString) {
        this(fieldDeclaration, null, zone, locale, dateFormatString);
    }

    @ConstructorProperties(value={"fieldDeclaration", "calendarFields", "zone", "locale", "dateFormatString"})
    public DateParser(Fields fieldDeclaration, int[] calendarFields, TimeZone zone, Locale locale, String dateFormatString) {
        super(1, fieldDeclaration, dateFormatString, zone, locale);
        if (calendarFields != null) {
            this.calendarFields = Arrays.copyOf(calendarFields, calendarFields.length);
            if (fieldDeclaration.size() != calendarFields.length) {
                throw new IllegalArgumentException("fieldDeclaration must be same size as calendarFields, was " + fieldDeclaration.print() + " with calendar size: " + calendarFields.length);
            }
        } else if (!fieldDeclaration.isSubstitution() && fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("fieldDeclaration may only declare one field name, got " + fieldDeclaration.print());
        }
    }

    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        Tuple output = new Tuple();
        try {
            Date date = this.getDateFormat().parse((String)functionCall.getArguments().getObject(Integer.valueOf(0)));
            if (this.calendarFields == null) {
                output.add(date.getTime());
            } else {
                this.makeCalendarFields(output, date);
            }
        }
        catch (ParseException exception) {
            throw new OperationException("unable to parse input value: " + functionCall.getArguments().getObject(Integer.valueOf(0)), exception);
        }
        functionCall.getOutputCollector().add(output);
    }

    private void makeCalendarFields(Tuple output, Date date) {
        Calendar calendar = this.getCalendar();
        calendar.setTime(date);
        for (int i = 0; i < this.calendarFields.length; ++i) {
            output.add(calendar.get(this.calendarFields[i]));
        }
    }
}

