/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe;

import cascading.CascadingException;
import cascading.flow.FlowCollector;
import cascading.flow.FlowProcess;
import cascading.flow.Scope;
import cascading.operation.Aggregator;
import cascading.operation.AssertionLevel;
import cascading.operation.Buffer;
import cascading.operation.ConcreteCall;
import cascading.operation.GroupAssertion;
import cascading.operation.Operation;
import cascading.operation.PlannedOperation;
import cascading.operation.PlannerLevel;
import cascading.pipe.Operator;
import cascading.pipe.OperatorException;
import cascading.pipe.Pipe;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.Tuples;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.Set;

public class Every
extends Operator {
    private static final Fields AGGREGATOR_ARGUMENTS = Fields.ALL;
    private static final Fields AGGREGATOR_SELECTOR = Fields.ALL;
    private static final Fields ASSERTION_SELECTOR = Fields.RESULTS;

    @ConstructorProperties(value={"previous", "aggregator"})
    public Every(Pipe previous, Aggregator aggregator) {
        super(previous, AGGREGATOR_ARGUMENTS, (Operation)aggregator, AGGREGATOR_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "aggregator"})
    public Every(Pipe previous, Fields argumentSelector, Aggregator aggregator) {
        super(previous, argumentSelector, (Operation)aggregator, AGGREGATOR_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "aggregator", "outputSelector"})
    public Every(Pipe previous, Fields argumentSelector, Aggregator aggregator, Fields outputSelector) {
        super(previous, argumentSelector, (Operation)aggregator, outputSelector);
    }

    @ConstructorProperties(value={"previous", "aggregator", "outputSelector"})
    public Every(Pipe previous, Aggregator aggregator, Fields outputSelector) {
        super(previous, AGGREGATOR_ARGUMENTS, (Operation)aggregator, outputSelector);
    }

    @ConstructorProperties(value={"previous", "buffer"})
    public Every(Pipe previous, Buffer buffer) {
        super(previous, AGGREGATOR_ARGUMENTS, (Operation)buffer, AGGREGATOR_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "buffer"})
    public Every(Pipe previous, Fields argumentSelector, Buffer buffer) {
        super(previous, argumentSelector, (Operation)buffer, AGGREGATOR_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "buffer", "outputSelector"})
    public Every(Pipe previous, Fields argumentSelector, Buffer buffer, Fields outputSelector) {
        super(previous, argumentSelector, (Operation)buffer, outputSelector);
    }

    @ConstructorProperties(value={"previous", "buffer", "outputSelector"})
    public Every(Pipe previous, Buffer buffer, Fields outputSelector) {
        super(previous, AGGREGATOR_ARGUMENTS, (Operation)buffer, outputSelector);
    }

    @ConstructorProperties(value={"previous", "assertionLevel", "assertion"})
    public Every(Pipe previous, AssertionLevel assertionLevel, GroupAssertion assertion) {
        super(previous, AGGREGATOR_ARGUMENTS, (PlannerLevel)assertionLevel, (PlannedOperation)assertion, ASSERTION_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "assertionLevel", "assertion"})
    public Every(Pipe previous, Fields argumentSelector, AssertionLevel assertionLevel, GroupAssertion assertion) {
        super(previous, argumentSelector, (PlannerLevel)assertionLevel, (PlannedOperation)assertion, ASSERTION_SELECTOR);
    }

    public boolean isBuffer() {
        return this.operation instanceof Buffer;
    }

    public boolean isAggregator() {
        return this.operation instanceof Aggregator;
    }

    private Aggregator getAggregator() {
        return (Aggregator)this.operation;
    }

    private Buffer getReducer() {
        return (Buffer)this.operation;
    }

    private GroupAssertion getGroupAssertion() {
        return (GroupAssertion)this.operation;
    }

    @Override
    public Fields resolveIncomingOperationFields(Scope incomingScope) {
        if (incomingScope.isEach() || incomingScope.isTap()) {
            throw new IllegalStateException("Every cannot follow a Tap or an Each");
        }
        return incomingScope.getOutValuesFields();
    }

    @Override
    public Fields resolveFields(Scope scope) {
        if (scope.isEach() || scope.isTap()) {
            throw new IllegalStateException("Every cannot follow a Tap or an Each");
        }
        if (this.isBuffer()) {
            return scope.getOutValuesFields();
        }
        return scope.getOutGroupingFields();
    }

    @Override
    public Scope outgoingScopeFor(Set<Scope> incomingScopes) {
        Fields argumentFields = this.resolveArgumentSelector(incomingScopes);
        this.verifyArguments(argumentFields);
        Scope scope = this.getFirst(incomingScopes);
        if (scope.isEvery() && argumentFields.contains(scope.getDeclaredFields())) {
            throw new OperatorException(this, "arguments may not select a declared field from a previous Every");
        }
        Fields declaredFields = this.resolveDeclared(incomingScopes, argumentFields);
        this.verifyDeclaredFields(declaredFields);
        Fields outgoingGroupingFields = this.resolveOutgoingGroupingSelector(incomingScopes, argumentFields, declaredFields);
        this.verifyOutputSelector(outgoingGroupingFields);
        Fields outgoingValuesFields = this.resolveOutgoingValues(incomingScopes);
        Fields remainderFields = this.resolveRemainderFields(incomingScopes, argumentFields);
        return new Scope(this.getName(), Scope.Kind.EVERY, remainderFields, argumentFields, declaredFields, outgoingGroupingFields, outgoingValuesFields);
    }

    Fields resolveOutgoingGroupingSelector(Set<Scope> incomingScopes, Fields argumentSelector, Fields declared) {
        try {
            return this.resolveOutgoingSelector(incomingScopes, argumentSelector, declared);
        }
        catch (Exception exception) {
            if (exception instanceof OperatorException) {
                throw (OperatorException)exception;
            }
            if (this.isBuffer()) {
                throw new OperatorException(this, "could not resolve outgoing values selector in: " + this, exception);
            }
            throw new OperatorException(this, "could not resolve outgoing grouping selector in: " + this, exception);
        }
    }

    Fields resolveOutgoingValues(Set<Scope> incomingScopes) {
        try {
            return this.getFirst(incomingScopes).getOutValuesFields();
        }
        catch (Exception exception) {
            throw new OperatorException(this, "could not resolve outgoing values selector in: " + this, exception);
        }
    }

    public EveryHandler getHandler(Scope outgoingScope) {
        if (this.isAssertion()) {
            return new EveryAssertionHandler(outgoingScope);
        }
        if (this.isAggregator()) {
            return new EveryAggregatorHandler(outgoingScope);
        }
        return new EveryBufferHandler(outgoingScope);
    }

    public class EveryAssertionHandler
    extends EveryHandler {
        public EveryAssertionHandler(Scope outgoingScope) {
            super(outgoingScope);
        }

        @Override
        public void start(FlowProcess flowProcess, TupleEntry groupEntry) {
            this.operationCall.setArguments(null);
            this.operationCall.setOutputCollector(null);
            this.operationCall.setGroup(groupEntry);
            Every.this.getGroupAssertion().start(flowProcess, this.operationCall);
        }

        @Override
        public void operate(FlowProcess flowProcess, TupleEntry groupEntry, TupleEntry inputEntry, TupleEntryIterator tupleEntryIterator) {
            TupleEntry arguments = this.outgoingScope.getArgumentsEntry(inputEntry);
            this.operationCall.setArguments(arguments);
            Every.this.getGroupAssertion().aggregate(flowProcess, this.operationCall);
        }

        @Override
        public void complete(FlowProcess flowProcess, TupleEntry groupEntry) {
            this.operationCall.setArguments(null);
            Every.this.getGroupAssertion().doAssert(flowProcess, this.operationCall);
            this.outputCollector.collect(groupEntry.getTuple());
        }
    }

    public class EveryBufferHandler
    extends EveryHandler {
        EveryTupleCollector tupleCollector;

        public EveryBufferHandler(final Scope outgoingScope) {
            super(outgoingScope);
            this.tupleCollector = new EveryTupleCollector(outgoingScope.getDeclaredFields()){

                @Override
                protected void collect(Tuple tuple) {
                    EveryBufferHandler.this.outputCollector.collect(Every.this.makeResult(outgoingScope.getOutGroupingSelector(), this.value, outgoingScope.getRemainderFields(), outgoingScope.getDeclaredEntry(), tuple));
                }
            };
        }

        public TupleEntry getLastValue() {
            return this.tupleCollector.value;
        }

        @Override
        public void start(FlowProcess flowProcess, TupleEntry groupEntry) {
        }

        @Override
        public void operate(FlowProcess flowProcess, TupleEntry groupEntry, TupleEntry inputEntry, final TupleEntryIterator tupleEntryIterator) {
            final TupleEntry tupleEntry = tupleEntryIterator.getTupleEntry();
            final Tuple valueNulledTuple = Tuples.setOnEmpty(tupleEntry, groupEntry);
            tupleEntry.setTuple(valueNulledTuple);
            this.tupleCollector.value = tupleEntry;
            this.operationCall.setOutputCollector(this.tupleCollector);
            this.operationCall.setGroup(groupEntry);
            this.operationCall.setArgumentsIterator(new Iterator<TupleEntry>(){

                @Override
                public boolean hasNext() {
                    boolean hasNext = tupleEntryIterator.hasNext();
                    if (!hasNext) {
                        tupleEntry.setTuple(valueNulledTuple);
                    }
                    return hasNext;
                }

                @Override
                public TupleEntry next() {
                    return EveryBufferHandler.this.outgoingScope.getArgumentsEntry(tupleEntryIterator.next());
                }

                @Override
                public void remove() {
                    tupleEntryIterator.remove();
                }
            });
            try {
                Every.this.getReducer().operate(flowProcess, this.operationCall);
            }
            catch (CascadingException exception) {
                throw exception;
            }
            catch (Throwable throwable) {
                throw new OperatorException(Every.this, "operator Every failed executing buffer: " + Every.this.operation, throwable);
            }
        }

        @Override
        public void complete(FlowProcess flowProcess, TupleEntry groupEntry) {
        }

        private abstract class EveryTupleCollector
        extends TupleEntryCollector {
            TupleEntry value;

            public EveryTupleCollector(Fields fields) {
                super(fields);
            }
        }
    }

    public class EveryAggregatorHandler
    extends EveryHandler {
        EveryTupleCollector tupleCollector;

        public EveryAggregatorHandler(final Scope outgoingScope) {
            super(outgoingScope);
            this.tupleCollector = new EveryTupleCollector(outgoingScope.getDeclaredFields()){

                @Override
                protected void collect(Tuple tuple) {
                    EveryAggregatorHandler.this.outputCollector.collect(Every.this.makeResult(outgoingScope.getOutGroupingSelector(), this.value, outgoingScope.getRemainderFields(), outgoingScope.getDeclaredEntry(), tuple));
                }
            };
        }

        @Override
        public void start(FlowProcess flowProcess, TupleEntry groupEntry) {
            this.operationCall.setArguments(null);
            this.operationCall.setOutputCollector(null);
            this.operationCall.setGroup(groupEntry);
            try {
                Every.this.getAggregator().start(flowProcess, this.operationCall);
            }
            catch (CascadingException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new OperatorException(Every.this, "operator Every failed starting aggregator", exception);
            }
        }

        @Override
        public void operate(FlowProcess flowProcess, TupleEntry groupEntry, TupleEntry inputEntry, TupleEntryIterator tupleEntryIterator) {
            try {
                TupleEntry arguments = this.outgoingScope.getArgumentsEntry(inputEntry);
                this.operationCall.setArguments(arguments);
                Every.this.getAggregator().aggregate(flowProcess, this.operationCall);
            }
            catch (CascadingException exception) {
                throw exception;
            }
            catch (Throwable throwable) {
                throw new OperatorException(Every.this, "operator Every failed executing aggregator: " + Every.this.operation, throwable);
            }
        }

        @Override
        public void complete(FlowProcess flowProcess, TupleEntry groupEntry) {
            this.tupleCollector.value = groupEntry;
            this.operationCall.setArguments(null);
            this.operationCall.setOutputCollector(this.tupleCollector);
            try {
                Every.this.getAggregator().complete(flowProcess, this.operationCall);
            }
            catch (CascadingException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new OperatorException(Every.this, "operator Every failed completing aggregator", exception);
            }
        }

        private abstract class EveryTupleCollector
        extends TupleEntryCollector {
            TupleEntry value;

            public EveryTupleCollector(Fields fields) {
                super(fields);
            }
        }
    }

    public abstract class EveryHandler {
        public final Scope outgoingScope;
        public FlowCollector outputCollector;
        ConcreteCall operationCall;

        public EveryHandler(Scope outgoingScope) {
            this.outgoingScope = outgoingScope;
            this.operationCall = new ConcreteCall(outgoingScope.getArguments());
        }

        public abstract void start(FlowProcess var1, TupleEntry var2);

        public abstract void operate(FlowProcess var1, TupleEntry var2, TupleEntry var3, TupleEntryIterator var4);

        public abstract void complete(FlowProcess var1, TupleEntry var2);

        public String toString() {
            return Every.this.toString();
        }

        public Every getEvery() {
            return Every.this;
        }

        public void prepare(FlowProcess flowProcess) {
            Every.this.getOperation().prepare(flowProcess, this.operationCall);
        }

        public void cleanup(FlowProcess flowProcess) {
            Every.this.getOperation().cleanup(flowProcess, this.operationCall);
        }
    }
}

