/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe;

import cascading.flow.FlowElement;
import cascading.flow.Scope;
import cascading.pipe.Group;
import cascading.pipe.Operator;
import cascading.pipe.SubAssembly;
import cascading.tuple.Fields;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Pipe
implements FlowElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    protected Pipe previous;
    private String trace = Util.captureDebugTrace(this.getClass());

    public static Pipe[] pipes(Pipe ... pipes) {
        return pipes;
    }

    public static String[] names(Pipe ... tails) {
        HashSet<String> names = new HashSet<String>();
        Pipe.collectNames(tails, names);
        return names.toArray(new String[names.size()]);
    }

    private static void collectNames(Pipe[] pipes, Set<String> names) {
        for (Pipe pipe : pipes) {
            if (pipe instanceof SubAssembly) {
                names.addAll(Arrays.asList(((SubAssembly)pipe).getTailNames()));
            } else {
                names.add(pipe.getName());
            }
            Pipe.collectNames(SubAssembly.unwind(pipe.getPrevious()), names);
        }
    }

    static Pipe[] resolvePreviousAll(Pipe ... pipes) {
        Pipe[] resolved = new Pipe[pipes.length];
        for (int i = 0; i < pipes.length; ++i) {
            resolved[i] = Pipe.resolvePrevious(pipes[i]);
        }
        return resolved;
    }

    static Pipe resolvePrevious(Pipe pipe) {
        if (pipe instanceof Group || pipe instanceof Operator) {
            return pipe;
        }
        Pipe[] pipes = pipe.getPrevious();
        if (pipes.length > 1) {
            throw new IllegalStateException("cannot resolve SubAssemblies with multiple tails at this time");
        }
        int i$ = 0;
        Pipe[] arr$ = pipes;
        int len$ = arr$.length;
        if (i$ < len$) {
            Pipe previous = arr$[i$];
            if (previous instanceof Group || previous instanceof Operator) {
                return previous;
            }
            return Pipe.resolvePrevious(previous);
        }
        return pipe;
    }

    protected Pipe() {
    }

    @ConstructorProperties(value={"previous"})
    protected Pipe(Pipe previous) {
        this.previous = previous;
        this.verifyPipe();
    }

    @ConstructorProperties(value={"name"})
    public Pipe(String name) {
        this.name = name;
    }

    @ConstructorProperties(value={"name", "previous"})
    public Pipe(String name, Pipe previous) {
        this.name = name;
        this.previous = previous;
        this.verifyPipe();
    }

    private void verifyPipe() {
        if (!(this.previous instanceof SubAssembly)) {
            return;
        }
        Object[] strings = ((SubAssembly)this.previous).getTailNames();
        if (strings.length != 1) {
            throw new IllegalArgumentException("pipe assembly must not return more than one tail pipe instance, found " + Util.join(strings, ", "));
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.previous != null) {
            return this.previous.getName();
        }
        return "ANONYMOUS";
    }

    public Pipe[] getPrevious() {
        if (this.previous == null) {
            return new Pipe[0];
        }
        return new Pipe[]{this.previous};
    }

    public Pipe[] getHeads() {
        Pipe[] pipes = this.getPrevious();
        if (pipes.length == 0) {
            return new Pipe[]{this};
        }
        if (pipes.length == 1) {
            return pipes[0].getHeads();
        }
        HashSet heads = new HashSet();
        for (Pipe pipe : pipes) {
            Collections.addAll(heads, pipe.getHeads());
        }
        return heads.toArray(new Pipe[heads.size()]);
    }

    @Override
    public Scope outgoingScopeFor(Set<Scope> incomingScopes) {
        return incomingScopes.iterator().next();
    }

    @Override
    public Fields resolveIncomingOperationFields(Scope incomingScope) {
        throw new IllegalStateException("resolveIncomingOperationFields should never be called");
    }

    @Override
    public Fields resolveFields(Scope scope) {
        throw new IllegalStateException("resolveFields should never be called");
    }

    public String getTrace() {
        return this.trace;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getName() + ")";
    }

    Scope getFirst(Set<Scope> incomingScopes) {
        return incomingScopes.iterator().next();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return 31 * this.getName().hashCode() + this.getClass().hashCode();
    }

    public String print(Scope scope) {
        StringBuffer buffer = new StringBuffer();
        this.printInternal(buffer, scope);
        return buffer.toString();
    }

    protected void printInternal(StringBuffer buffer, Scope scope) {
        buffer.append(this.getClass().getSimpleName()).append("('").append(this.getName()).append("')");
    }
}

