/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.cogroup;

import cascading.pipe.cogroup.CoGroupClosure;
import cascading.pipe.cogroup.GroupClosure;
import cascading.pipe.cogroup.InnerJoin;
import cascading.pipe.cogroup.Joiner;
import cascading.tuple.Tuple;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class OuterJoin
implements Joiner {
    @Override
    public Iterator<Tuple> getIterator(GroupClosure closure) {
        return new JoinIterator(closure);
    }

    @Override
    public int numJoins() {
        return -1;
    }

    protected static class JoinIterator
    extends InnerJoin.JoinIterator {
        List[] singletons;

        public JoinIterator(GroupClosure closure) {
            super(closure);
        }

        protected final CoGroupClosure getCoGroupClosure() {
            return (CoGroupClosure)this.closure;
        }

        @Override
        protected void init() {
            this.singletons = new List[this.closure.size()];
            for (int i = 0; i < this.singletons.length; ++i) {
                if (!this.isOuter(i)) continue;
                this.singletons[i] = Collections.singletonList(Tuple.size(this.closure.valueFields[i].size()));
            }
            super.init();
        }

        protected boolean isOuter(int i) {
            return this.getCoGroupClosure().isEmpty(i);
        }

        @Override
        protected Iterator getIterator(int i) {
            if (this.singletons[i] == null) {
                return super.getIterator(i);
            }
            return this.singletons[i].iterator();
        }
    }
}

