/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme;

import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.util.Util;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;

public abstract class Scheme
implements Serializable {
    Fields sinkFields = Fields.ALL;
    Fields sourceFields = Fields.UNKNOWN;
    int numSinkParts;
    private String trace = Util.captureDebugTrace(this.getClass());

    protected Scheme() {
    }

    protected Scheme(Fields sourceFields) {
        this.sourceFields = sourceFields;
    }

    protected Scheme(Fields sourceFields, int numSinkParts) {
        this.sourceFields = sourceFields;
        this.numSinkParts = numSinkParts;
    }

    protected Scheme(Fields sourceFields, Fields sinkFields) {
        this.sourceFields = sourceFields;
        this.sinkFields = sinkFields;
    }

    protected Scheme(Fields sourceFields, Fields sinkFields, int numSinkParts) {
        this.sinkFields = sinkFields;
        this.sourceFields = sourceFields;
        this.numSinkParts = numSinkParts;
    }

    public Fields getSinkFields() {
        return this.sinkFields;
    }

    public void setSinkFields(Fields sinkFields) {
        this.sinkFields = sinkFields;
    }

    public Fields getSourceFields() {
        return this.sourceFields;
    }

    public void setSourceFields(Fields sourceFields) {
        this.sourceFields = sourceFields;
    }

    public int getNumSinkParts() {
        return this.numSinkParts;
    }

    public void setNumSinkParts(int numSinkParts) {
        this.numSinkParts = numSinkParts;
    }

    public String getTrace() {
        return this.trace;
    }

    public boolean isWriteDirect() {
        return false;
    }

    public boolean isSymetrical() {
        return this.getSinkFields().equals(this.getSourceFields());
    }

    public abstract void sourceInit(Tap var1, JobConf var2) throws IOException;

    public abstract void sinkInit(Tap var1, JobConf var2) throws IOException;

    public abstract Tuple source(Object var1, Object var2);

    public abstract void sink(TupleEntry var1, OutputCollector var2) throws IOException;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Scheme scheme = (Scheme)object;
        if (this.numSinkParts != scheme.numSinkParts) {
            return false;
        }
        if (this.sinkFields != null ? !this.sinkFields.equals(scheme.sinkFields) : scheme.sinkFields != null) {
            return false;
        }
        return !(this.sourceFields != null ? !this.sourceFields.equals(scheme.sourceFields) : scheme.sourceFields != null);
    }

    public String toString() {
        if (this.getSinkFields().equals(this.getSourceFields())) {
            return this.getClass().getSimpleName() + "[" + this.getSourceFields().print() + "]";
        }
        return this.getClass().getSimpleName() + "[" + this.getSourceFields().print() + "->" + this.getSinkFields().print() + "]";
    }

    public int hashCode() {
        int result = this.sinkFields != null ? this.sinkFields.hashCode() : 0;
        result = 31 * result + (this.sourceFields != null ? this.sourceFields.hashCode() : 0);
        result = 31 * result + this.numSinkParts;
        return result;
    }
}

