/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.tap.Tap;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;

public class Hadoop18TapUtil {
    private static final Logger LOG = Logger.getLogger(Hadoop18TapUtil.class);
    private static final String TEMPORARY_PATH = "_temporary";
    private static Map<String, AtomicInteger> pathCounts = new HashMap<String, AtomicInteger>();

    public static void setupJob(JobConf conf) throws IOException {
        Path outputPath = FileOutputFormat.getOutputPath((JobConf)conf);
        if (outputPath == null) {
            return;
        }
        if (Hadoop18TapUtil.getFSSafe(conf, outputPath) == null) {
            return;
        }
        if (conf.get("mapred.task.id") == null) {
            String mapper = conf.getBoolean("mapred.task.is.map", true) ? "m" : "r";
            conf.set("mapred.task.id", String.format("attempt_%012d_0000_%s_000000_0", (int)Math.rint(System.currentTimeMillis()), mapper));
        }
        Hadoop18TapUtil.makeTempPath(conf);
        if (Hadoop18TapUtil.writeDirectlyToWorkingPath(conf, outputPath)) {
            LOG.info((Object)("writing directly to output path: " + outputPath));
            Hadoop18TapUtil.setWorkOutputPath(conf, outputPath);
            return;
        }
        Path taskOutputPath = Hadoop18TapUtil.getTaskOutputPath(conf);
        Hadoop18TapUtil.setWorkOutputPath(conf, taskOutputPath);
    }

    static synchronized void setupTask(JobConf conf) throws IOException {
        String workpath = conf.get("mapred.work.output.dir");
        if (workpath == null) {
            return;
        }
        FileSystem fs = Hadoop18TapUtil.getFSSafe(conf, new Path(workpath));
        if (fs == null) {
            return;
        }
        String taskId = conf.get("mapred.task.id");
        LOG.info((Object)("setting up task: '" + taskId + "' - " + workpath));
        AtomicInteger integer = pathCounts.get(workpath);
        if (integer == null) {
            integer = new AtomicInteger();
            pathCounts.put(workpath, integer);
        }
        integer.incrementAndGet();
    }

    public static boolean needsTaskCommit(JobConf conf) throws IOException {
        String workpath = conf.get("mapred.work.output.dir");
        if (workpath == null) {
            return false;
        }
        Path taskOutputPath = new Path(workpath);
        if (taskOutputPath != null) {
            FileSystem fs = Hadoop18TapUtil.getFSSafe(conf, taskOutputPath);
            if (fs == null) {
                return false;
            }
            if (fs.exists(taskOutputPath)) {
                return true;
            }
        }
        return false;
    }

    public static void commitTask(JobConf conf) throws IOException {
        Path taskOutputPath = new Path(conf.get("mapred.work.output.dir"));
        FileSystem fs = Hadoop18TapUtil.getFSSafe(conf, taskOutputPath);
        if (fs == null) {
            return;
        }
        AtomicInteger integer = pathCounts.get(taskOutputPath.toString());
        if (integer.decrementAndGet() != 0) {
            return;
        }
        String taskId = conf.get("mapred.task.id");
        LOG.info((Object)("committing task: '" + taskId + "' - " + taskOutputPath));
        if (taskOutputPath != null) {
            if (Hadoop18TapUtil.writeDirectlyToWorkingPath(conf, taskOutputPath)) {
                return;
            }
            if (fs.exists(taskOutputPath)) {
                Path jobOutputPath = taskOutputPath.getParent().getParent();
                Hadoop18TapUtil.moveTaskOutputs(conf, fs, jobOutputPath, taskOutputPath);
                if (!fs.delete(taskOutputPath, true)) {
                    LOG.info((Object)("failed to delete the temporary output directory of task: '" + taskId + "' - " + taskOutputPath));
                }
                LOG.info((Object)("saved output of task '" + taskId + "' to " + jobOutputPath));
            }
        }
    }

    public static void cleanupTap(JobConf conf, Tap tap) throws IOException {
        Hadoop18TapUtil.cleanTempPath(conf, tap.getPath());
    }

    static void cleanupJob(JobConf conf) throws IOException {
        if (Hadoop18TapUtil.isInflow(conf)) {
            return;
        }
        Path outputPath = FileOutputFormat.getOutputPath((JobConf)conf);
        Hadoop18TapUtil.cleanTempPath(conf, outputPath);
    }

    private static synchronized void cleanTempPath(JobConf conf, Path outputPath) throws IOException {
        if (outputPath != null) {
            FileSystem fileSys = Hadoop18TapUtil.getFSSafe(conf, outputPath);
            if (fileSys == null) {
                return;
            }
            if (!fileSys.exists(outputPath)) {
                return;
            }
            Path tmpDir = new Path(outputPath, TEMPORARY_PATH);
            LOG.info((Object)("deleting temp path " + tmpDir));
            if (fileSys.exists(tmpDir)) {
                fileSys.delete(tmpDir, true);
            }
        }
    }

    private static FileSystem getFSSafe(JobConf conf, Path tmpDir) {
        try {
            return tmpDir.getFileSystem((Configuration)conf);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static boolean isInflow(JobConf conf) {
        return conf.get("cascading.flow.step") != null;
    }

    private static Path getTaskOutputPath(JobConf conf) {
        String taskId = conf.get("mapred.task.id");
        Path p = new Path(FileOutputFormat.getOutputPath((JobConf)conf), "_temporary/_" + taskId);
        try {
            FileSystem fs = p.getFileSystem((Configuration)conf);
            return p.makeQualified(fs);
        }
        catch (IOException ie) {
            return p;
        }
    }

    static void setWorkOutputPath(JobConf conf, Path outputDir) {
        outputDir = new Path(conf.getWorkingDirectory(), outputDir);
        conf.set("mapred.work.output.dir", outputDir.toString());
    }

    public static void makeTempPath(JobConf conf) throws IOException {
        Path tmpDir;
        FileSystem fileSys;
        Path outputPath = FileOutputFormat.getOutputPath((JobConf)conf);
        if (outputPath != null && !(fileSys = (tmpDir = new Path(outputPath, TEMPORARY_PATH)).getFileSystem((Configuration)conf)).exists(tmpDir) && !fileSys.mkdirs(tmpDir)) {
            LOG.error((Object)("mkdirs failed to create " + tmpDir.toString()));
        }
    }

    private static void moveTaskOutputs(JobConf conf, FileSystem fs, Path jobOutputDir, Path taskOutput) throws IOException {
        String taskId = conf.get("mapred.task.id");
        if (fs.isFile(taskOutput)) {
            Path finalOutputPath = Hadoop18TapUtil.getFinalPath(jobOutputDir, taskOutput, Hadoop18TapUtil.getTaskOutputPath(conf));
            if (!fs.rename(taskOutput, finalOutputPath)) {
                if (!fs.delete(finalOutputPath, true)) {
                    throw new IOException("Failed to delete earlier output of task: " + taskId);
                }
                if (!fs.rename(taskOutput, finalOutputPath)) {
                    throw new IOException("Failed to save output of task: " + taskId);
                }
            }
            LOG.debug((Object)("Moved " + taskOutput + " to " + finalOutputPath));
        } else if (fs.getFileStatus(taskOutput).isDir()) {
            FileStatus[] paths = fs.listStatus(taskOutput);
            Path finalOutputPath = Hadoop18TapUtil.getFinalPath(jobOutputDir, taskOutput, Hadoop18TapUtil.getTaskOutputPath(conf));
            fs.mkdirs(finalOutputPath);
            if (paths != null) {
                for (FileStatus path : paths) {
                    Hadoop18TapUtil.moveTaskOutputs(conf, fs, jobOutputDir, path.getPath());
                }
            }
        }
    }

    private static Path getFinalPath(Path jobOutputDir, Path taskOutput, Path taskOutputPath) throws IOException {
        URI relativePath;
        URI taskOutputUri = taskOutput.toUri();
        if (taskOutputUri == (relativePath = taskOutputPath.toUri().relativize(taskOutputUri))) {
            throw new IOException("Can not get the relative path: base = " + taskOutputPath + " child = " + taskOutput);
        }
        if (relativePath.getPath().length() > 0) {
            return new Path(jobOutputDir, relativePath.getPath());
        }
        return jobOutputDir;
    }

    private static boolean writeDirectlyToWorkingPath(JobConf conf, Path path) {
        FileSystem fs = Hadoop18TapUtil.getFSSafe(conf, path);
        if (fs == null) {
            return false;
        }
        return conf.getBoolean("mapred.output.direct." + fs.getClass().getSimpleName(), false);
    }
}

