/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.flow.FlowProcess;
import cascading.tuple.Fields;
import cascading.tuple.IndexTuple;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleException;
import cascading.tuple.TupleInputStream;
import cascading.tuple.TupleOutputStream;
import cascading.tuple.hadoop.TupleSerialization;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;

public class SpillableTupleList
implements Iterable<Tuple> {
    private static final Logger LOG = Logger.getLogger(SpillableTupleList.class);
    private long threshold = 10000L;
    private CompressionCodec codec = null;
    private FlowProcess flowProcess;
    private List<File> files = new LinkedList<File>();
    private List<Tuple> current = new LinkedList<Tuple>();
    private Iterator<Tuple> overrideIterator;
    private long size = 0L;
    private Fields fields;
    private TupleSerialization tupleSerialization;

    public SpillableTupleList() {
    }

    public SpillableTupleList(long threshold) {
        this.threshold = threshold;
    }

    public SpillableTupleList(long threshold, JobConf conf, CompressionCodec codec) {
        this(threshold, conf, codec, null);
    }

    public SpillableTupleList(long threshold, JobConf conf, CompressionCodec codec, FlowProcess flowProcess) {
        this.threshold = threshold;
        this.codec = codec;
        this.flowProcess = flowProcess;
        if (conf != null) {
            this.tupleSerialization = new TupleSerialization((Configuration)conf);
        }
    }

    public boolean add(Tuple tuple) {
        this.current.add(tuple);
        ++this.size;
        return this.doSpill();
    }

    public boolean add(TupleEntry tupleEntry) {
        if (this.fields == null) {
            this.fields = tupleEntry.fields;
        } else if (!this.fields.equals(tupleEntry.fields)) {
            throw new IllegalArgumentException("all entries must have same fields, have: " + this.fields.print() + " got: " + tupleEntry.fields.print());
        }
        return this.add(tupleEntry.getTuple());
    }

    public long size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.overrideIterator == null && this.files.isEmpty() && this.current.size() == 0;
    }

    public int getNumFiles() {
        return this.files.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doSpill() {
        if ((long)this.current.size() != this.threshold) {
            return false;
        }
        LOG.info((Object)("spilling tuple list to file number " + (this.getNumFiles() + 1)));
        if (this.flowProcess != null) {
            this.flowProcess.increment(Spill.Num_Spills_Written, 1);
        }
        File file = this.createTempFile();
        TupleOutputStream dataOutputStream = this.createTupleOutputStream(file);
        try {
            this.writeList(dataOutputStream, this.current);
        }
        finally {
            this.flushSilent(dataOutputStream);
            this.closeSilent(dataOutputStream);
        }
        this.files.add(file);
        this.current.clear();
        return true;
    }

    private void flushSilent(Flushable flushable) {
        try {
            flushable.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeSilent(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeList(TupleOutputStream dataOutputStream, List<Tuple> list) {
        try {
            dataOutputStream.writeLong(list.size());
            for (Tuple tuple : list) {
                dataOutputStream.writeTuple(tuple);
            }
        }
        catch (IOException exception) {
            throw new TupleException("unable to write to file output stream", exception);
        }
    }

    private TupleOutputStream createTupleOutputStream(File file) {
        try {
            FileOutputStream outputStream = this.codec == null ? new FileOutputStream(file) : this.codec.createOutputStream((OutputStream)new FileOutputStream(file));
            if (this.tupleSerialization == null) {
                return new TupleOutputStream(outputStream);
            }
            return new TupleOutputStream(outputStream, this.tupleSerialization.getElementWriter());
        }
        catch (IOException exception) {
            throw new TupleException("unable to create temporary file input stream", exception);
        }
    }

    private List<Tuple> readList(TupleInputStream tupleInputStream) {
        try {
            long size = tupleInputStream.readLong();
            LinkedList<Tuple> list = new LinkedList<Tuple>();
            int i = 0;
            while ((long)i < size) {
                list.add(tupleInputStream.readTuple());
                ++i;
            }
            return list;
        }
        catch (IOException exception) {
            throw new TupleException("unable to read from file output stream", exception);
        }
    }

    private TupleInputStream createTupleInputStream(File file) {
        try {
            FileInputStream inputStream = this.codec == null ? new FileInputStream(file) : this.codec.createInputStream((InputStream)new FileInputStream(file));
            if (this.tupleSerialization == null) {
                return new TupleInputStream((InputStream)inputStream, false);
            }
            return new TupleInputStream((InputStream)inputStream, this.tupleSerialization.getElementReader(false));
        }
        catch (IOException exception) {
            throw new TupleException("unable to create temporary file output stream", exception);
        }
    }

    private File createTempFile() {
        try {
            File file = File.createTempFile("cascading-spillover", null);
            file.deleteOnExit();
            return file;
        }
        catch (IOException exception) {
            throw new TupleException("unable to create temporary file", exception);
        }
    }

    public void clear() {
        this.overrideIterator = null;
        this.files.clear();
        this.current.clear();
        this.size = 0L;
    }

    public void setIterator(final IndexTuple current, final Iterator values) {
        this.overrideIterator = new Iterator<Tuple>(){
            IndexTuple value;
            {
                this.value = current;
            }

            @Override
            public boolean hasNext() {
                return this.value != null;
            }

            @Override
            public Tuple next() {
                Tuple result = this.value.getTuple();
                this.value = values.hasNext() ? (IndexTuple)values.next() : null;
                return result;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Iterator<Tuple> iterator() {
        if (this.overrideIterator != null) {
            return this.overrideIterator;
        }
        if (this.files.isEmpty()) {
            return this.current.iterator();
        }
        return new SpilledListIterator();
    }

    public Iterator<TupleEntry> entryIterator() {
        return new TupleEntryIterator(this.fields, this.iterator());
    }

    private class SpilledListIterator
    implements Iterator<Tuple> {
        int fileIndex = 0;
        List<Tuple> currentList;
        private Iterator<Tuple> iterator;

        private SpilledListIterator() {
            this.getNextList();
        }

        private void getNextList() {
            this.currentList = this.fileIndex < SpillableTupleList.this.files.size() ? this.getListFor((File)SpillableTupleList.this.files.get(this.fileIndex++)) : SpillableTupleList.this.current;
            this.iterator = this.currentList.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Tuple> getListFor(File file) {
            if (SpillableTupleList.this.flowProcess != null) {
                SpillableTupleList.this.flowProcess.increment(Spill.Num_Spills_Read, 1);
            }
            TupleInputStream dataInputStream = SpillableTupleList.this.createTupleInputStream(file);
            try {
                List list = SpillableTupleList.this.readList(dataInputStream);
                return list;
            }
            finally {
                SpillableTupleList.this.closeSilent(dataInputStream);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.currentList == SpillableTupleList.this.current) {
                return this.iterator.hasNext();
            }
            if (this.iterator.hasNext()) {
                return true;
            }
            this.getNextList();
            return this.hasNext();
        }

        @Override
        public Tuple next() {
            if (this.currentList == SpillableTupleList.this.current || this.iterator.hasNext()) {
                return this.iterator.next();
            }
            this.getNextList();
            return this.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }
    }

    static enum Spill {
        Num_Spills_Written,
        Num_Spills_Read;

    }
}

