/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleException;

public abstract class TupleEntryCollector {
    protected Fields declared;

    protected TupleEntryCollector() {
    }

    public TupleEntryCollector(Fields declared) {
        if (declared == null) {
            throw new IllegalArgumentException("declared fields must not be null");
        }
        this.declared = declared;
    }

    public void add(TupleEntry entry) {
        this.add(entry.getTuple());
    }

    public void add(Tuple tuple) {
        if (tuple == null || tuple.isEmpty()) {
            return;
        }
        if (this.declared != null && !this.declared.isUnknown() && this.declared.size() != tuple.size()) {
            throw new TupleException("operation added the wrong number of fields, expected: " + this.declared.print() + ", got result size: " + tuple.size());
        }
        this.collect(tuple);
    }

    protected abstract void collect(Tuple var1);

    public void close() {
    }
}

