/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.tuple.TupleOutputStream;
import cascading.tuple.hadoop.TupleSerialization;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.log4j.Logger;

public class SerializationElementWriter
implements TupleOutputStream.ElementWriter {
    private static final Logger LOG = Logger.getLogger(SerializationElementWriter.class);
    private final TupleSerialization tupleSerialization;
    Map<Class, Serializer> serializers = new HashMap<Class, Serializer>();

    public SerializationElementWriter(TupleSerialization tupleSerialization) {
        this.tupleSerialization = tupleSerialization;
        tupleSerialization.initTokenMaps();
    }

    @Override
    public void write(DataOutputStream outputStream, Object object) throws IOException {
        Class<?> type = object.getClass();
        String className = type.getName();
        Integer token = this.tupleSerialization.getTokenFor(className);
        if (token == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("no serialization token found for classname: " + className));
            }
            WritableUtils.writeVInt((DataOutput)outputStream, (int)32);
            WritableUtils.writeString((DataOutput)outputStream, (String)className);
        } else {
            WritableUtils.writeVInt((DataOutput)outputStream, (int)token);
        }
        Serializer serializer = this.serializers.get(type);
        if (serializer == null) {
            serializer = this.tupleSerialization.getNewSerializer(type);
            serializer.open((OutputStream)outputStream);
            this.serializers.put(type, serializer);
        }
        try {
            serializer.serialize(object);
        }
        catch (IOException exception) {
            LOG.error((Object)("failed serializing token: " + token + " with classname: " + className), (Throwable)exception);
            throw exception;
        }
    }

    @Override
    public void close() {
        if (this.serializers.size() == 0) {
            return;
        }
        ArrayList<Serializer> clone = new ArrayList<Serializer>(this.serializers.values());
        this.serializers.clear();
        for (Serializer serializer : clone) {
            try {
                serializer.close();
            }
            catch (IOException exception) {}
        }
    }
}

