/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.CascadingException;
import cascading.tuple.TuplePair;
import cascading.tuple.hadoop.DeserializerComparator;
import cascading.tuple.hadoop.TupleComparator;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.util.Util;
import java.io.IOException;
import java.util.Comparator;
import org.apache.hadoop.conf.Configuration;

public class TuplePairComparator
extends DeserializerComparator<TuplePair> {
    private Comparator comparator = new Comparator<TuplePair>(){

        @Override
        public int compare(TuplePair lhs, TuplePair rhs) {
            return lhs.compareTo(rhs);
        }
    };

    @Override
    public void setConf(Configuration conf) {
        Object groupComparator;
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        String group = conf.get("cascading.group.comparator");
        String sort = conf.get("cascading.sort.comparator");
        if (sort == null && group == null) {
            return;
        }
        Object sortComparator = groupComparator = new TupleComparator();
        try {
            if (group != null) {
                groupComparator = (Comparator)Util.deserializeBase64(group);
            }
        }
        catch (IOException exception) {
            throw new CascadingException("unable to deserialize grouping comparator");
        }
        try {
            if (sort != null) {
                sortComparator = (Comparator)Util.deserializeBase64(sort);
            }
        }
        catch (IOException exception) {
            throw new CascadingException("unable to deserialize sorting comparator");
        }
        Object finalGroupComparator = groupComparator;
        Object finalSortComparator = sortComparator;
        this.comparator = new Comparator<TuplePair>((Comparator)finalGroupComparator, (Comparator)finalSortComparator){
            final /* synthetic */ Comparator val$finalGroupComparator;
            final /* synthetic */ Comparator val$finalSortComparator;
            {
                this.val$finalGroupComparator = comparator;
                this.val$finalSortComparator = comparator2;
            }

            @Override
            public int compare(TuplePair lhs, TuplePair rhs) {
                int c = this.val$finalGroupComparator.compare(lhs.getLhs(), rhs.getLhs());
                if (c != 0) {
                    return c;
                }
                return this.val$finalSortComparator.compare(lhs.getRhs(), rhs.getRhs());
            }
        };
    }

    @Override
    void setDeserializer(TupleSerialization tupleSerialization) throws IOException {
        this.setDeserializer(tupleSerialization.getTuplePairDeserializer());
    }

    public int compare(TuplePair lhs, TuplePair rhs) {
        return this.comparator.compare(lhs, rhs);
    }
}

