/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.CascadingException;
import cascading.tuple.IndexTuple;
import cascading.tuple.Tuple;
import cascading.tuple.TupleException;
import cascading.tuple.TuplePair;
import cascading.tuple.hadoop.IndexTupleDeserializer;
import cascading.tuple.hadoop.IndexTupleSerializer;
import cascading.tuple.hadoop.SerializationElementReader;
import cascading.tuple.hadoop.SerializationElementWriter;
import cascading.tuple.hadoop.SerializationToken;
import cascading.tuple.hadoop.TupleDeserializer;
import cascading.tuple.hadoop.TuplePairDeserializer;
import cascading.tuple.hadoop.TuplePairSerializer;
import cascading.tuple.hadoop.TupleSerializer;
import cascading.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;

@SerializationToken(tokens={127}, classNames={"org.apache.hadoop.io.BytesWritable"})
public class TupleSerialization
extends Configured
implements Serialization {
    private static final Logger LOG = Logger.getLogger(TupleSerialization.class);
    private Map<String, Class> classCache = new HashMap<String, Class>();
    private SerializationFactory serializationFactory;
    private HashMap<Integer, String> tokenClassesMap;
    private HashMap<String, Integer> classesTokensMap;
    private long tokensSize = 0L;

    public static void addSerializationToken(Map<Object, Object> properties, int token, String className) {
        String tokens = TupleSerialization.getSerializationTokens(properties);
        properties.put("cascading.serialization.tokens", Util.join(",", Util.removeNulls(tokens, token + "=" + className)));
    }

    public static String getSerializationTokens(Map<Object, Object> properties) {
        return (String)properties.get("cascading.serialization.tokens");
    }

    static String getSerializationTokens(JobConf jobConf) {
        return jobConf.get("cascading.serialization.tokens");
    }

    public static void addSerialization(Map<Object, Object> properties, String className) {
        String serializations = (String)properties.get("io.serializations");
        properties.put("io.serializations", Util.join(",", Util.removeNulls(serializations, className)));
    }

    public static void setSerializations(JobConf jobConf) {
        String serializations = TupleSerialization.getSerializations(jobConf);
        if (serializations.contains(TupleSerialization.class.getName())) {
            return;
        }
        jobConf.set("io.serializations", Util.join(",", Util.removeNulls(serializations, TupleSerialization.class.getName())));
    }

    static String getSerializations(JobConf jobConf) {
        return jobConf.get("io.serializations", "");
    }

    public TupleSerialization() {
    }

    public TupleSerialization(Configuration conf) {
        super(conf);
    }

    public Configuration getConf() {
        if (super.getConf() == null) {
            this.setConf((Configuration)new JobConf());
        }
        return super.getConf();
    }

    SerializationFactory getSerializationFactory() {
        if (this.serializationFactory == null) {
            this.serializationFactory = new SerializationFactory(this.getConf());
        }
        return this.serializationFactory;
    }

    void initTokenMaps() {
        String[] serializations;
        String serializationsString;
        if (this.tokenClassesMap != null) {
            return;
        }
        this.tokenClassesMap = new HashMap();
        this.classesTokensMap = new HashMap();
        String tokenProperty = TupleSerialization.getSerializationTokens((JobConf)this.getConf());
        if (tokenProperty != null) {
            tokenProperty = tokenProperty.replaceAll("\\s", "");
            for (String pair : tokenProperty.split(",")) {
                String[] elements = pair.split("=");
                this.addToken(null, Integer.parseInt(elements[0]), elements[1]);
            }
        }
        if ((serializationsString = TupleSerialization.getSerializations((JobConf)this.getConf())) == null) {
            return;
        }
        for (String serializationName : serializations = serializationsString.split(",")) {
            try {
                Class type = this.getConf().getClassByName(serializationName);
                SerializationToken tokenAnnotation = type.getAnnotation(SerializationToken.class);
                if (tokenAnnotation == null) continue;
                if (tokenAnnotation.tokens().length != tokenAnnotation.classNames().length) {
                    throw new CascadingException("serialization annotation tokens and classNames must be the same length");
                }
                int[] tokens = tokenAnnotation.tokens();
                for (int i = 0; i < tokens.length; ++i) {
                    this.addToken(type, tokens[i], tokenAnnotation.classNames()[i]);
                }
            }
            catch (ClassNotFoundException exception) {
                LOG.warn((Object)("unable to load serialization class: " + serializationName), (Throwable)exception);
            }
        }
        this.tokensSize = this.tokenClassesMap.size();
    }

    private void addToken(Class type, int token, String className) {
        if (type != null && !type.getName().startsWith("cascading.") && token < 128) {
            throw new CascadingException("serialization annotation tokens may not be less than 128, was: " + token);
        }
        if (this.tokenClassesMap.containsKey(token)) {
            if (type == null) {
                throw new IllegalStateException("duplicate serialization token: " + token + " for class: " + className + " found in properties");
            }
            throw new IllegalStateException("duplicate serialization token: " + token + " for class: " + className + " on serialization: " + type.getName());
        }
        if (this.classesTokensMap.containsKey(className)) {
            if (type == null) {
                throw new IllegalStateException("duplicate serialization classname: " + className + " for token: " + token + " found in properties ");
            }
            throw new IllegalStateException("duplicate serialization classname: " + className + " for token: " + token + " on serialization: " + type.getName());
        }
        this.tokenClassesMap.put(token, className);
        this.classesTokensMap.put(className, token);
    }

    final String getClassNameFor(int token) {
        if (this.tokensSize == 0L) {
            return null;
        }
        return this.tokenClassesMap.get(token);
    }

    final Integer getTokenFor(String className) {
        if (this.tokensSize == 0L) {
            return null;
        }
        return this.classesTokensMap.get(className);
    }

    Serializer getNewSerializer(Class type) {
        try {
            return this.getSerializationFactory().getSerializer(type);
        }
        catch (NullPointerException exception) {
            throw new CascadingException("unable to load serializer for: " + type.getName() + " from: " + this.getSerializationFactory().getClass().getName());
        }
    }

    Deserializer getNewDeserializer(String className) {
        try {
            return this.getSerializationFactory().getDeserializer(this.getClass(className));
        }
        catch (NullPointerException exception) {
            throw new CascadingException("unable to load deserializer for: " + className + " from: " + this.getSerializationFactory().getClass().getName());
        }
    }

    TuplePairDeserializer getTuplePairDeserializer() {
        return new TuplePairDeserializer(this.getElementReader(true));
    }

    public SerializationElementReader getElementReader(boolean reuseInstances) {
        return new SerializationElementReader(this);
    }

    TupleDeserializer getTupleDeserializer() {
        return new TupleDeserializer(this.getElementReader(true));
    }

    private TuplePairSerializer getTuplePairSerializer() {
        return new TuplePairSerializer(this.getElementWriter());
    }

    IndexTupleDeserializer getIndexTupleDeserializer() {
        return new IndexTupleDeserializer(this.getElementReader(false));
    }

    public SerializationElementWriter getElementWriter() {
        return new SerializationElementWriter(this);
    }

    private TupleSerializer getTupleSerializer() {
        return new TupleSerializer(this.getElementWriter());
    }

    private IndexTupleSerializer getIndexTupleSerializer() {
        return new IndexTupleSerializer(this.getElementWriter());
    }

    public boolean accept(Class c) {
        return Tuple.class == c || TuplePair.class == c || IndexTuple.class == c;
    }

    public Deserializer getDeserializer(Class c) {
        if (c == Tuple.class) {
            return this.getTupleDeserializer();
        }
        if (c == TuplePair.class) {
            return this.getTuplePairDeserializer();
        }
        if (c == IndexTuple.class) {
            return this.getIndexTupleDeserializer();
        }
        throw new IllegalArgumentException("unknown class, cannot deserialize: " + c.getName());
    }

    public Serializer getSerializer(Class c) {
        if (c == Tuple.class) {
            return this.getTupleSerializer();
        }
        if (c == TuplePair.class) {
            return this.getTuplePairSerializer();
        }
        if (c == IndexTuple.class) {
            return this.getIndexTupleSerializer();
        }
        throw new IllegalArgumentException("unknown class, cannot serialize: " + c.getName());
    }

    private Class getClass(String className) {
        Class<?> type = this.classCache.get(className);
        if (type != null) {
            return type;
        }
        try {
            type = className.charAt(0) == '[' ? Class.forName(className, true, Thread.currentThread().getContextClassLoader()) : Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException exception) {
            throw new TupleException("unable to load class named: " + className, exception);
        }
        this.classCache.put(className, type);
        return type;
    }
}

