(ns leiningen.new.cascalog-avro
  (:use [leiningen.new.templates :only [renderer name-to-path ->files]])
  (:require [clojure.java.io :as io]
            [clojure.string :as string]))

(def render (renderer "cascalog-avro"))

(defn binary-renderer [name]
  (fn [file]
    (io/input-stream (io/resource(string/join "/" ["leiningen" "new" "cascalog_avro" file])))))
(def binary-render (binary-renderer "cascalog-avro"))

(defn cascalog-avro
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (->files data
             ["src/{{sanitized}}/core.clj" (render "core.clj" data)]
             ["test/{{sanitized}}/core_test.clj" (render "core_test.clj" data)]
             ["resources/local/input.tsv" (render "input.tsv" data)]
             ["resources/local/input.avro" (binary-render "input.avro")]
             ["resources/local/input.avsc" (render "input.avsc")]
             ["project.clj" (render "project.clj" data)]
             ["README.md" (render "README.md" data)])))

