/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import net.i2p.I2PAppContext;
import net.i2p.client.HandlerImpl;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionImpl;
import net.i2p.data.i2cp.DisconnectMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.util.I2PAppThread;

class DisconnectMessageHandler
extends HandlerImpl {
    public DisconnectMessageHandler(I2PAppContext context) {
        super(context, 30);
    }

    @Override
    public void handleMessage(I2CPMessage message, I2PSessionImpl session) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle message " + message);
        }
        String reason = ((DisconnectMessage)message).getReason();
        session.propogateError(reason, new I2PSessionException("Disconnect Message received"));
        session.destroySession(false);
        if (reason.contains("restart")) {
            I2PAppThread t = new I2PAppThread(new Reconnector(session), "Reconnect " + session, true);
            t.start();
        }
    }

    private static class Reconnector
    implements Runnable {
        private final I2PSessionImpl _session;

        public Reconnector(I2PSessionImpl session) {
            this._session = session;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._session.reconnect();
        }
    }
}

