/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.Serializable;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;

public class ByteArray
implements Serializable,
Comparable {
    private byte[] _data;
    private int _valid;
    private int _offset;

    public ByteArray() {
    }

    public ByteArray(byte[] data) {
        this._data = data;
        this._valid = data != null ? data.length : 0;
    }

    public ByteArray(byte[] data, int offset, int length) {
        this._data = data;
        this._offset = offset;
        this._valid = length;
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        this._data = data;
    }

    public int getValid() {
        return this._valid;
    }

    public void setValid(int valid) {
        this._valid = valid;
    }

    public int getOffset() {
        return this._offset;
    }

    public void setOffset(int offset) {
        this._offset = offset;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ByteArray) {
            ByteArray ba = (ByteArray)o;
            return ByteArray.compare(this.getData(), this._offset, this._valid, ba.getData(), ba.getOffset(), ba.getValid());
        }
        try {
            byte[] val = (byte[])o;
            return ByteArray.compare(this.getData(), this._offset, this._valid, val, 0, val.length);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static final boolean compare(byte[] lhs, int loff, int llen, byte[] rhs, int roff, int rlen) {
        return llen == rlen && DataHelper.eq(lhs, loff, rhs, roff, llen);
    }

    public final int compareTo(Object obj) {
        if (obj.getClass() != this.getClass()) {
            throw new ClassCastException("invalid object: " + obj);
        }
        return DataHelper.compareTo(this._data, ((ByteArray)obj).getData());
    }

    public final int hashCode() {
        return DataHelper.hashCode(this.getData());
    }

    public String toString() {
        return super.toString() + "/" + DataHelper.toString(this.getData(), 32) + "." + this._valid;
    }

    public final String toBase64() {
        return Base64.encode(this._data, this._offset, this._valid);
    }
}

