/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionImpl;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.internal.PoisonI2CPMessage;
import net.i2p.util.I2PAppThread;

class ClientWriterRunner
implements Runnable {
    private final OutputStream _out;
    private final I2PSessionImpl _session;
    private final BlockingQueue<I2CPMessage> _messagesToWrite;
    private static final AtomicLong __Id = new AtomicLong();
    private static final int MAX_QUEUE_SIZE = 32;
    private static final long MAX_SEND_WAIT = 10000L;

    public ClientWriterRunner(OutputStream out, I2PSessionImpl session) {
        this._out = new BufferedOutputStream(out);
        this._session = session;
        this._messagesToWrite = new LinkedBlockingQueue<I2CPMessage>(32);
    }

    public void startWriting() {
        I2PAppThread t = new I2PAppThread(this, "I2CP Client Writer " + __Id.incrementAndGet(), true);
        t.start();
    }

    public void addMessage(I2CPMessage msg) throws I2PSessionException {
        try {
            if (!this._messagesToWrite.offer(msg, 10000L, TimeUnit.MILLISECONDS)) {
                throw new I2PSessionException("Timed out waiting while write queue was full");
            }
        }
        catch (InterruptedException ie) {
            throw new I2PSessionException("Interrupted while write queue was full", ie);
        }
    }

    public void stopWriting() {
        this._messagesToWrite.clear();
        try {
            this._messagesToWrite.put(new PoisonI2CPMessage());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this._session.isClosed()) {
            I2CPMessage msg;
            try {
                msg = this._messagesToWrite.take();
            }
            catch (InterruptedException ie) {
                continue;
            }
            if (msg.getType() == 999999) break;
            try {
                msg.writeMessage(this._out);
                if (!this._messagesToWrite.isEmpty()) continue;
                this._out.flush();
            }
            catch (I2CPMessageException ime) {
                this._session.propogateError("Error writing out the message", ime);
                this._session.disconnect();
                break;
            }
            catch (IOException ioe) {
                this._session.propogateError("Error writing out the message", ioe);
                this._session.disconnect();
                break;
            }
        }
        this._messagesToWrite.clear();
    }
}

