/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.client.HandlerImpl;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionImpl;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.RequestLeaseSetMessage;

class RequestLeaseSetMessageHandler
extends HandlerImpl {
    private final Map<Destination, LeaseInfo> _existingLeaseSets = new ConcurrentHashMap<Destination, LeaseInfo>(4);

    public RequestLeaseSetMessageHandler(I2PAppContext context) {
        this(context, 21);
    }

    protected RequestLeaseSetMessageHandler(I2PAppContext context, int messageType) {
        super(context, messageType);
    }

    @Override
    public void handleMessage(I2CPMessage message, I2PSessionImpl session) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle message " + message);
        }
        RequestLeaseSetMessage msg = (RequestLeaseSetMessage)message;
        LeaseSet leaseSet = new LeaseSet();
        for (int i = 0; i < msg.getEndpoints(); ++i) {
            Lease lease = new Lease();
            lease.setGateway(msg.getRouter(i));
            lease.setTunnelId(msg.getTunnelId(i));
            lease.setEndDate(msg.getEndDate());
            leaseSet.addLease(lease);
        }
        this.signLeaseSet(leaseSet, session);
    }

    protected void signLeaseSet(LeaseSet leaseSet, I2PSessionImpl session) {
        leaseSet.setDestination(session.getMyDestination());
        LeaseInfo li = this._existingLeaseSets.get(session.getMyDestination());
        if (li == null) {
            li = new LeaseInfo(session.getMyDestination());
            this._existingLeaseSets.put(session.getMyDestination(), li);
            if (this._log.shouldLog(10)) {
                this._log.debug("Creating new leaseInfo keys for " + session.getMyDestination().calculateHash().toBase64());
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Caching the old leaseInfo keys for " + session.getMyDestination().calculateHash().toBase64());
        }
        leaseSet.setEncryptionKey(li.getPublicKey());
        leaseSet.setSigningKey(li.getSigningPublicKey());
        boolean encrypt = Boolean.parseBoolean(session.getOptions().getProperty("i2cp.encryptLeaseSet"));
        String sk = session.getOptions().getProperty("i2cp.leaseSetKey");
        if (encrypt && sk != null) {
            SessionKey key = new SessionKey();
            try {
                key.fromBase64(sk);
                leaseSet.encrypt(key);
                this._context.keyRing().put(session.getMyDestination().calculateHash(), key);
            }
            catch (DataFormatException dfe) {
                this._log.error("Bad leaseset key: " + sk);
            }
        }
        try {
            leaseSet.sign(session.getPrivateKey());
            SigningPrivateKey spk = li.getSigningPrivateKey();
            if (!this._context.isRouterContext() && spk.getType() != SigType.DSA_SHA1) {
                byte[] dummy = new byte[SigningPrivateKey.KEYSIZE_BYTES];
                this._context.random().nextBytes(dummy);
                spk = new SigningPrivateKey(dummy);
            }
            session.getProducer().createLeaseSet(session, leaseSet, spk, li.getPrivateKey());
            session.setLeaseSet(leaseSet);
        }
        catch (DataFormatException dfe) {
            session.propogateError("Error signing the leaseSet", dfe);
        }
        catch (I2PSessionException ise) {
            session.propogateError("Error sending the signed leaseSet", ise);
        }
    }

    private static class LeaseInfo {
        private final PublicKey _pubKey;
        private final PrivateKey _privKey;
        private final SigningPublicKey _signingPubKey;
        private final SigningPrivateKey _signingPrivKey;

        public LeaseInfo(Destination dest) {
            SimpleDataStructure[] signKeys;
            Object[] encKeys = KeyGenerator.getInstance().generatePKIKeypair();
            try {
                signKeys = KeyGenerator.getInstance().generateSigningKeys(dest.getSigningPublicKey().getType());
            }
            catch (GeneralSecurityException gse) {
                throw new IllegalStateException(gse);
            }
            this._pubKey = (PublicKey)encKeys[0];
            this._privKey = (PrivateKey)encKeys[1];
            this._signingPubKey = (SigningPublicKey)signKeys[0];
            this._signingPrivKey = (SigningPrivateKey)signKeys[1];
        }

        public PublicKey getPublicKey() {
            return this._pubKey;
        }

        public PrivateKey getPrivateKey() {
            return this._privKey;
        }

        public SigningPublicKey getSigningPublicKey() {
            return this._signingPubKey;
        }

        public SigningPrivateKey getSigningPrivateKey() {
            return this._signingPrivKey;
        }

        public int hashCode() {
            return DataHelper.hashCode(this._pubKey) + 7 * DataHelper.hashCode(this._privKey) + 49 * DataHelper.hashCode(this._signingPubKey) + 343 * DataHelper.hashCode(this._signingPrivKey);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof LeaseInfo)) {
                return false;
            }
            LeaseInfo li = (LeaseInfo)obj;
            return DataHelper.eq(this._pubKey, li.getPublicKey()) && DataHelper.eq(this._privKey, li.getPrivateKey()) && DataHelper.eq(this._signingPubKey, li.getSigningPublicKey()) && DataHelper.eq(this._signingPrivKey, li.getSigningPrivateKey());
        }
    }
}

