/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionId;

public class HostLookupMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 38;
    private long _reqID;
    private long _timeout;
    private int _lookupType;
    private Hash _hash;
    private String _host;
    private SessionId _sessionId;
    public static final int LOOKUP_HASH = 0;
    public static final int LOOKUP_HOST = 1;
    private static final long MAX_INT = 0xFFFFFFFFL;

    public HostLookupMessage() {
    }

    public HostLookupMessage(SessionId id, Hash h, long reqID, long timeout) {
        if (id == null || h == null) {
            throw new IllegalArgumentException();
        }
        if (reqID < 0L || reqID > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        if (timeout <= 0L || timeout > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this._sessionId = id;
        this._hash = h;
        this._reqID = reqID;
        this._timeout = timeout;
        this._lookupType = 0;
    }

    public HostLookupMessage(SessionId id, String host, long reqID, long timeout) {
        if (id == null || host == null) {
            throw new IllegalArgumentException();
        }
        if (reqID < 0L || reqID > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        if (timeout <= 0L || timeout > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this._sessionId = id;
        this._host = host;
        this._reqID = reqID;
        this._timeout = timeout;
        this._lookupType = 1;
    }

    public SessionId getSessionId() {
        return this._sessionId;
    }

    public long getReqID() {
        return this._reqID;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public int getLookupType() {
        return this._lookupType;
    }

    public Hash getHash() {
        return this._hash;
    }

    public String getHostname() {
        return this._host;
    }

    @Override
    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        block5: {
            try {
                this._sessionId = new SessionId();
                this._sessionId.readBytes(in);
                this._reqID = DataHelper.readLong(in, 4);
                this._timeout = DataHelper.readLong(in, 4);
                this._lookupType = (int)DataHelper.readLong(in, 1);
                if (this._lookupType == 0) {
                    this._hash = Hash.create(in);
                    break block5;
                }
                if (this._lookupType == 1) {
                    this._host = DataHelper.readString(in);
                    if (this._host.length() == 0) {
                        throw new I2CPMessageException("bad host");
                    }
                    break block5;
                }
                throw new I2CPMessageException("bad type");
            }
            catch (DataFormatException dfe) {
                throw new I2CPMessageException("bad data", dfe);
            }
        }
    }

    @Override
    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        int len;
        if (this._lookupType == 0) {
            if (this._hash == null) {
                throw new I2CPMessageException("Unable to write out the message as there is not enough data");
            }
            len = 43;
        } else if (this._lookupType == 1) {
            if (this._host == null) {
                throw new I2CPMessageException("Unable to write out the message as there is not enough data");
            }
            len = 12 + this._host.length();
        } else {
            throw new I2CPMessageException("bad type");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(len);
        try {
            this._sessionId.writeBytes(os);
            DataHelper.writeLong(os, 4, this._reqID);
            DataHelper.writeLong(os, 4, this._timeout);
            DataHelper.writeLong(os, 1, this._lookupType);
            if (this._lookupType == 0) {
                this._hash.writeBytes(os);
            } else {
                DataHelper.writeString(os, this._host);
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("bad data", dfe);
        }
        return os.toByteArray();
    }

    @Override
    public int getType() {
        return 38;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[HostLookupMessage: ");
        buf.append("\n\t").append(this._sessionId);
        buf.append("\n\tReqID: ").append(this._reqID);
        buf.append("\n\tTimeout: ").append(this._timeout);
        if (this._lookupType == 0) {
            buf.append("\n\tHash: ").append(this._hash);
        } else if (this._lookupType == 1) {
            buf.append("\n\tHost: ").append(this._host);
        }
        buf.append("]");
        return buf.toString();
    }
}

