/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CachedIteratorArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 4863212596318574111L;
    private final CachedIterator iterator = new CachedIterator();

    public CachedIteratorArrayList() {
    }

    public CachedIteratorArrayList(Collection<? extends E> c) {
        super(c);
    }

    public CachedIteratorArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public Iterator<E> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    static /* synthetic */ int access$100(CachedIteratorArrayList x0) {
        return x0.modCount;
    }

    private class CachedIterator
    implements Iterator<E>,
    Serializable {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount = CachedIteratorArrayList.access$100(CachedIteratorArrayList.this);

        private CachedIterator() {
        }

        void reset() {
            this.cursor = 0;
            this.lastRet = -1;
            this.expectedModCount = CachedIteratorArrayList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != CachedIteratorArrayList.this.size();
        }

        @Override
        public E next() {
            this.checkForComodification();
            try {
                int i = this.cursor;
                Object next = CachedIteratorArrayList.this.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                CachedIteratorArrayList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = CachedIteratorArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (CachedIteratorArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

