(ns {{name}}.app
  (:require-macros [cljs.core.async.macros :refer [go go-loop alt!]])
  (:require [goog.events :as events]
            [goog.Timer :as timer]
            [cljs.core.async :refer [put! <! >! chan timeout]]
            [om.core :as om :include-macros true]
            [om.dom :as dom :include-macros true]
            [cljs-http.client :as http]
            [sablano.core :as html :refer-macros [html]]
            [{{name}}.util :as util :refer [$]]))

(defonce app-channel (chan))

(defmulti handle-event (fn [owner state [type & event-data]] type))

(defmethod handle-event :reload [owner _ _]
  (om/refresh! owner))

(defn start-handling-events [owner state ch]
  (go-loop [evt (<! ch)]
    (handle-event owner state evt)))

(defn app-view [cursor owner]
  (reify

    om/IWillMount
    (will-mount [_]
      (start-handling-events owner state app-channel))

    om/IRender
    (render [_]
      (html
       [:div
        [:nav {:class "top-bar foundation-bar"}
         [:div {:class "row"}
          [:div {:class "large-12 columns"}
           [:h1 "test-app"]]]]
        [:div {:class "row"}
         [:div {:class "large-12 columns"}
          "TODO: Implement me"]]]))))

(def app (atom {}))

(defmulti handle-event (fn [[type event-data] state] type))

(defmethod handle-event :timer [[_ {:keys [time]}] state]
  (println "The timer went off at" time)
  (om/update! state :last-time time))

(defn main [target state]
  (om/root app-view state
           {:target target}))

(defn setup! []
  (main (.getElementById js/document "app") app))

(set! (.-onload js/window) setup!)
