(defproject {{name}} "0.1.0-SNAPSHOT"
  :description "FIXME: write description"
  :url "http://example.com/FIXME"
  :dependencies
  [
   ;; Server deps
   [org.clojure/clojure "1.6.0"]
   [compojure "1.1.9"]
   [ring/ring-core "1.3.1"]
   [ring/ring-jetty-adapter "1.3.1"]
   [org.clojure/core.async "0.1.338.0-5c5012-alpha"]

   ;; clojurescript deps
   [org.clojure/clojurescript "0.0-2342"]
   [om "0.7.3"]
   [com.facebook/react "0.11.2"]
   [sablono "0.2.22"]
   [cljs-http "0.1.16"]]

  :plugins [[lein-ring "0.8.11"]
            [lein-cljsbuild "1.0.3"]
            [lein-pdo "0.1.1"]
            [com.cemerick/austin "0.1.5"]
            [lein-figwheel "0.1.4-SNAPSHOT"]]

  :aliases {"up" ["pdo" "cljsbuild" "auto" "dev," "ring" "server-headless", "figwheel"]}

  :profiles
  {:dev {:dependencies [[javax.servlet/servlet-api "2.5"]
                        [ring-mock "0.1.5"]
                        [org.clojure/tools.namespace "0.2.7"]]
         :source-paths ["dev"]}}

  :ring {:handler {{name}}.app/handler
         :nrepl {:start? true :port 3001}
         :port 3000}

  :figwheel
  {:http-server-root "public"
   :css-dirs ["resources/public/css"]
   :port 3002
   :ring-handler {{name.app/handler}}}

  :cljsbuild
  {:builds
   {:dev
    {:source-paths ["src-cljs"]
     :compiler
     {:output-to "resources/public/js/app.js"
      :output-dir "resources/public/js"
      :optimizations :none
      :pretty-print true
      :source-map "resources/public/js/app.js.map"
      :externs ["react/externs/react.js"]}
    :prod
     {:source-paths ["src-cljs"]
      :compiler
      {:output-to "resources/public/js-min/app-min.js"
       :output-dir "resources/public/js-min"
       :optimizations :advanced
       :pretty-print false
       :source-map "resources/public/js-min/app-min.js.map"
       :preamble ["react/react.min.js"]
       :externs ["react/externs/react.js"]}}}}})
