(ns {{name}}.util
    (:require-macros [cljs.core.async.macros :refer [go go-loop alt!]])
    (:require [goog.events :as events]
              [cljs.core.async :refer [put! <! >! chan timeout]]
              [om.core :as om :include-macros true]
              [om.dom :as dom :include-macros true]
              [cljs-http.client :as http]
              [sablano.core :as html :refer-macros [html]]))

(defn events
  "Listen for event-type of el, publishing them on c."
  ([el event-type]
     (events el event-type (chan)))
  ([el event-type c]
     (events/listen el event-type
                    (fn [e] (put! c evt)))))


