(ns qbits.perf
  (:gen-class)
  (:require [qbits.alia :as alia]
            [qbits.knit :as knit]
            [qbits.hayt :as hayt]))

;; (alia/set-executor! (knit/executor :fixed :num-threads 100))

(defn -main [& args]
  (let [cluster (alia/cluster ["127.0.0.1"]
                              ;; :pooling-options {:core-connections-per-host [:local 16 :remote 16]
                              ;;                   :max-connections-per-host  [:local 1000 :remote 1000]
                              ;;                   :max-simultaneous-requests-per-connection [:local 32 :remote 32]
                              ;;                   :min-simultaneous-requests-per-connection [:local 16 :remote 16]
                              ;; }
                              )
        session (alia/connect cluster)
        hq (hayt/->prepared (hayt/insert :entities
                                         (hayt/values {:id :entity  :num 0})
                                         (hayt/using :timestamp 1234)))]

    (alia/set-consistency! :any)

    (try (->> (hayt/create-keyspace :aliaperftest
                                (hayt/with {:replication
                                            {:class "SimpleStrategy"
                                             :replication_factor 3
                                             ;; :dc1 3 :dc2 3
                                             }}))
          hayt/->raw
          (alia/execute session))
         (catch Exception _ nil))

    (->> (hayt/use-keyspace :aliaperftest)
         hayt/->raw
         (alia/execute session))


    (try (->> (hayt/create-table :entities
                             (hayt/column-definitions {:id :varchar
                                                       :num :int
                                                       :primary-key [:id]}))
              hayt/->raw
              (alia/execute session))
         (catch Exception _ nil))

    (println "starting")
    (let [ps (alia/prepare session (first hq))
          num-entities 10000
          results (atom [])
          final-time (atom nil)
          start  (.getTime (java.util.Date.))]

      (dotimes [n num-entities]
        (alia/execute-async session ps
                            :values [(int 0) (str (java.util.UUID/randomUUID))]
                            :success (fn [r]
                                       (swap! results conj r))))

      (println "Done sending requests")

      (add-watch results
                 nil
                 (fn [k r o n]
                   (when (= (count n) num-entities)
                     (reset! final-time (- (.getTime (java.util.Date.)) start)))))

      (Thread/sleep 5000)
      (prn :final-time-ms @final-time :num-successes (count @results)))

    (try (->> (hayt/drop-table :entities)
              hayt/->raw
              (alia/execute session))
         (->> (hayt/drop-keyspace :aliaperftest)
              hayt/->raw
              (alia/execute session))
         (catch Exception _ nil))

    (alia/shutdown session)
    (alia/shutdown cluster)))

;; (-main)



;; Done sending requests
;; :final-time-ms 906 :num-successes 10000

;; Done sending requests
;; :final-time-ms 924 :num-successes 10000
