(ns playground
  (:use qbits.casyn)
  (:require [qbits.casyn :as c]
            [lamina.core :as lc]))

(def ks "testks")
(def cf "test_cf")
(def ccf "counter_cf")

(println :addks)

(try
  @(c/add-keyspace (c/make-client)
                   ks
                   "SimpleStrategy"
                   [[cf
                     :column-metadata [[:n0 :utf-8]
                                       [:n1 :utf-8 :n1_index :utf-8]
                                       [:n2 :long :n2_index :long]]]
                    [ccf
                     :default-validation-class :counter
                     :replicate-on-write true]]
                   :strategy-options {"replication_factor" "1"})

  (catch Exception e
    (println e)

    ))
(println :addksok)




(c/defschema test-schema
  :row :utf-8
  :super :utf-8
  :columns
  {:default [:utf-8 :utf-8]
   :exceptions {"age" :long}})

(c/defschema user-schema
  :row :utf-8
  :columns
  {:default [:utf-8 :utf-8]
   ;; :exceptions {"emails" {:composite [:utf-8 :utf-8]}}
   })

(def cl (c/make-cluster "localhost" 9160 ks
                        :failover :try-all
                        :auto-discovery false
                        ;; :pool {:max-active 12 :max-idle 12 :max-total 12}
                        ))
(println :make-clusterok)

(def client-x (c/client-fn cl))

;; ;; (prn (.default_name_type (:schema (meta t))))


;; (println   @(client-x execute-cql-query "SELECT * FROM test_cf;"))


;; (do
;;   (time
;;   (dotimes [i 1000]
;;     @(client-x c/batch-mutate1 {"1" {cf [(mutation "n1" "n1-value")
;;                                          (mutation "n2" "n2-value")
;;                                          (mutation "n3" "n3-value")
;;                                          (mutation "n4" "n4-value")]}
;;                                 "2" {cf [(mutation "n1" "n1-value")
;;                                          (mutation "n2" "n2-value")
;;                                          (mutation "n3" "n3-value")
;;                                          (mutation "n4" "n4-value")]}})
;;     ))

;;  (time
;;   (dotimes [i 1000]
;;     @(client-x c/batch-mutate  [[cf "1"  [(mutation "n1" "n1-value")
;;                                           (mutation "n2" "n2-value")
;;                                           (mutation "n3" "n3-value")
;;                                           (mutation "n4" "n4-value")]]
;;                                 [cf "2"  [(mutation "n1" "n1-value")
;;                                           (mutation "n2" "n2-value")
;;                                           (mutation "n3" "n3-value")
;;                                           (mutation "n4" "n4-value")]]])
;;     ))
;;  (println ";;;;;;;;;;;;;;;;")

;;  )

;; (prn client-x)

;; (prn (.nodes (.balancer cl)))

;; (use 'qbits.casyn.auto-discovery)

;; (prn (cp/refresh cl (prn (discover cl))))
;; ;; (connection/close  client-pool)

;; (prn @(client-x c/insert-column
;;                 cf
;;                 "1"
;;                 "col-name" "col-value"))



;; (prn
;;  @(client-x c/get-column
;;             cf
;;             "1"
;;             "col-name"))


;; ;; (println @(lc/run-pipeline
;; ;;            (client-x c/insert-column
;; ;;                      cf
;; ;;                      "1"
;; ;;                      "col-name" "col-value")

;; ;;          (fn [_]
;; ;;            @(client-x c/get-column
;; ;;                       cf
;; ;;                       "1"
;; ;;                       "col-name")

;; ;;            )
;; ;;          ))


(prn @(client-x c/insert-column
              cf
              "1"
              "col-name" "col-value"))

(println @(client-x c/get-column
                    cf
                    "1"
                    "col-name"))

(time
 (dotimes [d 100]
   (client-x c/insert-column
              cf
              "1"
              "col-name" "col-value")))
