(ns qbits.spex.hiccup
  (:require
   [clojure.spec :as s]
   [clojure.spec.test :as t]
   [clojure.spec.gen :as g]
   [clojure.test.check.generators :as gen]))

(s/def ::valid-tag #{:div :a :p })

(s/def ::tag
  (s/cat :tag-name ::valid-tag
         :rest (s/* (s/or :text ::text
                      :attributes ::attributes
                      :tag ::tag))))
(s/def ::text string?)
(s/def ::attributes (s/map-of keyword? any?))

(s/explain (s/cat :a string? :b keyword?))
;; (g/sample (s/gen ::tag))
