(ns rightangle.persona.verifier
  (:require [clj-http.client :as client]
            [clojure.data.json :as json]))

(def ^:private login-url "https://verifier.login.persona.org/verify")

(defn verify
  "Verifies the given assertion against the remote verification API described
  in https://developer.mozilla.org/en-US/Persona/Remote_Verification_API and
  returns the decoded JSON as a map, or nil if there was a problem with the
  request."
  [assertion audience]
  (let [params {:assertion assertion, :audience audience}
        response (client/post login-url {:form-params params})]
    (if (= 200 (:status response))
      (json/read-json (:body response)))))

(defn valid?
  "True if the response from the remote verification API contains an
  \"okay\" status code, otherwise false."
  [response]
  (if response
    (= "okay" (:status response))
    false))
