(ns kuro.fude
  (:use benri.kuro)
  (:require [clojure.string :as str]
            [clojure.core.match :refer [match]]))
; (with-tokenizer :learning
;   (find-token-candidates {:surfaceForm "日本" :partOfSpeech "名詞,固有名詞,地域,国"} (keys model)))
(comment
(binding [*debug* true]
  (->> (with-tokenizer :learning
         (clj-tokenize "海砂 は　どうした　高田 は？"))
       (map :surfaceForm)
       ;(<- (nth 3))
       ))
)

;(def foo
;(binding [*debug* true]
;  (->> (with-tokenizer :learning (clj-tokenize "でもクーラーの温度の下げすぎは体によくありません"))
;       (map :surfaceForm)))
;)
(comment
(binding [*debug* true]
(->> (with-tokenizer :learning (clj-tokenize "もうお前は終わりだ。"))
     (map :surfaceForm)))
)

(comment
(binding [*debug* true]
  (->> (with-tokenizer :learning
         (clj-tokenize-helper
           "後 に　就いて　言って　下さい。 もう　一度。 全部　一緒 に。 はじめ から。"))
  (map :surfaceForm)))
)

(comment
(str/replace "後 に　就いて　言って　下さい。 もう　一度。 全部　一緒 に。 はじめ から。" #"[　 ]+" "")
)

(comment
(binding [*debug* true]
  (->> (with-tokenizer :search
         (clj-tokenize-helper
           "冷やしすぎないようにしてください。死んだあと。"))
       (map :surfaceForm)))
)
;(str/replace "下さい。" #"^" "")
(defonce training-data
  (str "後に　就いて　言って　下さい。 もう一度。 全部　一緒 に。 はじめ から。"
       "次 を　どうぞ。 よく　できる。 おはよう　ございます。 どうも　ありがとう　ございます。 "
       "どういたしまして。 お元気　です　か。 いかが　です　か。 元気　です。 まあまあ　です。 "
       "おかげさまで。 お蔭様 で。 行って　来ます。 行って　いらっしゃい。 が行ってらっしゃい。 "
       "ただいま。 お帰りなさい。 Ｌ　です。 まだまだ　暑い　日 が　続きます　ね。 "
       "でも　クーラー の　温度 の　下げすぎ は　体 に　よく　ありません。 "
       "今夜 は 「きんようとくべつ　ロードショー」と　題して。 "
       "皆　さん　お待ち　か。 皆　さん　お待ち　かね。 "
       "「デスノートリライト　２　Ｌ を　継ぐ者」を　お送り　いたします。 続編　であり。 "
       "日本 に　行きます。 必ず　２７　度前後 に　して。 "
       "冷やしすぎない　ように　して　ください。 死んだ　あと。 "
       "昨年　放送　された 「リライト　幻視　する　神」の　続編　であり。 "
       "キラ と　私 の　後継　者 を　名乗る　人物 が　戦う　お話　だ　そう　です。 "
       "ここ から は　前作 を　ご覧 に　なっていない　方 の　ため に。"
       "それ　じゃあ　ワタリ　始めて　くれ。 いい　くらい の　真面目な　優等生　だ　よ。 "
       "デスノート を　拾った　こと を　きっかけ に、 "
       "あらゆる　人々 を　翻弄　する　孤高 の　殺人者。 "
       "キラ　事件　参考人 として　拘束　された が　"
       "その　最中　別 の　キラ が　現れ　動き　始めた　ため、 "
       "キラ　捜査 に　協力　する　こと と　なる。 新世界 の　神 と　なる。 "
       "Ｌ　キラ を　追う　世界　的　探偵。 キラ　事件　により　初めて　表舞台 に　立つ。 "
       "明晰な　頭脳 と　迅速な　行動力 で、 "
       "私 は　夜神君 を　キラ　じゃない　かと　疑っているんです。 "
       "かいつまん で　お話し　しましょう。 この　物語 の　主人公　夜　神月、 "
       "キラ として　暗躍、 時に　協力し　時 に　傍観し、 持つ第　２ の　キラ。 "
       "女優 と　いった。 夜　神月 に　協力　する。 にっぽん　そうさほんぶ、 刑事たち、 "
       "混成　チーム で、 ヨツバ　という　企業 に、 そして　ついに、 "
       "そして　ついに　真 の　キラ と　目　された。 目 を　持つ第　２ の　キラ。 "
       "彼 の　ため　ならば　何でも　する　という　魔性 の　持ち主。 "
       "もう　お前 は　終わり　だ。 待っている の も　面倒　だ。 書け　こいつら を…　"
       "牢獄 に　入れられたんじゃ　いつ　死ぬ　か　分からない。 できる　掟　だ。 "
       "人間界 に　持ち込んだ。 月君　待て、 これ は　もう…　止血 を！　"
       "俺 が　お前 の　名前 を　俺 の　ノート に　書く　こと に　なる と、 "
       "海砂 は　どうした　高田 は？　ニア　終わりました　ね。 クソ…　何 だ…　これ は…
"))

(defn some-space
  "Returns space surfaceForm from token, or nil if token isn't any space."
  [token] (some #{(:surfaceForm token)} [" " "　"]))

(defn inject-space-info
  "Inserts space information (:prev-space/:next-space) into a token if the
   other token is a space."
  [prev-token next-token]
  [(or (some->> (some-space next-token) (assoc prev-token :next-space))
  	   prev-token)
   (or (some->> (some-space prev-token) (assoc next-token :prev-space))
   	   next-token)])

(defn- filter-by-some-part-of-speech
  [n {:keys [partOfSpeech]} tokens]
  (let [take-n (partial take n)
        split-speech #(str/split % #",")
        partOfSpeech (split-speech partOfSpeech)
        equal-speech #(= (take-n partOfSpeech) (-> % :partOfSpeech take-n))
        f (comp equal-speech #(update % :partOfSpeech split-speech))]
  	(seq (filter f tokens))))

(defn- filter-by-surface
  [{:keys [surfaceForm]} tokens]
  (seq (filter #(= (:surfaceForm %) surfaceForm) tokens)))

(defmulti elect-by (fn [& args] (first args)))

(defmethod elect-by :surface-and-part-of-speech
  [_ n token tokens]
  (let [take-n #(take n %)]
  	(->> (filter-by-some-part-of-speech n token tokens)
  		   (filter-by-surface token))))

(defmethod elect-by :part-of-speech [_ n token tokens]
  (filter-by-some-part-of-speech n token tokens))

(defmethod elect-by :surface [_ token tokens]
  (filter-by-surface token tokens))

(defn find-token-candidates
  [token the-model]
  "Accepts token and model returning a list of token candidates."
  (or (some->> (elect-by :surface-and-part-of-speech 4 token the-model)
               (map #(assoc % :elect 1)))
      (some->> (elect-by :surface-and-part-of-speech 3 token the-model)
               (map #(assoc % :elect 2)))
      (some->> (elect-by :surface-and-part-of-speech 2 token the-model)
               (map #(assoc % :elect 3)))
      (some->> (elect-by :part-of-speech 4 token the-model)
               (map #(assoc % :elect 4)))
      (some->> (elect-by :part-of-speech 3 token the-model)
               (map #(assoc % :elect 5)))
      (some->> (elect-by :surface-and-part-of-speech 1 token the-model)
               (map #(assoc % :elect 6)))
      (some->> (elect-by :part-of-speech 2 token the-model)
               (map #(assoc % :elect 7)))
      (some->> (elect-by :part-of-speech 1 token the-model)
               (map #(assoc % :elect 8)))
      (some->> (elect-by :surface token the-model)
               (map #(assoc % :elect 9)))))

(defn remove-token-dups
  [tokens]
  (let [merge-dups (fn [prev nekt]
                     (if (= (:position prev) (:position nekt))
                       (merge prev nekt) [prev nekt]))]
    (loop [t (vec tokens) r []]
      (match [t r]
        [[] _] (reverse r)
        [[h1 & r1] []] (recur r1 [h1])
        [[h1 & r1] [h2 & r2]]
          (recur r1 (-> (merge-dups h1 h2) (cons r2) flatten vec))))))
