/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import com.theoryinpractise.clojure.AbstractClojureCompilerMojo;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ClojureCompilerMojo
extends AbstractClojureCompilerMojo {
    @Parameter(required=true, defaultValue="false")
    protected Boolean temporaryOutputDirectory;
    @Parameter(required=false, defaultValue="false")
    protected Boolean cleanAOTNamespaces;
    public static final Map<String, Character> DEMUNGE_MAP = new HashMap<String, Character>(){
        {
            this.put("/", Character.valueOf('.'));
            this.put("$", Character.valueOf('/'));
            this.put("_COLON_", Character.valueOf(':'));
            this.put("_PLUS_", Character.valueOf('+'));
            this.put("_GT_", Character.valueOf('>'));
            this.put("_LT_", Character.valueOf('<'));
            this.put("_EQ_", Character.valueOf('='));
            this.put("_TILDE_", Character.valueOf('~'));
            this.put("_BANG_", Character.valueOf('!'));
            this.put("_CIRCA_", Character.valueOf('@'));
            this.put("_SHARP_", Character.valueOf('#'));
            this.put("_SINGLEQUOTE_", Character.valueOf('\''));
            this.put("_DOUBLEQUOTE_", Character.valueOf('\"'));
            this.put("_PERCENT_", Character.valueOf('%'));
            this.put("_CARET_", Character.valueOf('^'));
            this.put("_AMPERSAND_", Character.valueOf('&'));
            this.put("_STAR_", Character.valueOf('*'));
            this.put("_BAR_", Character.valueOf('|'));
            this.put("_LBRACE_", Character.valueOf('{'));
            this.put("_RBRACE_", Character.valueOf('}'));
            this.put("_LBRACK_", Character.valueOf('['));
            this.put("_RBRACK_", Character.valueOf(']'));
            this.put("_SLASH_", Character.valueOf('/'));
            this.put("_BSLASH_", Character.valueOf('\\'));
            this.put("_QMARK_", Character.valueOf('?'));
        }
    };
    public static final Pattern DEMUNGE_PATTERN;

    public void execute() throws MojoExecutionException {
        File outputPath = this.temporaryOutputDirectory != false ? this.createTemporaryDirectory("classes") : this.outputDirectory;
        this.getLog().debug((CharSequence)("Compiling clojure sources to " + outputPath.getPath()));
        this.callClojureWith(this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.COMPILE), outputPath, (List<String>)this.classpathElements, "clojure.lang.Compile", this.discoverNamespaces());
        if (!this.temporaryOutputDirectory.booleanValue() && this.cleanAOTNamespaces.booleanValue()) {
            this.cleanAOTNamespaces(this.outputDirectory, this.namespaces);
        }
        this.copyNamespaceSourceFilesToOutput(this.outputDirectory, this.discoverNamespacesToCopy());
    }

    private void cleanAOTNamespaces(final File outputDirectory, String[] namespaces) {
        String[] stringArray;
        this.getLog().debug((CharSequence)("Cleaning output directory " + outputDirectory.getPath() + " of undesired AOT classes"));
        if (namespaces == null || namespaces.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ".*";
        } else {
            stringArray = namespaces;
        }
        final String[] namespaceFilterRegexs = stringArray;
        IFileProcessor fileCleaner = new IFileProcessor(){

            public boolean doFile(File file) {
                String classFilePath = file.getPath().substring(outputDirectory.getPath().length() + 1);
                if (!classFilePath.endsWith(".class")) {
                    return false;
                }
                if ((classFilePath = classFilePath.substring(0, classFilePath.lastIndexOf(".class"))).endsWith("__init")) {
                    classFilePath = classFilePath.substring(0, classFilePath.lastIndexOf("__init"));
                } else if (classFilePath.contains("$")) {
                    classFilePath = classFilePath.substring(0, classFilePath.indexOf("$"));
                } else {
                    return false;
                }
                String namespace = ClojureCompilerMojo.this.demunge(classFilePath);
                boolean toRemove = ClojureCompilerMojo.this.compileDeclaredNamespaceOnly;
                for (String regex : namespaceFilterRegexs) {
                    if (regex.startsWith("!")) {
                        if (!Pattern.compile("^" + regex.substring(1)).matcher(namespace).matches()) continue;
                        toRemove = true;
                        break;
                    }
                    if (!Pattern.compile("^" + regex).matcher(namespace).matches()) continue;
                    toRemove = true;
                }
                if (toRemove) {
                    file.delete();
                    if (ClojureCompilerMojo.this.getLog().isDebugEnabled()) {
                        ClojureCompilerMojo.this.getLog().debug((CharSequence)("Namespace " + namespace + " must not be compiled according to pom regexes. Removing file " + file.getPath()));
                    }
                    return true;
                }
                return false;
            }
        };
        long processedFiles = this.recurseDirectoryFiles(outputDirectory, fileCleaner, true);
        this.getLog().info((CharSequence)(processedFiles + " AOT classes have been cleaned up after compilation"));
    }

    private long recurseDirectoryFiles(File d, IFileProcessor fp, boolean deleteEmptyDirs) {
        long processedFiles = 0L;
        for (File f : d.listFiles()) {
            if (f.isDirectory() && f.canRead()) {
                processedFiles += this.recurseDirectoryFiles(f, fp, deleteEmptyDirs);
                if (!deleteEmptyDirs || f.listFiles().length != 0) continue;
                f.delete();
                continue;
            }
            if (!fp.doFile(f)) continue;
            ++processedFiles;
        }
        return processedFiles;
    }

    public String demunge(String mungedName) {
        StringBuilder sb = new StringBuilder();
        Matcher m = DEMUNGE_PATTERN.matcher(mungedName);
        int lastMatchEnd = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            sb.append(mungedName.substring(lastMatchEnd, start));
            lastMatchEnd = end;
            Character origCh = DEMUNGE_MAP.get(m.group());
            sb.append(origCh);
        }
        sb.append(mungedName.substring(lastMatchEnd));
        String result = sb.toString();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("demunged " + mungedName + " into " + result));
        }
        return result;
    }

    static {
        String[] mungeStrs = DEMUNGE_MAP.keySet().toArray(new String[DEMUNGE_MAP.keySet().size()]);
        Arrays.sort(mungeStrs, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s2.length() - s1.length();
            }
        });
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        String[] stringArray = mungeStrs;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String s;
            String escapeStr = s = stringArray[i];
            if (!first) {
                sb.append("|");
            }
            first = false;
            sb.append("\\Q");
            sb.append(escapeStr);
            sb.append("\\E");
        }
        DEMUNGE_PATTERN = Pattern.compile(sb.toString());
    }

    private static interface IFileProcessor {
        public boolean doFile(File var1);
    }
}

