goog.provide('clojure.data');
goog.require('cljs.core');
goog.require('clojure.set');
/**
 * Internal helper for diff.
 */
clojure.data.atom_diff = (function clojure$data$atom_diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,null], null);
}
});
/**
 * Convert an associative-by-numeric-index collection into
 * an equivalent vector, with nil for any missing keys
 */
clojure.data.vectorize = (function clojure$data$vectorize(m){
if(cljs.core.seq(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,p__27154){
var vec__27155 = p__27154;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27155,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27155,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,k,v);
}),cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.keys(m)),null)),m);
} else {
return null;
}
});
/**
 * Diff associative things a and b, comparing only the key k.
 */
clojure.data.diff_associative_key = (function clojure$data$diff_associative_key(a,b,k){
var va = cljs.core.get.cljs$core$IFn$_invoke$arity$2(a,k);
var vb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,k);
var vec__27173 = (clojure.data.diff.cljs$core$IFn$_invoke$arity$2 ? clojure.data.diff.cljs$core$IFn$_invoke$arity$2(va,vb) : clojure.data.diff.call(null,va,vb));
var a_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27173,(0),null);
var b_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27173,(1),null);
var ab = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27173,(2),null);
var in_a = cljs.core.contains_QMARK_(a,k);
var in_b = cljs.core.contains_QMARK_(b,k);
var same = ((in_a) && (in_b) && (((!((ab == null))) || ((((va == null)) && ((vb == null)))))));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [((((in_a) && (((!((a_STAR_ == null))) || (!(same))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,a_STAR_]):null),((((in_b) && (((!((b_STAR_ == null))) || (!(same))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,b_STAR_]):null),((same)?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,ab]):null)], null);
});
/**
 * Diff associative things a and b, comparing only keys in ks (if supplied).
 */
clojure.data.diff_associative = (function clojure$data$diff_associative(var_args){
var G__27215 = arguments.length;
switch (G__27215) {
case 2:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(a,b,clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.keys(a),cljs.core.keys(b)));
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3 = (function (a,b,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (diff1,diff2){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.merge,diff1,diff2));
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,null], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(clojure.data.diff_associative_key,a,b),ks));
});

clojure.data.diff_associative.cljs$lang$maxFixedArity = 3;

clojure.data.diff_sequential = (function clojure$data$diff_sequential(a,b){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.data.vectorize,clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(((cljs.core.vector_QMARK_(a))?a:cljs.core.vec(a)),((cljs.core.vector_QMARK_(b))?b:cljs.core.vec(b)),cljs.core.range.cljs$core$IFn$_invoke$arity$1((function (){var x__4006__auto__ = cljs.core.count(a);
var y__4007__auto__ = cljs.core.count(b);
return ((x__4006__auto__ > y__4007__auto__) ? x__4006__auto__ : y__4007__auto__);
})()))));
});
clojure.data.diff_set = (function clojure$data$diff_set(a,b){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(a,b)),cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(b,a)),cljs.core.not_empty(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(a,b))], null);
});

/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.EqualityPartition = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.equality_partition = (function clojure$data$equality_partition(x){
if(((!((x == null))) && (!((x.clojure$data$EqualityPartition$equality_partition$arity$1 == null))))){
return x.clojure$data$EqualityPartition$equality_partition$arity$1(x);
} else {
var x__4211__auto__ = (((x == null))?null:x);
var m__4212__auto__ = (clojure.data.equality_partition[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4212__auto__.call(null,x));
} else {
var m__4212__auto____$1 = (clojure.data.equality_partition["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__4212__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("EqualityPartition.equality-partition",x);
}
}
}
});


/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.Diff = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.diff_similar = (function clojure$data$diff_similar(a,b){
if(((!((a == null))) && (!((a.clojure$data$Diff$diff_similar$arity$2 == null))))){
return a.clojure$data$Diff$diff_similar$arity$2(a,b);
} else {
var x__4211__auto__ = (((a == null))?null:a);
var m__4212__auto__ = (clojure.data.diff_similar[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(a,b) : m__4212__auto__.call(null,a,b));
} else {
var m__4212__auto____$1 = (clojure.data.diff_similar["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(a,b) : m__4212__auto____$1.call(null,a,b));
} else {
throw cljs.core.missing_protocol("Diff.diff-similar",a);
}
}
}
});

goog.object.set(clojure.data.EqualityPartition,"null",true);

var G__27293_27350 = clojure.data.equality_partition;
var G__27294_27351 = "null";
var G__27295_27352 = ((function (G__27293_27350,G__27294_27351){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__27293_27350,G__27294_27351))
;
goog.object.set(G__27293_27350,G__27294_27351,G__27295_27352);

goog.object.set(clojure.data.EqualityPartition,"string",true);

var G__27296_27357 = clojure.data.equality_partition;
var G__27297_27358 = "string";
var G__27298_27360 = ((function (G__27296_27357,G__27297_27358){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__27296_27357,G__27297_27358))
;
goog.object.set(G__27296_27357,G__27297_27358,G__27298_27360);

goog.object.set(clojure.data.EqualityPartition,"number",true);

var G__27302_27367 = clojure.data.equality_partition;
var G__27303_27368 = "number";
var G__27304_27369 = ((function (G__27302_27367,G__27303_27368){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__27302_27367,G__27303_27368))
;
goog.object.set(G__27302_27367,G__27303_27368,G__27304_27369);

goog.object.set(clojure.data.EqualityPartition,"array",true);

var G__27308_27372 = clojure.data.equality_partition;
var G__27309_27373 = "array";
var G__27310_27374 = ((function (G__27308_27372,G__27309_27373){
return (function (x){
return new cljs.core.Keyword(null,"sequential","sequential",-1082983960);
});})(G__27308_27372,G__27309_27373))
;
goog.object.set(G__27308_27372,G__27309_27373,G__27310_27374);

goog.object.set(clojure.data.EqualityPartition,"function",true);

var G__27317_27380 = clojure.data.equality_partition;
var G__27318_27381 = "function";
var G__27319_27382 = ((function (G__27317_27380,G__27318_27381){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__27317_27380,G__27318_27381))
;
goog.object.set(G__27317_27380,G__27318_27381,G__27319_27382);

goog.object.set(clojure.data.EqualityPartition,"boolean",true);

var G__27320_27385 = clojure.data.equality_partition;
var G__27321_27386 = "boolean";
var G__27322_27387 = ((function (G__27320_27385,G__27321_27386){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__27320_27385,G__27321_27386))
;
goog.object.set(G__27320_27385,G__27321_27386,G__27322_27387);

goog.object.set(clojure.data.EqualityPartition,"_",true);

var G__27332_27389 = clojure.data.equality_partition;
var G__27333_27390 = "_";
var G__27334_27391 = ((function (G__27332_27389,G__27333_27390){
return (function (x){
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x))){
return new cljs.core.Keyword(null,"map","map",1371690461);
} else {
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x))){
return new cljs.core.Keyword(null,"set","set",304602554);
} else {
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x))){
return new cljs.core.Keyword(null,"sequential","sequential",-1082983960);
} else {
return new cljs.core.Keyword(null,"atom","atom",-397043653);

}
}
}
});})(G__27332_27389,G__27333_27390))
;
goog.object.set(G__27332_27389,G__27333_27390,G__27334_27391);
goog.object.set(clojure.data.Diff,"null",true);

var G__27411_27482 = clojure.data.diff_similar;
var G__27412_27483 = "null";
var G__27413_27484 = ((function (G__27411_27482,G__27412_27483){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__27411_27482,G__27412_27483))
;
goog.object.set(G__27411_27482,G__27412_27483,G__27413_27484);

goog.object.set(clojure.data.Diff,"string",true);

var G__27420_27487 = clojure.data.diff_similar;
var G__27421_27488 = "string";
var G__27422_27489 = ((function (G__27420_27487,G__27421_27488){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__27420_27487,G__27421_27488))
;
goog.object.set(G__27420_27487,G__27421_27488,G__27422_27489);

goog.object.set(clojure.data.Diff,"number",true);

var G__27427_27490 = clojure.data.diff_similar;
var G__27428_27491 = "number";
var G__27429_27492 = ((function (G__27427_27490,G__27428_27491){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__27427_27490,G__27428_27491))
;
goog.object.set(G__27427_27490,G__27428_27491,G__27429_27492);

goog.object.set(clojure.data.Diff,"array",true);

var G__27434_27493 = clojure.data.diff_similar;
var G__27435_27494 = "array";
var G__27436_27495 = ((function (G__27434_27493,G__27435_27494){
return (function (a,b){
return clojure.data.diff_sequential(a,b);
});})(G__27434_27493,G__27435_27494))
;
goog.object.set(G__27434_27493,G__27435_27494,G__27436_27495);

goog.object.set(clojure.data.Diff,"function",true);

var G__27445_27498 = clojure.data.diff_similar;
var G__27447_27499 = "function";
var G__27448_27500 = ((function (G__27445_27498,G__27447_27499){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__27445_27498,G__27447_27499))
;
goog.object.set(G__27445_27498,G__27447_27499,G__27448_27500);

goog.object.set(clojure.data.Diff,"boolean",true);

var G__27459_27501 = clojure.data.diff_similar;
var G__27460_27502 = "boolean";
var G__27462_27503 = ((function (G__27459_27501,G__27460_27502){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__27459_27501,G__27460_27502))
;
goog.object.set(G__27459_27501,G__27460_27502,G__27462_27503);

goog.object.set(clojure.data.Diff,"_",true);

var G__27466_27505 = clojure.data.diff_similar;
var G__27467_27506 = "_";
var G__27468_27507 = ((function (G__27466_27505,G__27467_27506){
return (function (a,b){
var fexpr__27472 = (function (){var G__27473 = clojure.data.equality_partition(a);
var G__27473__$1 = (((G__27473 instanceof cljs.core.Keyword))?G__27473.fqn:null);
switch (G__27473__$1) {
case "atom":
return clojure.data.atom_diff;

break;
case "set":
return clojure.data.diff_set;

break;
case "sequential":
return clojure.data.diff_sequential;

break;
case "map":
return clojure.data.diff_associative;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27473__$1)].join('')));

}
})();
return (fexpr__27472.cljs$core$IFn$_invoke$arity$2 ? fexpr__27472.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__27472.call(null,a,b));
});})(G__27466_27505,G__27467_27506))
;
goog.object.set(G__27466_27505,G__27467_27506,G__27468_27507);
/**
 * Recursively compares a and b, returning a tuple of
 *   [things-only-in-a things-only-in-b things-in-both].
 *   Comparison rules:
 * 
 *   * For equal a and b, return [nil nil a].
 *   * Maps are subdiffed where keys match and values differ.
 *   * Sets are never subdiffed.
 *   * All sequential things are treated as associative collections
 *  by their indexes, with results returned as vectors.
 *   * Everything else (including strings!) is treated as
 *  an atom and compared for equality.
 */
clojure.data.diff = (function clojure$data$diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.data.equality_partition(a),clojure.data.equality_partition(b))){
return clojure.data.diff_similar(a,b);
} else {
return clojure.data.atom_diff(a,b);
}
}
});

//# sourceMappingURL=clojure.data.js.map
