goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
com.rpl.specter.static_path_QMARK_ = (function com$rpl$specter$static_path_QMARK_(path){
if(cljs.core.sequential_QMARK_(path)){
return cljs.core.every_QMARK_(com.rpl.specter.static_path_QMARK_,path);
} else {
return cljs.core.not(com.rpl.specter.impl.dynamic_param_QMARK_(path));
}
});
com.rpl.specter.wrap_dynamic_nav = (function com$rpl$specter$wrap_dynamic_nav(f){
return (function() { 
var G__34239__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
if(cljs.core.truth_((function (){var and__3911__auto__ = cljs.core.sequential_QMARK_(ret);
if(and__3911__auto__){
return com.rpl.specter.static_path_QMARK_(ret);
} else {
return and__3911__auto__;
}
})())){
return com.rpl.specter.impl.comp_paths_STAR_(ret);
} else {
if(((cljs.core.sequential_QMARK_(ret)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(ret))))){
return cljs.core.first(ret);
} else {
return ret;

}
}
};
var G__34239 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34240__i = 0, G__34240__a = new Array(arguments.length -  0);
while (G__34240__i < G__34240__a.length) {G__34240__a[G__34240__i] = arguments[G__34240__i + 0]; ++G__34240__i;}
  args = new cljs.core.IndexedSeq(G__34240__a,0,null);
} 
return G__34239__delegate.call(this,args);};
G__34239.cljs$lang$maxFixedArity = 0;
G__34239.cljs$lang$applyTo = (function (arglist__34241){
var args = cljs.core.seq(arglist__34241);
return G__34239__delegate(args);
});
G__34239.cljs$core$IFn$_invoke$arity$variadic = G__34239__delegate;
return G__34239;
})()
;
});
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__4502__auto__ = [];
var len__4499__auto___34258 = arguments.length;
var i__4500__auto___34259 = (0);
while(true){
if((i__4500__auto___34259 < len__4499__auto___34258)){
args__4502__auto__.push((arguments[i__4500__auto___34259]));

var G__34260 = (i__4500__auto___34259 + (1));
i__4500__auto___34259 = G__34260;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});

com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_(cljs.core.vec(apath));
});

com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq34257){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34257));
});

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
var G__34261 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34262 = structure;
return (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(G__34261,G__34262) : com.rpl.specter.compiled_select.call(null,G__34261,G__34262));
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
var G__34263 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34264 = structure;
return (com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(G__34263,G__34264) : com.rpl.specter.compiled_select_one.call(null,G__34263,G__34264));
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
var G__34265 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34266 = structure;
return (com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2(G__34265,G__34266) : com.rpl.specter.compiled_select_one_BANG_.call(null,G__34265,G__34266));
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
var G__34267 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34268 = structure;
return (com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2(G__34267,G__34268) : com.rpl.specter.compiled_select_first.call(null,G__34267,G__34268));
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
var G__34269 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34270 = structure;
return (com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2(G__34269,G__34270) : com.rpl.specter.compiled_select_any.call(null,G__34269,G__34270));
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
var G__34271 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34272 = structure;
return (com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__34271,G__34272) : com.rpl.specter.compiled_selected_any_QMARK_.call(null,G__34271,G__34272));
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
var G__34273 = com.rpl.specter.impl.comp_paths_STAR_(apath);
var G__34274 = structure;
return (com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(G__34273,G__34274) : com.rpl.specter.compiled_traverse.call(null,G__34273,G__34274));
});
/**
 * Version of traverse-all that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse_all = com.rpl.specter.impl.compiled_traverse_all_STAR_;
/**
 * Returns a transducer that traverses over each element with the given path.
 */
com.rpl.specter.traverse_all_STAR_ = (function com$rpl$specter$traverse_all_STAR_(apath){
var G__34275 = com.rpl.specter.impl.comp_paths_STAR_(apath);
return (com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1(G__34275) : com.rpl.specter.compiled_traverse_all.call(null,G__34275));
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Version of vtransform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_vtransform = com.rpl.specter.impl.compiled_vtransform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
var G__34276 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34277 = transform_fn;
var G__34278 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__34276,G__34277,G__34278) : com.rpl.specter.compiled_transform.call(null,G__34276,G__34277,G__34278));
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal` or `vterminal`. Error is thrown if navigation finishes
 * at a non-terminal navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
var G__34279 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34280 = structure;
return (com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2(G__34279,G__34280) : com.rpl.specter.compiled_multi_transform.call(null,G__34279,G__34280));
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
var G__34281 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34282 = val;
var G__34283 = structure;
return (com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3(G__34281,G__34282,G__34283) : com.rpl.specter.compiled_setval.call(null,G__34281,G__34282,G__34283));
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__4502__auto__ = [];
var len__4499__auto___34296 = arguments.length;
var i__4500__auto___34297 = (0);
while(true){
if((i__4500__auto___34297 < len__4499__auto___34296)){
args__4502__auto__.push((arguments[i__4500__auto___34297]));

var G__34298 = (i__4500__auto___34297 + (1));
i__4500__auto___34297 = G__34298;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((3) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4503__auto__);
});

com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__34288){
var map__34289 = p__34288;
var map__34289__$1 = ((((!((map__34289 == null)))?(((((map__34289.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34289.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34289):map__34289);
var merge_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34289__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
var G__34291 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34292 = transform_fn;
var G__34293 = structure;
var G__34294 = new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341);
var G__34295 = merge_fn;
return (com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5 ? com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5(G__34291,G__34292,G__34293,G__34294,G__34295) : com.rpl.specter.compiled_replace_in.call(null,G__34291,G__34292,G__34293,G__34294,G__34295));
});

com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq34284){
var G__34285 = cljs.core.first(seq34284);
var seq34284__$1 = cljs.core.next(seq34284);
var G__34286 = cljs.core.first(seq34284__$1);
var seq34284__$2 = cljs.core.next(seq34284__$1);
var G__34287 = cljs.core.first(seq34284__$2);
var seq34284__$3 = cljs.core.next(seq34284__$2);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34285,G__34286,G__34287,seq34284__$3);
});

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (navfn){
var latenavfn = (com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1(navfn) : com.rpl.specter.late_resolved_fn.call(null,navfn));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav(((function (latenavfn){
return (function() { 
var G__34299__delegate = function (args){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(latenavfn,args);
};
var G__34299 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34300__i = 0, G__34300__a = new Array(arguments.length -  0);
while (G__34300__i < G__34300__a.length) {G__34300__a[G__34300__i] = arguments[G__34300__i + 0]; ++G__34300__i;}
  args = new cljs.core.IndexedSeq(G__34300__a,0,null);
} 
return G__34299__delegate.call(this,args);};
G__34299.cljs$lang$maxFixedArity = 0;
G__34299.cljs$lang$applyTo = (function (arglist__34301){
var args = cljs.core.seq(arglist__34301);
return G__34299__delegate(args);
});
G__34299.cljs$core$IFn$_invoke$arity$variadic = G__34299__delegate;
return G__34299;
})()
;})(latenavfn))
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34302 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34302 = (function (meta34303){
this.meta34303 = meta34303;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34302.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34304,meta34303__$1){
var self__ = this;
var _34304__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34302(meta34303__$1));
});

com.rpl.specter.t_com$rpl$specter34302.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34304){
var self__ = this;
var _34304__$1 = this;
return self__.meta34303;
});

com.rpl.specter.t_com$rpl$specter34302.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34302.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return com.rpl.specter.NONE;
});

com.rpl.specter.t_com$rpl$specter34302.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return structure;
});

com.rpl.specter.t_com$rpl$specter34302.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34303","meta34303",1869445249,null)], null);
});

com.rpl.specter.t_com$rpl$specter34302.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34302.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34302";

com.rpl.specter.t_com$rpl$specter34302.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34302");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34302.
 */
com.rpl.specter.__GT_t_com$rpl$specter34302 = (function com$rpl$specter$__GT_t_com$rpl$specter34302(meta34303){
return (new com.rpl.specter.t_com$rpl$specter34302(meta34303));
});

}

return (new com.rpl.specter.t_com$rpl$specter34302(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * Defines an endpoint in the navigation the transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter34305 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34305 = (function (afn,meta34306){
this.afn = afn;
this.meta34306 = meta34306;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34305.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34307,meta34306__$1){
var self__ = this;
var _34307__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34305(self__.afn,meta34306__$1));
});

com.rpl.specter.t_com$rpl$specter34305.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34307){
var self__ = this;
var _34307__$1 = this;
return self__.meta34306;
});

com.rpl.specter.t_com$rpl$specter34305.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34305.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
});

com.rpl.specter.t_com$rpl$specter34305.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_(self__.afn,vals,structure);
});

com.rpl.specter.t_com$rpl$specter34305.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta34306","meta34306",700541003,null)], null);
});

com.rpl.specter.t_com$rpl$specter34305.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34305.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34305";

com.rpl.specter.t_com$rpl$specter34305.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34305");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34305.
 */
com.rpl.specter.__GT_t_com$rpl$specter34305 = (function com$rpl$specter$__GT_t_com$rpl$specter34305(afn__$1,meta34306){
return (new com.rpl.specter.t_com$rpl$specter34305(afn__$1,meta34306));
});

}

return (new com.rpl.specter.t_com$rpl$specter34305(afn,null));
}));
/**
 * Defines an endpoint in the navigation the transform function run.The transform
 *        function works differently than it does in `transform`. Rather than receive
 *        collected vals spliced in as the first arguments to the function, this function
 *        always takes two arguemnts. The first is all collected vals in a vector, and
 *        the second is the navigated value.
 */
com.rpl.specter.vterminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter34308 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34308 = (function (afn,meta34309){
this.afn = afn;
this.meta34309 = meta34309;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34308.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34310,meta34309__$1){
var self__ = this;
var _34310__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34308(self__.afn,meta34309__$1));
});

com.rpl.specter.t_com$rpl$specter34308.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34310){
var self__ = this;
var _34310__$1 = this;
return self__.meta34309;
});

com.rpl.specter.t_com$rpl$specter34308.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34308.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
});

com.rpl.specter.t_com$rpl$specter34308.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(vals,structure) : self__.afn.call(null,vals,structure));
});

com.rpl.specter.t_com$rpl$specter34308.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta34309","meta34309",1243956276,null)], null);
});

com.rpl.specter.t_com$rpl$specter34308.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34308.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34308";

com.rpl.specter.t_com$rpl$specter34308.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34308");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34308.
 */
com.rpl.specter.__GT_t_com$rpl$specter34308 = (function com$rpl$specter$__GT_t_com$rpl$specter34308(afn__$1,meta34309){
return (new com.rpl.specter.t_com$rpl$specter34308(afn__$1,meta34309));
});

}

return (new com.rpl.specter.t_com$rpl$specter34308(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
var G__34311 = com.rpl.specter.impl.fast_constantly(v);
return (com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1(G__34311) : com.rpl.specter.terminal.call(null,G__34311));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform(structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34312 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34312 = (function (meta34313){
this.meta34313 = meta34313;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34312.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34314,meta34313__$1){
var self__ = this;
var _34314__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34312(meta34313__$1));
});

com.rpl.specter.t_com$rpl$specter34312.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34314){
var self__ = this;
var _34314__$1 = this;
return self__.meta34313;
});

com.rpl.specter.t_com$rpl$specter34312.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34312.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter34312.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return com.rpl.specter.navs.all_transform(structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter34312.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34313","meta34313",-1557079289,null)], null);
});

com.rpl.specter.t_com$rpl$specter34312.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34312.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34312";

com.rpl.specter.t_com$rpl$specter34312.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34312");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34312.
 */
com.rpl.specter.__GT_t_com$rpl$specter34312 = (function com$rpl$specter$__GT_t_com$rpl$specter34312(meta34313){
return (new com.rpl.specter.t_com$rpl$specter34312(meta34313));
});

}

return (new com.rpl.specter.t_com$rpl$specter34312(null));
})()
;


com.rpl.specter.ALL_WITH_META_select_STAR_ = (function com$rpl$specter$ALL_WITH_META_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_WITH_META_transform_STAR_ = (function com$rpl$specter$ALL_WITH_META_transform_STAR_(structure,next_fn){
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if(!((res == null))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
});

/**
 * Same as ALL, except maintains metadata on the structure.
 */
com.rpl.specter.ALL_WITH_META = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34315 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34315 = (function (meta34316){
this.meta34316 = meta34316;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34315.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34317,meta34316__$1){
var self__ = this;
var _34317__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34315(meta34316__$1));
});

com.rpl.specter.t_com$rpl$specter34315.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34317){
var self__ = this;
var _34317__$1 = this;
return self__.meta34316;
});

com.rpl.specter.t_com$rpl$specter34315.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34315.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter34315.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if(!((res == null))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
});

com.rpl.specter.t_com$rpl$specter34315.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34316","meta34316",1731630655,null)], null);
});

com.rpl.specter.t_com$rpl$specter34315.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34315.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34315";

com.rpl.specter.t_com$rpl$specter34315.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34315");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34315.
 */
com.rpl.specter.__GT_t_com$rpl$specter34315 = (function com$rpl$specter$__GT_t_com$rpl$specter34315(meta34316){
return (new com.rpl.specter.t_com$rpl$specter34315(meta34316));
});

}

return (new com.rpl.specter.t_com$rpl$specter34315(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__27440__auto__,v){
var ret__27441__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(v) : next_fn.call(null,v));
if((ret__27441__auto__ === com.rpl.specter.NONE)){
return curr__27440__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__27441__auto__)){
return cljs.core.reduced(ret__27441__auto__);
} else {
return ret__27441__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34318 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34318 = (function (meta34319){
this.meta34319 = meta34319;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34318.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34320,meta34319__$1){
var self__ = this;
var _34320__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34318(meta34319__$1));
});

com.rpl.specter.t_com$rpl$specter34318.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34320){
var self__ = this;
var _34320__$1 = this;
return self__.meta34319;
});

com.rpl.specter.t_com$rpl$specter34318.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34318.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (next_fn,this__32516__auto____$1){
return (function (curr__27440__auto__,v){
var ret__27441__auto__ = next_fn(v);
if((ret__27441__auto__ === com.rpl.specter.NONE)){
return curr__27440__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__27441__auto__)){
return cljs.core.reduced(ret__27441__auto__);
} else {
return ret__27441__auto__;
}
}
});})(next_fn,this__32516__auto____$1))
,com.rpl.specter.NONE,cljs.core.vals(structure));
});

com.rpl.specter.t_com$rpl$specter34318.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter34318.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34319","meta34319",-1393327078,null)], null);
});

com.rpl.specter.t_com$rpl$specter34318.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34318.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34318";

com.rpl.specter.t_com$rpl$specter34318.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34318");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34318.
 */
com.rpl.specter.__GT_t_com$rpl$specter34318 = (function com$rpl$specter$__GT_t_com$rpl$specter34318(meta34319){
return (new com.rpl.specter.t_com$rpl$specter34318(meta34319));
});

}

return (new com.rpl.specter.t_com$rpl$specter34318(null));
})()
;


com.rpl.specter.MAP_KEYS_select_STAR_ = (function com$rpl$specter$MAP_KEYS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__27440__auto__,k){
var ret__27441__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(k) : next_fn.call(null,k));
if((ret__27441__auto__ === com.rpl.specter.NONE)){
return curr__27440__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__27441__auto__)){
return cljs.core.reduced(ret__27441__auto__);
} else {
return ret__27441__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
});

com.rpl.specter.MAP_KEYS_transform_STAR_ = (function com$rpl$specter$MAP_KEYS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
});

/**
 * Navigate to each key of the map. This is more efficient than
 *        navigating via [ALL FIRST]
 */
com.rpl.specter.MAP_KEYS = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34321 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34321 = (function (meta34322){
this.meta34322 = meta34322;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34321.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34323,meta34322__$1){
var self__ = this;
var _34323__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34321(meta34322__$1));
});

com.rpl.specter.t_com$rpl$specter34321.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34323){
var self__ = this;
var _34323__$1 = this;
return self__.meta34322;
});

com.rpl.specter.t_com$rpl$specter34321.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34321.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (next_fn,this__32516__auto____$1){
return (function (curr__27440__auto__,k){
var ret__27441__auto__ = next_fn(k);
if((ret__27441__auto__ === com.rpl.specter.NONE)){
return curr__27440__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__27441__auto__)){
return cljs.core.reduced(ret__27441__auto__);
} else {
return ret__27441__auto__;
}
}
});})(next_fn,this__32516__auto____$1))
,com.rpl.specter.NONE,cljs.core.keys(structure));
});

com.rpl.specter.t_com$rpl$specter34321.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter34321.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34322","meta34322",1425612793,null)], null);
});

com.rpl.specter.t_com$rpl$specter34321.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34321.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34321";

com.rpl.specter.t_com$rpl$specter34321.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34321");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34321.
 */
com.rpl.specter.__GT_t_com$rpl$specter34321 = (function com$rpl$specter$__GT_t_com$rpl$specter34321(meta34322){
return (new com.rpl.specter.t_com$rpl$specter34321(meta34322));
});

}

return (new com.rpl.specter.t_com$rpl$specter34321(null));
})()
;
com.rpl.specter.VAL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34324 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34324 = (function (meta34325){
this.meta34325 = meta34325;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34324.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34326,meta34325__$1){
var self__ = this;
var _34326__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34324(meta34325__$1));
});

com.rpl.specter.t_com$rpl$specter34324.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34326){
var self__ = this;
var _34326__$1 = this;
return self__.meta34325;
});

com.rpl.specter.t_com$rpl$specter34324.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34324.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33123__auto__,vals__33124__auto__,structure,next_fn__33125__auto__){
var self__ = this;
var this__33123__auto____$1 = this;
var G__34327 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33124__auto__,structure);
var G__34328 = structure;
return (next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2(G__34327,G__34328) : next_fn__33125__auto__.call(null,G__34327,G__34328));
});

com.rpl.specter.t_com$rpl$specter34324.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33123__auto__,vals__33124__auto__,structure,next_fn__33125__auto__){
var self__ = this;
var this__33123__auto____$1 = this;
var G__34329 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33124__auto__,structure);
var G__34330 = structure;
return (next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2(G__34329,G__34330) : next_fn__33125__auto__.call(null,G__34329,G__34330));
});

com.rpl.specter.t_com$rpl$specter34324.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34325","meta34325",-701969515,null)], null);
});

com.rpl.specter.t_com$rpl$specter34324.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34324.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34324";

com.rpl.specter.t_com$rpl$specter34324.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34324");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34324.
 */
com.rpl.specter.__GT_t_com$rpl$specter34324 = (function com$rpl$specter$__GT_t_com$rpl$specter34324(meta34325){
return (new com.rpl.specter.t_com$rpl$specter34324(meta34325));
});

}

return (new com.rpl.specter.t_com$rpl$specter34324(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last));
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first));


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
var G__34331 = structure;
var G__34332 = s;
var G__34333 = com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s);
var G__34334 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__34331,G__34332,G__34333,G__34334) : com.rpl.specter.navs.srange_transform.call(null,G__34331,G__34332,G__34333,G__34334));
});

/**
 * Uses start-index-fn and end-index-fn to determine the bounds of the subsequence
 *        to select when navigating. `start-index-fn` takes in the structure as input. `end-index-fn`
 *        can be one of two forms. If a regular function (e.g. defined with `fn`), it takes in only the structure as input. If a function defined using special `end-fn` macro, it takes in the structure and the result of `start-index-fn`.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj((function (start_index_fn,end_index_fn){
if(typeof com.rpl.specter.t_com$rpl$specter34335 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34335 = (function (start_index_fn,end_index_fn,meta34336){
this.start_index_fn = start_index_fn;
this.end_index_fn = end_index_fn;
this.meta34336 = meta34336;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34335.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34337,meta34336__$1){
var self__ = this;
var _34337__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34335(self__.start_index_fn,self__.end_index_fn,meta34336__$1));
});

com.rpl.specter.t_com$rpl$specter34335.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34337){
var self__ = this;
var _34337__$1 = this;
return self__.meta34336;
});

com.rpl.specter.t_com$rpl$specter34335.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34335.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s),next_fn);
});

com.rpl.specter.t_com$rpl$specter34335.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
var G__34338 = structure;
var G__34339 = s;
var G__34340 = com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s);
var G__34341 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__34338,G__34339,G__34340,G__34341) : com.rpl.specter.navs.srange_transform.call(null,G__34338,G__34339,G__34340,G__34341));
});

com.rpl.specter.t_com$rpl$specter34335.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-index-fn","start-index-fn",-344842645,null),new cljs.core.Symbol(null,"end-index-fn","end-index-fn",1237092062,null),new cljs.core.Symbol(null,"meta34336","meta34336",1337269977,null)], null);
});

com.rpl.specter.t_com$rpl$specter34335.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34335.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34335";

com.rpl.specter.t_com$rpl$specter34335.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34335");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34335.
 */
com.rpl.specter.__GT_t_com$rpl$specter34335 = (function com$rpl$specter$__GT_t_com$rpl$specter34335(start_index_fn__$1,end_index_fn__$1,meta34336){
return (new com.rpl.specter.t_com$rpl$specter34335(start_index_fn__$1,end_index_fn__$1,meta34336));
});

}

return (new com.rpl.specter.t_com$rpl$specter34335(start_index_fn,end_index_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select(structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,start,end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn));
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj((function (start,end){
if(typeof com.rpl.specter.t_com$rpl$specter34342 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34342 = (function (start,end,meta34343){
this.start = start;
this.end = end;
this.meta34343 = meta34343;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34342.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34344,meta34343__$1){
var self__ = this;
var _34344__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34342(self__.start,self__.end,meta34343__$1));
});

com.rpl.specter.t_com$rpl$specter34342.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34344){
var self__ = this;
var _34344__$1 = this;
return self__.meta34343;
});

com.rpl.specter.t_com$rpl$specter34342.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34342.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return com.rpl.specter.navs.srange_select(structure,self__.start,self__.end,next_fn);
});

com.rpl.specter.t_com$rpl$specter34342.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,self__.start,self__.end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn));
});

com.rpl.specter.t_com$rpl$specter34342.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta34343","meta34343",556468415,null)], null);
});

com.rpl.specter.t_com$rpl$specter34342.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34342.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34342";

com.rpl.specter.t_com$rpl$specter34342.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34342");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34342.
 */
com.rpl.specter.__GT_t_com$rpl$specter34342 = (function com$rpl$specter$__GT_t_com$rpl$specter34342(start__$1,end__$1,meta34343){
return (new com.rpl.specter.t_com$rpl$specter34342(start__$1,end__$1,meta34343));
});

}

return (new com.rpl.specter.t_com$rpl$specter34342(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__27440__auto__,p__34345){
var vec__34346 = p__34345;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34346,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34346,(1),null);
var ret__27441__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__27441__auto__ === com.rpl.specter.NONE)){
return curr__27440__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__27441__auto__)){
return cljs.core.reduced(ret__27441__auto__);
} else {
return ret__27441__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj((function (pred){
if(typeof com.rpl.specter.t_com$rpl$specter34349 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34349 = (function (pred,meta34350){
this.pred = pred;
this.meta34350 = meta34350;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34349.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34351,meta34350__$1){
var self__ = this;
var _34351__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34349(self__.pred,meta34350__$1));
});

com.rpl.specter.t_com$rpl$specter34349.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34351){
var self__ = this;
var _34351__$1 = this;
return self__.meta34350;
});

com.rpl.specter.t_com$rpl$specter34349.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34349.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (next_fn,this__32516__auto____$1){
return (function (curr__27440__auto__,p__34352){
var vec__34353 = p__34352;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34353,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34353,(1),null);
var ret__27441__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__27441__auto__ === com.rpl.specter.NONE)){
return curr__27440__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__27441__auto__)){
return cljs.core.reduced(ret__27441__auto__);
} else {
return ret__27441__auto__;
}
}
});})(next_fn,this__32516__auto____$1))
,com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,self__.pred));
});

com.rpl.specter.t_com$rpl$specter34349.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(self__.pred,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter34349.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta34350","meta34350",2006494115,null)], null);
});

com.rpl.specter.t_com$rpl$specter34349.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34349.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34349";

com.rpl.specter.t_com$rpl$specter34349.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34349");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34349.
 */
com.rpl.specter.__GT_t_com$rpl$specter34349 = (function com$rpl$specter$__GT_t_com$rpl$specter34349(pred__$1,meta34350){
return (new com.rpl.specter.t_com$rpl$specter34349(pred__$1,meta34350));
});

}

return (new com.rpl.specter.t_com$rpl$specter34349(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
var G__34356 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34356) : next_fn.call(null,G__34356));
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,""))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure)].join('');
} else {
var to_prepend = (function (){var G__34357 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34357) : next_fn.call(null,G__34357));
})();
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34358 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34358 = (function (meta34359){
this.meta34359 = meta34359;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34358.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34360,meta34359__$1){
var self__ = this;
var _34360__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34358(meta34359__$1));
});

com.rpl.specter.t_com$rpl$specter34358.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34360){
var self__ = this;
var _34360__$1 = this;
return self__.meta34359;
});

com.rpl.specter.t_com$rpl$specter34358.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34358.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});

com.rpl.specter.t_com$rpl$specter34358.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn("")),cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure)].join('');
} else {
var to_prepend = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
});

com.rpl.specter.t_com$rpl$specter34358.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34359","meta34359",932037391,null)], null);
});

com.rpl.specter.t_com$rpl$specter34358.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34358.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34358";

com.rpl.specter.t_com$rpl$specter34358.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34358");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34358.
 */
com.rpl.specter.__GT_t_com$rpl$specter34358 = (function com$rpl$specter$__GT_t_com$rpl$specter34358(meta34359){
return (new com.rpl.specter.t_com$rpl$specter34358(meta34359));
});

}

return (new com.rpl.specter.t_com$rpl$specter34358(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
var G__34361 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34361) : next_fn.call(null,G__34361));
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure),cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,"")))].join('');
} else {
var to_append = (function (){var G__34362 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34362) : next_fn.call(null,G__34362));
})();
return com.rpl.specter.navs.append_all(structure,to_append);
}
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34363 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34363 = (function (meta34364){
this.meta34364 = meta34364;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34363.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34365,meta34364__$1){
var self__ = this;
var _34365__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34363(meta34364__$1));
});

com.rpl.specter.t_com$rpl$specter34363.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34365){
var self__ = this;
var _34365__$1 = this;
return self__.meta34364;
});

com.rpl.specter.t_com$rpl$specter34363.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34363.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});

com.rpl.specter.t_com$rpl$specter34363.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure),cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn(""))].join('');
} else {
var to_append = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all(structure,to_append);
}
});

com.rpl.specter.t_com$rpl$specter34363.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34364","meta34364",-1133676538,null)], null);
});

com.rpl.specter.t_com$rpl$specter34363.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34363.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34363";

com.rpl.specter.t_com$rpl$specter34363.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34363");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34363.
 */
com.rpl.specter.__GT_t_com$rpl$specter34363 = (function com$rpl$specter$__GT_t_com$rpl$specter34363(meta34364){
return (new com.rpl.specter.t_com$rpl$specter34363(meta34364));
});

}

return (new com.rpl.specter.t_com$rpl$specter34363(null));
})()
;


com.rpl.specter.NONE_ELEM_select_STAR_ = (function com$rpl$specter$NONE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.NONE_ELEM_transform_STAR_ = (function com$rpl$specter$NONE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
});

/**
 * Navigate to 'void' elem in the set.
 *        For transformations - if result is not `NONE`,
 *        then add that value to the set.
 */
com.rpl.specter.NONE_ELEM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34366 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34366 = (function (meta34367){
this.meta34367 = meta34367;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34366.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34368,meta34367__$1){
var self__ = this;
var _34368__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34366(meta34367__$1));
});

com.rpl.specter.t_com$rpl$specter34366.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34368){
var self__ = this;
var _34368__$1 = this;
return self__.meta34367;
});

com.rpl.specter.t_com$rpl$specter34366.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34366.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn(com.rpl.specter.NONE);
});

com.rpl.specter.t_com$rpl$specter34366.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
});

com.rpl.specter.t_com$rpl$specter34366.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34367","meta34367",-1081748435,null)], null);
});

com.rpl.specter.t_com$rpl$specter34366.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34366.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34366";

com.rpl.specter.t_com$rpl$specter34366.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34366");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34366.
 */
com.rpl.specter.__GT_t_com$rpl$specter34366 = (function com$rpl$specter$__GT_t_com$rpl$specter34366(meta34367){
return (new com.rpl.specter.t_com$rpl$specter34366(meta34367));
});

}

return (new com.rpl.specter.t_com$rpl$specter34366(null));
})()
;


com.rpl.specter.BEFORE_ELEM_select_STAR_ = (function com$rpl$specter$BEFORE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.BEFORE_ELEM_transform_STAR_ = (function com$rpl$specter$BEFORE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
});

/**
 * Navigate to 'void' element before the sequence.
 *        For transformations – if result is not `NONE`,
 *        then prepend that value.
 */
com.rpl.specter.BEFORE_ELEM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34369 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34369 = (function (meta34370){
this.meta34370 = meta34370;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34369.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34371,meta34370__$1){
var self__ = this;
var _34371__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34369(meta34370__$1));
});

com.rpl.specter.t_com$rpl$specter34369.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34371){
var self__ = this;
var _34371__$1 = this;
return self__.meta34370;
});

com.rpl.specter.t_com$rpl$specter34369.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34369.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn(com.rpl.specter.NONE);
});

com.rpl.specter.t_com$rpl$specter34369.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
});

com.rpl.specter.t_com$rpl$specter34369.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34370","meta34370",-1290158819,null)], null);
});

com.rpl.specter.t_com$rpl$specter34369.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34369.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34369";

com.rpl.specter.t_com$rpl$specter34369.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34369");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34369.
 */
com.rpl.specter.__GT_t_com$rpl$specter34369 = (function com$rpl$specter$__GT_t_com$rpl$specter34369(meta34370){
return (new com.rpl.specter.t_com$rpl$specter34369(meta34370));
});

}

return (new com.rpl.specter.t_com$rpl$specter34369(null));
})()
;


com.rpl.specter.AFTER_ELEM_select_STAR_ = (function com$rpl$specter$AFTER_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.AFTER_ELEM_transform_STAR_ = (function com$rpl$specter$AFTER_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
});

/**
 * Navigate to 'void' element after the sequence.
 *        For transformations – if result is not `NONE`,
 *        then append that value.
 */
com.rpl.specter.AFTER_ELEM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34372 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34372 = (function (meta34373){
this.meta34373 = meta34373;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34372.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34374,meta34373__$1){
var self__ = this;
var _34374__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34372(meta34373__$1));
});

com.rpl.specter.t_com$rpl$specter34372.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34374){
var self__ = this;
var _34374__$1 = this;
return self__.meta34373;
});

com.rpl.specter.t_com$rpl$specter34372.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34372.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn(com.rpl.specter.NONE);
});

com.rpl.specter.t_com$rpl$specter34372.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
});

com.rpl.specter.t_com$rpl$specter34372.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34373","meta34373",861424046,null)], null);
});

com.rpl.specter.t_com$rpl$specter34372.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34372.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34372";

com.rpl.specter.t_com$rpl$specter34372.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34372");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34372.
 */
com.rpl.specter.__GT_t_com$rpl$specter34372 = (function com$rpl$specter$__GT_t_com$rpl$specter34372(meta34373){
return (new com.rpl.specter.t_com$rpl$specter34372(meta34373));
});

}

return (new com.rpl.specter.t_com$rpl$specter34372(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
var G__34375 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34375) : next_fn.call(null,G__34375));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
var newset = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(subset) : next_fn.call(null,subset));
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj((function (aset){
if(typeof com.rpl.specter.t_com$rpl$specter34376 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34376 = (function (aset,meta34377){
this.aset = aset;
this.meta34377 = meta34377;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34376.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34378,meta34377__$1){
var self__ = this;
var _34378__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34376(self__.aset,meta34377__$1));
});

com.rpl.specter.t_com$rpl$specter34376.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34378){
var self__ = this;
var _34378__$1 = this;
return self__.meta34377;
});

com.rpl.specter.t_com$rpl$specter34376.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34376.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset));
});

com.rpl.specter.t_com$rpl$specter34376.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset);
var newset = next_fn(subset);
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
});

com.rpl.specter.t_com$rpl$specter34376.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta34377","meta34377",1600179449,null)], null);
});

com.rpl.specter.t_com$rpl$specter34376.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34376.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34376";

com.rpl.specter.t_com$rpl$specter34376.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34376");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34376.
 */
com.rpl.specter.__GT_t_com$rpl$specter34376 = (function com$rpl$specter$__GT_t_com$rpl$specter34376(aset__$1,meta34377){
return (new com.rpl.specter.t_com$rpl$specter34376(aset__$1,meta34377));
});

}

return (new com.rpl.specter.t_com$rpl$specter34376(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
var G__34379 = cljs.core.select_keys(structure,m_keys);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34379) : next_fn.call(null,G__34379));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys(structure,m_keys);
var newmap = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(submap) : next_fn.call(null,submap));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,m_keys),newmap], 0));
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj((function (m_keys){
if(typeof com.rpl.specter.t_com$rpl$specter34380 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34380 = (function (m_keys,meta34381){
this.m_keys = m_keys;
this.meta34381 = meta34381;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34380.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34382,meta34381__$1){
var self__ = this;
var _34382__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34380(self__.m_keys,meta34381__$1));
});

com.rpl.specter.t_com$rpl$specter34380.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34382){
var self__ = this;
var _34382__$1 = this;
return self__.meta34381;
});

com.rpl.specter.t_com$rpl$specter34380.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34380.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn(cljs.core.select_keys(structure,self__.m_keys));
});

com.rpl.specter.t_com$rpl$specter34380.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
var submap = cljs.core.select_keys(structure,self__.m_keys);
var newmap = next_fn(submap);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,self__.m_keys),newmap], 0));
});

com.rpl.specter.t_com$rpl$specter34380.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta34381","meta34381",-366255863,null)], null);
});

com.rpl.specter.t_com$rpl$specter34380.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34380.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34380";

com.rpl.specter.t_com$rpl$specter34380.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34380");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34380.
 */
com.rpl.specter.__GT_t_com$rpl$specter34380 = (function com$rpl$specter$__GT_t_com$rpl$specter34380(m_keys__$1,meta34381){
return (new com.rpl.specter.t_com$rpl$specter34380(m_keys__$1,meta34381));
});

}

return (new com.rpl.specter.t_com$rpl$specter34380(m_keys,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 * 
 *   If transformed sequence is smaller than input sequence, missing entries
 *   will be filled in with NONE, triggering removal if supported by that navigator.
 * 
 *   Value collection (e.g. collect, collect-one) may not be used in the subpath.
 */
com.rpl.specter.subselect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34389__delegate = function (path){
var builder__33126__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if(typeof com.rpl.specter.t_com$rpl$specter34383 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34383 = (function (path,late,meta34384){
this.path = path;
this.late = late;
this.meta34384 = meta34384;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34383.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34385,meta34384__$1){
var self__ = this;
var _34385__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34383(self__.path,self__.late,meta34384__$1));
});

com.rpl.specter.t_com$rpl$specter34383.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34385){
var self__ = this;
var _34385__$1 = this;
return self__.meta34384;
});

com.rpl.specter.t_com$rpl$specter34383.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34383.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn((com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
});

com.rpl.specter.t_com$rpl$specter34383.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
var select_result = (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure));
var transformed = next_fn(select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(transformed));
var G__34386 = self__.late;
var G__34387 = ((function (G__34386,select_result,transformed,values_to_insert,next_fn,this__32516__auto____$1){
return (function (_){
var vs = com.rpl.specter.impl.get_cell(values_to_insert);
if(cljs.core.truth_(vs)){
com.rpl.specter.impl.update_cell_BANG_(values_to_insert,cljs.core.next);

return cljs.core.first(vs);
} else {
return com.rpl.specter.NONE;
}
});})(G__34386,select_result,transformed,values_to_insert,next_fn,this__32516__auto____$1))
;
var G__34388 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__34386,G__34387,G__34388) : com.rpl.specter.compiled_transform.call(null,G__34386,G__34387,G__34388));
});

com.rpl.specter.t_com$rpl$specter34383.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34384","meta34384",-792055775,null)], null);
});

com.rpl.specter.t_com$rpl$specter34383.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34383.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34383";

com.rpl.specter.t_com$rpl$specter34383.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34383");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34383.
 */
com.rpl.specter.__GT_t_com$rpl$specter34383 = (function com$rpl$specter$__GT_t_com$rpl$specter34383(path__$1,late__$1,meta34384){
return (new com.rpl.specter.t_com$rpl$specter34383(path__$1,late__$1,meta34384));
});

}

return (new com.rpl.specter.t_com$rpl$specter34383(path,late,null));
}));
var curr_params__33127__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33127__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33126__auto__,curr_params__33127__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33126__auto__,curr_params__33127__auto__,null);
}
};
var G__34389 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34390__i = 0, G__34390__a = new Array(arguments.length -  0);
while (G__34390__i < G__34390__a.length) {G__34390__a[G__34390__i] = arguments[G__34390__i + 0]; ++G__34390__i;}
  path = new cljs.core.IndexedSeq(G__34390__a,0,null);
} 
return G__34389__delegate.call(this,path);};
G__34389.cljs$lang$maxFixedArity = 0;
G__34389.cljs$lang$applyTo = (function (arglist__34391){
var path = cljs.core.seq(arglist__34391);
return G__34389__delegate(path);
});
G__34389.cljs$core$IFn$_invoke$arity$variadic = G__34389__delegate;
return G__34389;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the given key in the map (not to the value). Navigates only if the
 *        key currently exists in the map. Can transform to NONE to remove the key/value
 *        pair from the map.
 */
com.rpl.specter.map_key = com.rpl.specter.impl.direct_nav_obj((function (key){
if(typeof com.rpl.specter.t_com$rpl$specter34392 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34392 = (function (key,meta34393){
this.key = key;
this.meta34393 = meta34393;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34392.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34394,meta34393__$1){
var self__ = this;
var _34394__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34392(self__.key,meta34393__$1));
});

com.rpl.specter.t_com$rpl$specter34392.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34394){
var self__ = this;
var _34394__$1 = this;
return self__.meta34393;
});

com.rpl.specter.t_com$rpl$specter34392.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34392.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
} else {
return com.rpl.specter.NONE;
}
});

com.rpl.specter.t_com$rpl$specter34392.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
var newkey = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
var dissoced = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(structure,self__.key);
if((com.rpl.specter.NONE === newkey)){
return dissoced;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(dissoced,newkey,cljs.core.get.cljs$core$IFn$_invoke$arity$2(structure,self__.key));
}
} else {
return structure;
}
});

com.rpl.specter.t_com$rpl$specter34392.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta34393","meta34393",2019103793,null)], null);
});

com.rpl.specter.t_com$rpl$specter34392.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34392.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34392";

com.rpl.specter.t_com$rpl$specter34392.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34392");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34392.
 */
com.rpl.specter.__GT_t_com$rpl$specter34392 = (function com$rpl$specter$__GT_t_com$rpl$specter34392(key__$1,meta34393){
return (new com.rpl.specter.t_com$rpl$specter34392(key__$1,meta34393));
});

}

return (new com.rpl.specter.t_com$rpl$specter34392(key,null));
}));
/**
 * Navigates to the given element in the set only if it exists in the set.
 *        Can transform to NONE to remove the element from the set.
 */
com.rpl.specter.set_elem = com.rpl.specter.impl.direct_nav_obj((function (elem){
if(typeof com.rpl.specter.t_com$rpl$specter34395 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34395 = (function (elem,meta34396){
this.elem = elem;
this.meta34396 = meta34396;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34395.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34397,meta34396__$1){
var self__ = this;
var _34397__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34395(self__.elem,meta34396__$1));
});

com.rpl.specter.t_com$rpl$specter34395.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34397){
var self__ = this;
var _34397__$1 = this;
return self__.meta34396;
});

com.rpl.specter.t_com$rpl$specter34395.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34395.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
} else {
return com.rpl.specter.NONE;
}
});

com.rpl.specter.t_com$rpl$specter34395.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
var newelem = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
var removed = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(structure,self__.elem);
if((com.rpl.specter.NONE === newelem)){
return removed;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(removed,newelem);
}
} else {
return structure;
}
});

com.rpl.specter.t_com$rpl$specter34395.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"elem","elem",-2035804713,null),new cljs.core.Symbol(null,"meta34396","meta34396",-1293751021,null)], null);
});

com.rpl.specter.t_com$rpl$specter34395.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34395.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34395";

com.rpl.specter.t_com$rpl$specter34395.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34395");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34395.
 */
com.rpl.specter.__GT_t_com$rpl$specter34395 = (function com$rpl$specter$__GT_t_com$rpl$specter34395(elem__$1,meta34396){
return (new com.rpl.specter.t_com$rpl$specter34395(elem__$1,meta34396));
});

}

return (new com.rpl.specter.t_com$rpl$specter34395(elem,null));
}));
/**
 * Navigate to the specified keys one after another. If navigate to NONE,
 *           that element is removed from the map or vector.
 */
com.rpl.specter.keypath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.keypath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_));
/**
 * Navigate to the specified keys one after another, only if they exist
 *           in the data structure. If navigate to NONE, that element is removed
 *           from the map or vector.
 */
com.rpl.specter.must = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.must_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_));
/**
 * Navigate to the specified indices one after another. If navigate to
 *          NONE, that element is removed from the sequence.
 */
com.rpl.specter.nthpath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.nthpath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.nthpath_STAR_));
/**
 * Navigates to the empty space between the index and the prior index. For select
 *        navigates to NONE, and transforms to non-NONE insert at that position.
 */
com.rpl.specter.before_index = com.rpl.specter.impl.direct_nav_obj((function (index){
if(typeof com.rpl.specter.t_com$rpl$specter34398 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34398 = (function (index,meta34399){
this.index = index;
this.meta34399 = meta34399;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34398.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34400,meta34399__$1){
var self__ = this;
var _34400__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34398(self__.index,meta34399__$1));
});

com.rpl.specter.t_com$rpl$specter34398.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34400){
var self__ = this;
var _34400__$1 = this;
return self__.meta34399;
});

com.rpl.specter.t_com$rpl$specter34398.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34398.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
});

com.rpl.specter.t_com$rpl$specter34398.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var v = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,com.rpl.specter.NONE) : next_fn.call(null,vals,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === v)){
return structure;
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33133__auto__ = com.rpl.specter.pathcache34401;
var info__33133__auto____$1 = (((info__33133__auto__ == null))?(function (){var info34402 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.srange,new cljs.core.Var(function(){return com.rpl.specter.srange;},new cljs.core.Symbol("com.rpl.specter","srange","com.rpl.specter/srange",-978851939,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"srange","srange",-1324254972,null),"com/rpl/specter.cljc",9,1,751,754,cljs.core.List.EMPTY,"Navigates to the subsequence bound by the indexes start (inclusive)\n          and end (exclusive)",(cljs.core.truth_(com.rpl.specter.srange)?com.rpl.specter.srange.cljs$lang$test:null)])),new cljs.core.Symbol(null,"srange","srange",-1324254972,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null)),com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null))], null),cljs.core.list(new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null));
com.rpl.specter.pathcache34401 = info34402;

return info34402;
})():info__33133__auto__);
var precompiled34403 = com.rpl.specter.impl.cached_path_info_precompiled(info__33133__auto____$1);
var dynamic_QMARK___33134__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33133__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33134__auto__)){
var G__34404 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.srange,self__.index,self__.index], null);
return (precompiled34403.cljs$core$IFn$_invoke$arity$1 ? precompiled34403.cljs$core$IFn$_invoke$arity$1(G__34404) : precompiled34403.call(null,G__34404));
} else {
return precompiled34403;
}
})(),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null),structure);
}
});

com.rpl.specter.t_com$rpl$specter34398.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"meta34399","meta34399",1461861997,null)], null);
});

com.rpl.specter.t_com$rpl$specter34398.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34398.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34398";

com.rpl.specter.t_com$rpl$specter34398.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34398");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34398.
 */
com.rpl.specter.__GT_t_com$rpl$specter34398 = (function com$rpl$specter$__GT_t_com$rpl$specter34398(index__$1,meta34399){
return (new com.rpl.specter.t_com$rpl$specter34398(index__$1,meta34399));
});

}

return (new com.rpl.specter.t_com$rpl$specter34398(index,null));
}));
/**
 * Navigates to the index of the sequence if within 0 and size. Transforms move element
 *        at that index to the new index, shifting other elements in the sequence.
 */
com.rpl.specter.index_nav = com.rpl.specter.impl.direct_nav_obj((function (i){
if(typeof com.rpl.specter.t_com$rpl$specter34405 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34405 = (function (i,meta34406){
this.i = i;
this.meta34406 = meta34406;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34405.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34407,meta34406__$1){
var self__ = this;
var _34407__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34405(self__.i,meta34406__$1));
});

com.rpl.specter.t_com$rpl$specter34405.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34407){
var self__ = this;
var _34407__$1 = this;
return self__.meta34406;
});

com.rpl.specter.t_com$rpl$specter34405.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34405.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
} else {
return com.rpl.specter.NONE;
}
});

com.rpl.specter.t_com$rpl$specter34405.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
var newi = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(newi,self__.i)){
return structure;
} else {
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(structure,self__.i);
if(cljs.core.vector_QMARK_(structure)){
var shifted = (((newi < self__.i))?(function (){var j = (self__.i - (1));
var s = structure;
while(true){
if((j < newi)){
return s;
} else {
var G__34416 = (j - (1));
var G__34417 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j + (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__34416;
s = G__34417;
continue;
}
break;
}
})():(function (){var j = (self__.i + (1));
var s = structure;
while(true){
if((j > newi)){
return s;
} else {
var G__34418 = (j + (1));
var G__34419 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j - (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__34418;
s = G__34419;
continue;
}
break;
}
})());
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(shifted,newi,v);
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33133__auto__ = com.rpl.specter.pathcache34408;
var info__33133__auto____$1 = (((info__33133__auto__ == null))?(function (){var info34409 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.before_index,new cljs.core.Var(function(){return com.rpl.specter.before_index;},new cljs.core.Symbol("com.rpl.specter","before-index","com.rpl.specter/before-index",1952616274,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),"com/rpl/specter.cljc",15,1,964,967,cljs.core.List.EMPTY,"Navigates to the empty space between the index and the prior index. For select\n          navigates to NONE, and transforms to non-NONE insert at that position.",(cljs.core.truth_(com.rpl.specter.before_index)?com.rpl.specter.before_index.cljs$lang$test:null)])),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(newi,new cljs.core.Symbol(null,"newi","newi",857919881,null))], null),cljs.core.list(new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null));
com.rpl.specter.pathcache34408 = info34409;

return info34409;
})():info__33133__auto__);
var precompiled34410 = com.rpl.specter.impl.cached_path_info_precompiled(info__33133__auto____$1);
var dynamic_QMARK___33134__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33133__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33134__auto__)){
var G__34411 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.before_index,newi], null);
return (precompiled34410.cljs$core$IFn$_invoke$arity$1 ? precompiled34410.cljs$core$IFn$_invoke$arity$1(G__34411) : precompiled34410.call(null,G__34411));
} else {
return precompiled34410;
}
})(),v,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33133__auto__ = com.rpl.specter.pathcache34412;
var info__33133__auto____$1 = (((info__33133__auto__ == null))?(function (){var info34413 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,959,961,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.i,new cljs.core.Symbol(null,"i","i",253690212,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null));
com.rpl.specter.pathcache34412 = info34413;

return info34413;
})():info__33133__auto__);
var precompiled34414 = com.rpl.specter.impl.cached_path_info_precompiled(info__33133__auto____$1);
var dynamic_QMARK___33134__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33133__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33134__auto__)){
var G__34415 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,self__.i], null);
return (precompiled34414.cljs$core$IFn$_invoke$arity$1 ? precompiled34414.cljs$core$IFn$_invoke$arity$1(G__34415) : precompiled34414.call(null,G__34415));
} else {
return precompiled34414;
}
})(),com.rpl.specter.NONE,structure));
}
}
} else {
return structure;
}
});

com.rpl.specter.t_com$rpl$specter34405.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta34406","meta34406",-631664971,null)], null);
});

com.rpl.specter.t_com$rpl$specter34405.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34405.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34405";

com.rpl.specter.t_com$rpl$specter34405.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34405");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34405.
 */
com.rpl.specter.__GT_t_com$rpl$specter34405 = (function com$rpl$specter$__GT_t_com$rpl$specter34405(i__$1,meta34406){
return (new com.rpl.specter.t_com$rpl$specter34405(i__$1,meta34406));
});

}

return (new com.rpl.specter.t_com$rpl$specter34405(i,null));
}));


com.rpl.specter.indexed_vals_select_STAR_ = (function com$rpl$specter$indexed_vals_select_STAR_(start,structure,next_fn){
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i){
return (function (curr__27440__auto__,e){
var ret__27441__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

var G__34422 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34422) : next_fn.call(null,G__34422));
})()
;
if((ret__27441__auto__ === com.rpl.specter.NONE)){
return curr__27440__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__27441__auto__)){
return cljs.core.reduced(ret__27441__auto__);
} else {
return ret__27441__auto__;
}
}
});})(i))
,com.rpl.specter.NONE,structure);
});

com.rpl.specter.indexed_vals_transform_STAR_ = (function com$rpl$specter$indexed_vals_transform_STAR_(start,structure,next_fn){
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (indices){
return (function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__34423 = (function (){var G__34426 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(start + curri),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34426) : next_fn.call(null,G__34426));
})();
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34423,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34423,(1),null);
var newi = (newi_STAR_ - start);
com.rpl.specter.impl.update_cell_BANG_(indices,((function (curri,vec__34423,newi_STAR_,newe,newi,indices){
return (function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__33133__auto__ = com.rpl.specter.pathcache34427;
var info__33133__auto____$1 = (((info__33133__auto__ == null))?(function (){var info34428 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,675,678,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse(((function (info__33133__auto__,ii2,curri,vec__34423,newi_STAR_,newe,newi,indices){
return (function (p1__34420_SHARP_){
return (p1__34420_SHARP_ >= (curri + (1)));
});})(info__33133__auto__,ii2,curri,vec__34423,newi_STAR_,newe,newi,indices))
,cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34420#","p1__34420#",-1911419426,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34420#","p1__34420#",-1911419426,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse(((function (info__33133__auto__,ii2,curri,vec__34423,newi_STAR_,newe,newi,indices){
return (function (p1__34421_SHARP_){
return (p1__34421_SHARP_ <= newi);
});})(info__33133__auto__,ii2,curri,vec__34423,newi_STAR_,newe,newi,indices))
,cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34421#","p1__34421#",-1586803068,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34421#","p1__34421#",-1586803068,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34420#","p1__34420#",-1911419426,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34420#","p1__34420#",-1911419426,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34421#","p1__34421#",-1586803068,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34421#","p1__34421#",-1586803068,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34420#","p1__34420#",-1911419426,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34420#","p1__34420#",-1911419426,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34421#","p1__34421#",-1586803068,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34421#","p1__34421#",-1586803068,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache34427 = info34428;

return info34428;
})():info__33133__auto__);
var precompiled34429 = com.rpl.specter.impl.cached_path_info_precompiled(info__33133__auto____$1);
var dynamic_QMARK___33134__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33133__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33134__auto__)){
var G__34430 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,((function (info__33133__auto__,info__33133__auto____$1,precompiled34429,dynamic_QMARK___33134__auto__,ii2,curri,vec__34423,newi_STAR_,newe,newi,indices){
return (function (p1__34420_SHARP_){
return (p1__34420_SHARP_ >= (curri + (1)));
});})(info__33133__auto__,info__33133__auto____$1,precompiled34429,dynamic_QMARK___33134__auto__,ii2,curri,vec__34423,newi_STAR_,newe,newi,indices))
,((function (info__33133__auto__,info__33133__auto____$1,precompiled34429,dynamic_QMARK___33134__auto__,ii2,curri,vec__34423,newi_STAR_,newe,newi,indices){
return (function (p1__34421_SHARP_){
return (p1__34421_SHARP_ <= newi);
});})(info__33133__auto__,info__33133__auto____$1,precompiled34429,dynamic_QMARK___33134__auto__,ii2,curri,vec__34423,newi_STAR_,newe,newi,indices))
], null),com.rpl.specter.ALL,((function (info__33133__auto__,info__33133__auto____$1,precompiled34429,dynamic_QMARK___33134__auto__,ii2,curri,vec__34423,newi_STAR_,newe,newi,indices){
return (function (p1__34420_SHARP_){
return (p1__34420_SHARP_ >= (curri + (1)));
});})(info__33133__auto__,info__33133__auto____$1,precompiled34429,dynamic_QMARK___33134__auto__,ii2,curri,vec__34423,newi_STAR_,newe,newi,indices))
,((function (info__33133__auto__,info__33133__auto____$1,precompiled34429,dynamic_QMARK___33134__auto__,ii2,curri,vec__34423,newi_STAR_,newe,newi,indices){
return (function (p1__34421_SHARP_){
return (p1__34421_SHARP_ <= newi);
});})(info__33133__auto__,info__33133__auto____$1,precompiled34429,dynamic_QMARK___33134__auto__,ii2,curri,vec__34423,newi_STAR_,newe,newi,indices))
], null);
return (precompiled34429.cljs$core$IFn$_invoke$arity$1 ? precompiled34429.cljs$core$IFn$_invoke$arity$1(G__34430) : precompiled34429.call(null,G__34430));
} else {
return precompiled34429;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
});})(curri,vec__34423,newi_STAR_,newe,newi,indices))
);

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33133__auto__ = com.rpl.specter.pathcache34431;
var info__33133__auto____$1 = (((info__33133__auto__ == null))?(function (){var info34432 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,979,982,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache34431 = info34432;

return info34432;
})():info__33133__auto__);
var precompiled34433 = com.rpl.specter.impl.cached_path_info_precompiled(info__33133__auto____$1);
var dynamic_QMARK___33134__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33133__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33134__auto__)){
var G__34434 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled34433.cljs$core$IFn$_invoke$arity$1 ? precompiled34433.cljs$core$IFn$_invoke$arity$1(G__34434) : precompiled34433.call(null,G__34434));
} else {
return precompiled34433;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33133__auto__ = com.rpl.specter.pathcache34435;
var info__33133__auto____$1 = (((info__33133__auto__ == null))?(function (){var info34436 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,959,961,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache34435 = info34436;

return info34436;
})():info__33133__auto__);
var precompiled34437 = com.rpl.specter.impl.cached_path_info_precompiled(info__33133__auto____$1);
var dynamic_QMARK___33134__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33133__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33134__auto__)){
var G__34438 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled34437.cljs$core$IFn$_invoke$arity$1 ? precompiled34437.cljs$core$IFn$_invoke$arity$1(G__34438) : precompiled34437.call(null,G__34438));
} else {
return precompiled34437;
}
})(),newe,s));
});})(indices))
,structure,structure);
});

/**
 * Navigate to [index elem] pairs for each element in a sequence. The sequence will be indexed
 *        starting from `start`. Changing index in transform has same effect as `index-nav`. Indices seen
 *        during transform take into account any shifting from prior sequence elements changing indices.
 */
com.rpl.specter.indexed_vals = com.rpl.specter.impl.direct_nav_obj((function (start){
if(typeof com.rpl.specter.t_com$rpl$specter34439 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34439 = (function (start,meta34440){
this.start = start;
this.meta34440 = meta34440;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34439.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34441,meta34440__$1){
var self__ = this;
var _34441__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34439(self__.start,meta34440__$1));
});

com.rpl.specter.t_com$rpl$specter34439.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34441){
var self__ = this;
var _34441__$1 = this;
return self__.meta34440;
});

com.rpl.specter.t_com$rpl$specter34439.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34439.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((self__.start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i,next_fn,this__32516__auto____$1){
return (function (curr__27440__auto__,e){
var ret__27441__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

return next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null));
})()
;
if((ret__27441__auto__ === com.rpl.specter.NONE)){
return curr__27440__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__27441__auto__)){
return cljs.core.reduced(ret__27441__auto__);
} else {
return ret__27441__auto__;
}
}
});})(i,next_fn,this__32516__auto____$1))
,com.rpl.specter.NONE,structure);
});

com.rpl.specter.t_com$rpl$specter34439.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (indices,next_fn,this__32516__auto____$1){
return (function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__34442 = next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.start + curri),e], null));
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34442,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34442,(1),null);
var newi = (newi_STAR_ - self__.start);
com.rpl.specter.impl.update_cell_BANG_(indices,((function (curri,vec__34442,newi_STAR_,newe,newi,indices,next_fn,this__32516__auto____$1){
return (function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__33133__auto__ = com.rpl.specter.pathcache34445;
var info__33133__auto____$1 = (((info__33133__auto__ == null))?(function (){var info34446 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,675,678,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse(((function (info__33133__auto__,ii2,curri,vec__34442,newi_STAR_,newe,newi,indices,next_fn,this__32516__auto____$1){
return (function (p1__34420_SHARP_){
return (p1__34420_SHARP_ >= (curri + (1)));
});})(info__33133__auto__,ii2,curri,vec__34442,newi_STAR_,newe,newi,indices,next_fn,this__32516__auto____$1))
,cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34420#","p1__34420#",-1911419426,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34420#","p1__34420#",-1911419426,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse(((function (info__33133__auto__,ii2,curri,vec__34442,newi_STAR_,newe,newi,indices,next_fn,this__32516__auto____$1){
return (function (p1__34421_SHARP_){
return (p1__34421_SHARP_ <= newi);
});})(info__33133__auto__,ii2,curri,vec__34442,newi_STAR_,newe,newi,indices,next_fn,this__32516__auto____$1))
,cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34421#","p1__34421#",-1586803068,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34421#","p1__34421#",-1586803068,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34420#","p1__34420#",-1911419426,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34420#","p1__34420#",-1911419426,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34421#","p1__34421#",-1586803068,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34421#","p1__34421#",-1586803068,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34420#","p1__34420#",-1911419426,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34420#","p1__34420#",-1911419426,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34421#","p1__34421#",-1586803068,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34421#","p1__34421#",-1586803068,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache34445 = info34446;

return info34446;
})():info__33133__auto__);
var precompiled34447 = com.rpl.specter.impl.cached_path_info_precompiled(info__33133__auto____$1);
var dynamic_QMARK___33134__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33133__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33134__auto__)){
var G__34448 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,((function (info__33133__auto__,info__33133__auto____$1,precompiled34447,dynamic_QMARK___33134__auto__,ii2,curri,vec__34442,newi_STAR_,newe,newi,indices,next_fn,this__32516__auto____$1){
return (function (p1__34420_SHARP_){
return (p1__34420_SHARP_ >= (curri + (1)));
});})(info__33133__auto__,info__33133__auto____$1,precompiled34447,dynamic_QMARK___33134__auto__,ii2,curri,vec__34442,newi_STAR_,newe,newi,indices,next_fn,this__32516__auto____$1))
,((function (info__33133__auto__,info__33133__auto____$1,precompiled34447,dynamic_QMARK___33134__auto__,ii2,curri,vec__34442,newi_STAR_,newe,newi,indices,next_fn,this__32516__auto____$1){
return (function (p1__34421_SHARP_){
return (p1__34421_SHARP_ <= newi);
});})(info__33133__auto__,info__33133__auto____$1,precompiled34447,dynamic_QMARK___33134__auto__,ii2,curri,vec__34442,newi_STAR_,newe,newi,indices,next_fn,this__32516__auto____$1))
], null),com.rpl.specter.ALL,((function (info__33133__auto__,info__33133__auto____$1,precompiled34447,dynamic_QMARK___33134__auto__,ii2,curri,vec__34442,newi_STAR_,newe,newi,indices,next_fn,this__32516__auto____$1){
return (function (p1__34420_SHARP_){
return (p1__34420_SHARP_ >= (curri + (1)));
});})(info__33133__auto__,info__33133__auto____$1,precompiled34447,dynamic_QMARK___33134__auto__,ii2,curri,vec__34442,newi_STAR_,newe,newi,indices,next_fn,this__32516__auto____$1))
,((function (info__33133__auto__,info__33133__auto____$1,precompiled34447,dynamic_QMARK___33134__auto__,ii2,curri,vec__34442,newi_STAR_,newe,newi,indices,next_fn,this__32516__auto____$1){
return (function (p1__34421_SHARP_){
return (p1__34421_SHARP_ <= newi);
});})(info__33133__auto__,info__33133__auto____$1,precompiled34447,dynamic_QMARK___33134__auto__,ii2,curri,vec__34442,newi_STAR_,newe,newi,indices,next_fn,this__32516__auto____$1))
], null);
return (precompiled34447.cljs$core$IFn$_invoke$arity$1 ? precompiled34447.cljs$core$IFn$_invoke$arity$1(G__34448) : precompiled34447.call(null,G__34448));
} else {
return precompiled34447;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
});})(curri,vec__34442,newi_STAR_,newe,newi,indices,next_fn,this__32516__auto____$1))
);

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33133__auto__ = com.rpl.specter.pathcache34449;
var info__33133__auto____$1 = (((info__33133__auto__ == null))?(function (){var info34450 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,979,982,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache34449 = info34450;

return info34450;
})():info__33133__auto__);
var precompiled34451 = com.rpl.specter.impl.cached_path_info_precompiled(info__33133__auto____$1);
var dynamic_QMARK___33134__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33133__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33134__auto__)){
var G__34452 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled34451.cljs$core$IFn$_invoke$arity$1 ? precompiled34451.cljs$core$IFn$_invoke$arity$1(G__34452) : precompiled34451.call(null,G__34452));
} else {
return precompiled34451;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33133__auto__ = com.rpl.specter.pathcache34453;
var info__33133__auto____$1 = (((info__33133__auto__ == null))?(function (){var info34454 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,959,961,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache34453 = info34454;

return info34454;
})():info__33133__auto__);
var precompiled34455 = com.rpl.specter.impl.cached_path_info_precompiled(info__33133__auto____$1);
var dynamic_QMARK___33134__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33133__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33134__auto__)){
var G__34456 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled34455.cljs$core$IFn$_invoke$arity$1 ? precompiled34455.cljs$core$IFn$_invoke$arity$1(G__34456) : precompiled34455.call(null,G__34456));
} else {
return precompiled34455;
}
})(),newe,s));
});})(indices,next_fn,this__32516__auto____$1))
,structure,structure);
});

com.rpl.specter.t_com$rpl$specter34439.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"meta34440","meta34440",1272138029,null)], null);
});

com.rpl.specter.t_com$rpl$specter34439.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34439.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34439";

com.rpl.specter.t_com$rpl$specter34439.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34439");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34439.
 */
com.rpl.specter.__GT_t_com$rpl$specter34439 = (function com$rpl$specter$__GT_t_com$rpl$specter34439(start__$1,meta34440){
return (new com.rpl.specter.t_com$rpl$specter34439(start__$1,meta34440));
});

}

return (new com.rpl.specter.t_com$rpl$specter34439(start,null));
}));
/**
 * `indexed-vals` with a starting index of 0.
 */
com.rpl.specter.INDEXED_VALS = (com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1((0)) : com.rpl.specter.indexed_vals.call(null,(0)));
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj((function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter34457 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34457 = (function (afn,meta34458){
this.afn = afn;
this.meta34458 = meta34458;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34457.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34459,meta34458__$1){
var self__ = this;
var _34459__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34457(self__.afn,meta34458__$1));
});

com.rpl.specter.t_com$rpl$specter34457.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34459){
var self__ = this;
var _34459__$1 = this;
return self__.meta34458;
});

com.rpl.specter.t_com$rpl$specter34457.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34457.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__34460 = vals;
var G__34461 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__34460,G__34461) : next_fn.call(null,G__34460,G__34461));
});

com.rpl.specter.t_com$rpl$specter34457.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__34462 = vals;
var G__34463 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__34462,G__34463) : next_fn.call(null,G__34462,G__34463));
});

com.rpl.specter.t_com$rpl$specter34457.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta34458","meta34458",-900467616,null)], null);
});

com.rpl.specter.t_com$rpl$specter34457.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34457.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34457";

com.rpl.specter.t_com$rpl$specter34457.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34457");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34457.
 */
com.rpl.specter.__GT_t_com$rpl$specter34457 = (function com$rpl$specter$__GT_t_com$rpl$specter34457(afn__$1,meta34458){
return (new com.rpl.specter.t_com$rpl$specter34457(afn__$1,meta34458));
});

}

return (new com.rpl.specter.t_com$rpl$specter34457(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__34464 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34464) : next_fn.call(null,G__34464));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__34465 = (function (){var G__34466 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34466) : next_fn.call(null,G__34466));
})();
return (unparse_fn.cljs$core$IFn$_invoke$arity$1 ? unparse_fn.cljs$core$IFn$_invoke$arity$1(G__34465) : unparse_fn.call(null,G__34465));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj((function (parse_fn,unparse_fn){
if(typeof com.rpl.specter.t_com$rpl$specter34467 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34467 = (function (parse_fn,unparse_fn,meta34468){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta34468 = meta34468;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34467.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34469,meta34468__$1){
var self__ = this;
var _34469__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34467(self__.parse_fn,self__.unparse_fn,meta34468__$1));
});

com.rpl.specter.t_com$rpl$specter34467.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34469){
var self__ = this;
var _34469__$1 = this;
return self__.meta34468;
});

com.rpl.specter.t_com$rpl$specter34467.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34467.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter34467.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
var G__34470 = next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
return (self__.unparse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.unparse_fn.cljs$core$IFn$_invoke$arity$1(G__34470) : self__.unparse_fn.call(null,G__34470));
});

com.rpl.specter.t_com$rpl$specter34467.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta34468","meta34468",-1105104770,null)], null);
});

com.rpl.specter.t_com$rpl$specter34467.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34467.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34467";

com.rpl.specter.t_com$rpl$specter34467.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34467");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34467.
 */
com.rpl.specter.__GT_t_com$rpl$specter34467 = (function com$rpl$specter$__GT_t_com$rpl$specter34467(parse_fn__$1,unparse_fn__$1,meta34468){
return (new com.rpl.specter.t_com$rpl$specter34467(parse_fn__$1,unparse_fn__$1,meta34468));
});

}

return (new com.rpl.specter.t_com$rpl$specter34467(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
var G__34471 = cljs.core.deref(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34471) : next_fn.call(null,G__34471));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34472 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34472 = (function (meta34473){
this.meta34473 = meta34473;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34472.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34474,meta34473__$1){
var self__ = this;
var _34474__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34472(meta34473__$1));
});

com.rpl.specter.t_com$rpl$specter34472.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34474){
var self__ = this;
var _34474__$1 = this;
return self__.meta34473;
});

com.rpl.specter.t_com$rpl$specter34472.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34472.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn(cljs.core.deref(structure));
});

com.rpl.specter.t_com$rpl$specter34472.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
});

com.rpl.specter.t_com$rpl$specter34472.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34473","meta34473",1705016380,null)], null);
});

com.rpl.specter.t_com$rpl$specter34472.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34472.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34472";

com.rpl.specter.t_com$rpl$specter34472.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34472");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34472.
 */
com.rpl.specter.__GT_t_com$rpl$specter34472 = (function com$rpl$specter$__GT_t_com$rpl$specter34472(meta34473){
return (new com.rpl.specter.t_com$rpl$specter34472(meta34473));
});

}

return (new com.rpl.specter.t_com$rpl$specter34472(null));
})()
;


com.rpl.specter.regex_nav_select_STAR_ = (function com$rpl$specter$regex_nav_select_STAR_(re,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__27440__auto__,s){
var ret__27441__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(s) : next_fn.call(null,s));
if((ret__27441__auto__ === com.rpl.specter.NONE)){
return curr__27440__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__27441__auto__)){
return cljs.core.reduced(ret__27441__auto__);
} else {
return ret__27441__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(re,structure));
});

com.rpl.specter.regex_nav_transform_STAR_ = (function com$rpl$specter$regex_nav_transform_STAR_(re,structure,next_fn){
return clojure.string.replace(structure,re,next_fn);
});

com.rpl.specter.regex_nav = com.rpl.specter.impl.direct_nav_obj((function (re){
if(typeof com.rpl.specter.t_com$rpl$specter34475 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34475 = (function (re,meta34476){
this.re = re;
this.meta34476 = meta34476;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34475.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34477,meta34476__$1){
var self__ = this;
var _34477__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34475(self__.re,meta34476__$1));
});

com.rpl.specter.t_com$rpl$specter34475.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34477){
var self__ = this;
var _34477__$1 = this;
return self__.meta34476;
});

com.rpl.specter.t_com$rpl$specter34475.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34475.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (next_fn,this__32516__auto____$1){
return (function (curr__27440__auto__,s){
var ret__27441__auto__ = next_fn(s);
if((ret__27441__auto__ === com.rpl.specter.NONE)){
return curr__27440__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__27441__auto__)){
return cljs.core.reduced(ret__27441__auto__);
} else {
return ret__27441__auto__;
}
}
});})(next_fn,this__32516__auto____$1))
,com.rpl.specter.NONE,cljs.core.re_seq(self__.re,structure));
});

com.rpl.specter.t_com$rpl$specter34475.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return clojure.string.replace(structure,self__.re,next_fn);
});

com.rpl.specter.t_com$rpl$specter34475.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"re","re",1869207729,null),new cljs.core.Symbol(null,"meta34476","meta34476",-202959716,null)], null);
});

com.rpl.specter.t_com$rpl$specter34475.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34475.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34475";

com.rpl.specter.t_com$rpl$specter34475.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34475");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34475.
 */
com.rpl.specter.__GT_t_com$rpl$specter34475 = (function com$rpl$specter$__GT_t_com$rpl$specter34475(re__$1,meta34476){
return (new com.rpl.specter.t_com$rpl$specter34475(re__$1,meta34476));
});

}

return (new com.rpl.specter.t_com$rpl$specter34475(re,null));
}));
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34483__delegate = function (path){
var temp__5455__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5455__auto__)){
var afn = temp__5455__auto__;
return afn;
} else {
var builder__33126__auto__ = com.rpl.specter.impl.direct_nav_obj(((function (temp__5455__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter34480 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34480 = (function (path,temp__5455__auto__,late,meta34481){
this.path = path;
this.temp__5455__auto__ = temp__5455__auto__;
this.late = late;
this.meta34481 = meta34481;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34480.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__5455__auto__){
return (function (_34482,meta34481__$1){
var self__ = this;
var _34482__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34480(self__.path,self__.temp__5455__auto__,self__.late,meta34481__$1));
});})(temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34480.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__5455__auto__){
return (function (_34482){
var self__ = this;
var _34482__$1 = this;
return self__.meta34481;
});})(temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34480.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34480.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__5455__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select(((function (this$__$1,temp__5455__auto__){
return (function (p1__34478_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__34478_SHARP_);
});})(this$__$1,temp__5455__auto__))
,vals,structure,next_fn);
});})(temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34480.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__5455__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform(((function (this$__$1,temp__5455__auto__){
return (function (p1__34479_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__34479_SHARP_);
});})(this$__$1,temp__5455__auto__))
,vals,structure,next_fn);
});})(temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34480.getBasis = ((function (temp__5455__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5455__auto__","temp__5455__auto__",980956642,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34481","meta34481",1496348691,null)], null);
});})(temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34480.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34480.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34480";

com.rpl.specter.t_com$rpl$specter34480.cljs$lang$ctorPrWriter = ((function (temp__5455__auto__){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34480");
});})(temp__5455__auto__))
;

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34480.
 */
com.rpl.specter.__GT_t_com$rpl$specter34480 = ((function (temp__5455__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter34480(path__$1,temp__5455__auto____$1,late__$1,meta34481){
return (new com.rpl.specter.t_com$rpl$specter34480(path__$1,temp__5455__auto____$1,late__$1,meta34481));
});})(temp__5455__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter34480(path,temp__5455__auto__,late,null));
});})(temp__5455__auto__))
);
var curr_params__33127__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33127__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33126__auto__,curr_params__33127__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33126__auto__,curr_params__33127__auto__,null);
}
}
};
var G__34483 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34484__i = 0, G__34484__a = new Array(arguments.length -  0);
while (G__34484__i < G__34484__a.length) {G__34484__a[G__34484__i] = arguments[G__34484__i + 0]; ++G__34484__i;}
  path = new cljs.core.IndexedSeq(G__34484__a,0,null);
} 
return G__34483__delegate.call(this,path);};
G__34483.cljs$lang$maxFixedArity = 0;
G__34483.cljs$lang$applyTo = (function (arglist__34485){
var path = cljs.core.seq(arglist__34485);
return G__34483__delegate(path);
});
G__34483.cljs$core$IFn$_invoke$arity$variadic = G__34483__delegate;
return G__34483;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34491__delegate = function (path){
var temp__5455__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5455__auto__)){
var afn = temp__5455__auto__;
return ((function (afn,temp__5455__auto__){
return (function (s){
return cljs.core.not((afn.cljs$core$IFn$_invoke$arity$1 ? afn.cljs$core$IFn$_invoke$arity$1(s) : afn.call(null,s)));
});
;})(afn,temp__5455__auto__))
} else {
var builder__33126__auto__ = com.rpl.specter.impl.direct_nav_obj(((function (temp__5455__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter34488 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34488 = (function (path,temp__5455__auto__,late,meta34489){
this.path = path;
this.temp__5455__auto__ = temp__5455__auto__;
this.late = late;
this.meta34489 = meta34489;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34488.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__5455__auto__){
return (function (_34490,meta34489__$1){
var self__ = this;
var _34490__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34488(self__.path,self__.temp__5455__auto__,self__.late,meta34489__$1));
});})(temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34488.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__5455__auto__){
return (function (_34490){
var self__ = this;
var _34490__$1 = this;
return self__.meta34489;
});})(temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34488.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34488.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__5455__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select(((function (this$__$1,temp__5455__auto__){
return (function (p1__34486_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__34486_SHARP_);
});})(this$__$1,temp__5455__auto__))
,vals,structure,next_fn);
});})(temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34488.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__5455__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform(((function (this$__$1,temp__5455__auto__){
return (function (p1__34487_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__34487_SHARP_);
});})(this$__$1,temp__5455__auto__))
,vals,structure,next_fn);
});})(temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34488.getBasis = ((function (temp__5455__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5455__auto__","temp__5455__auto__",980956642,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34489","meta34489",561498808,null)], null);
});})(temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34488.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34488.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34488";

com.rpl.specter.t_com$rpl$specter34488.cljs$lang$ctorPrWriter = ((function (temp__5455__auto__){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34488");
});})(temp__5455__auto__))
;

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34488.
 */
com.rpl.specter.__GT_t_com$rpl$specter34488 = ((function (temp__5455__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter34488(path__$1,temp__5455__auto____$1,late__$1,meta34489){
return (new com.rpl.specter.t_com$rpl$specter34488(path__$1,temp__5455__auto____$1,late__$1,meta34489));
});})(temp__5455__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter34488(path,temp__5455__auto__,late,null));
});})(temp__5455__auto__))
);
var curr_params__33127__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33127__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33126__auto__,curr_params__33127__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33126__auto__,curr_params__33127__auto__,null);
}
}
};
var G__34491 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34492__i = 0, G__34492__a = new Array(arguments.length -  0);
while (G__34492__i < G__34492__a.length) {G__34492__a[G__34492__i] = arguments[G__34492__i + 0]; ++G__34492__i;}
  path = new cljs.core.IndexedSeq(G__34492__a,0,null);
} 
return G__34491__delegate.call(this,path);};
G__34491.cljs$lang$maxFixedArity = 0;
G__34491.cljs$lang$applyTo = (function (arglist__34493){
var path = cljs.core.seq(arglist__34493);
return G__34491__delegate(path);
});
G__34491.cljs$core$IFn$_invoke$arity$variadic = G__34491__delegate;
return G__34491;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 * 
 *   For transformation: `NONE` entries in the result sequence cause corresponding entries in
 *   input to be removed. A result sequence smaller than the input sequence is equivalent to
 *   padding the result sequence with `NONE` at the end until the same size as the input.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34496__delegate = function (path){
var G__34494 = com.rpl.specter.ALL;
var G__34495 = (com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.selected_QMARK_.call(null,path));
return (com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2(G__34494,G__34495) : com.rpl.specter.subselect.call(null,G__34494,G__34495));
};
var G__34496 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34497__i = 0, G__34497__a = new Array(arguments.length -  0);
while (G__34497__i < G__34497__a.length) {G__34497__a[G__34497__i] = arguments[G__34497__i + 0]; ++G__34497__i;}
  path = new cljs.core.IndexedSeq(G__34497__a,0,null);
} 
return G__34496__delegate.call(this,path);};
G__34496.cljs$lang$maxFixedArity = 0;
G__34496.cljs$lang$applyTo = (function (arglist__34498){
var path = cljs.core.seq(arglist__34498);
return G__34496__delegate(path);
});
G__34496.cljs$core$IFn$_invoke$arity$variadic = G__34496__delegate;
return G__34496;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,update_fn){
var builder__33126__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter34499 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34499 = (function (path,update_fn,late,late_fn,meta34500){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta34500 = meta34500;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34499.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34501,meta34500__$1){
var self__ = this;
var _34501__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34499(self__.path,self__.update_fn,self__.late,self__.late_fn,meta34500__$1));
});

com.rpl.specter.t_com$rpl$specter34499.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34501){
var self__ = this;
var _34501__$1 = this;
return self__.meta34500;
});

com.rpl.specter.t_com$rpl$specter34499.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34499.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
});

com.rpl.specter.t_com$rpl$specter34499.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
});

com.rpl.specter.t_com$rpl$specter34499.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta34500","meta34500",627910391,null)], null);
});

com.rpl.specter.t_com$rpl$specter34499.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34499.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34499";

com.rpl.specter.t_com$rpl$specter34499.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34499");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34499.
 */
com.rpl.specter.__GT_t_com$rpl$specter34499 = (function com$rpl$specter$__GT_t_com$rpl$specter34499(path__$1,update_fn__$1,late__$1,late_fn__$1,meta34500){
return (new com.rpl.specter.t_com$rpl$specter34499(path__$1,update_fn__$1,late__$1,late_fn__$1,meta34500));
});

}

return (new com.rpl.specter.t_com$rpl$specter34499(path,update_fn,late,late_fn,null));
}));
var curr_params__33127__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),update_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33127__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33126__auto__,curr_params__33127__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33126__auto__,curr_params__33127__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,reduce_fn){
var builder__33126__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter34502 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34502 = (function (path,reduce_fn,late,late_fn,meta34503){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta34503 = meta34503;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34502.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34504,meta34503__$1){
var self__ = this;
var _34504__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34502(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta34503__$1));
});

com.rpl.specter.t_com$rpl$specter34502.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34504){
var self__ = this;
var _34504__$1 = this;
return self__.meta34503;
});

com.rpl.specter.t_com$rpl$specter34502.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34502.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
});

com.rpl.specter.t_com$rpl$specter34502.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
});

com.rpl.specter.t_com$rpl$specter34502.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta34503","meta34503",1939818380,null)], null);
});

com.rpl.specter.t_com$rpl$specter34502.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34502.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34502";

com.rpl.specter.t_com$rpl$specter34502.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34502");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34502.
 */
com.rpl.specter.__GT_t_com$rpl$specter34502 = (function com$rpl$specter$__GT_t_com$rpl$specter34502(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta34503){
return (new com.rpl.specter.t_com$rpl$specter34502(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta34503));
});

}

return (new com.rpl.specter.t_com$rpl$specter34502(path,reduce_fn,late,late_fn,null));
}));
var curr_params__33127__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),reduce_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33127__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33126__auto__,curr_params__33127__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33126__auto__,curr_params__33127__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. Functions in paths
 *        implicitly convert to this navigator.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
com.rpl.specter.pred_EQ_ = (function com$rpl$specter$pred_EQ_(v){
var G__34506 = (function (p1__34505_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__34505_SHARP_,v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__34506) : com.rpl.specter.pred.call(null,G__34506));
});
com.rpl.specter.pred_LT_ = (function com$rpl$specter$pred_LT_(v){
var G__34508 = (function (p1__34507_SHARP_){
return (p1__34507_SHARP_ < v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__34508) : com.rpl.specter.pred.call(null,G__34508));
});
com.rpl.specter.pred_GT_ = (function com$rpl$specter$pred_GT_(v){
var G__34510 = (function (p1__34509_SHARP_){
return (p1__34509_SHARP_ > v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__34510) : com.rpl.specter.pred.call(null,G__34510));
});
com.rpl.specter.pred_LT__EQ_ = (function com$rpl$specter$pred_LT__EQ_(v){
var G__34512 = (function (p1__34511_SHARP_){
return (p1__34511_SHARP_ <= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__34512) : com.rpl.specter.pred.call(null,G__34512));
});
com.rpl.specter.pred_GT__EQ_ = (function com$rpl$specter$pred_GT__EQ_(v){
var G__34514 = (function (p1__34513_SHARP_){
return (p1__34513_SHARP_ >= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__34514) : com.rpl.specter.pred.call(null,G__34514));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"null",true);

var G__34515_34518 = com.rpl.specter.protocols.implicit_nav;
var G__34516_34519 = "null";
var G__34517_34520 = ((function (G__34515_34518,G__34516_34519){
return (function (this$){
return com.rpl.specter.STAY;
});})(G__34515_34518,G__34516_34519))
;
goog.object.set(G__34515_34518,G__34516_34519,G__34517_34520);
cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
});
cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"string",true);

var G__34521_34524 = com.rpl.specter.protocols.implicit_nav;
var G__34522_34525 = "string";
var G__34523_34526 = ((function (G__34521_34524,G__34522_34525){
return (function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
});})(G__34521_34524,G__34522_34525))
;
goog.object.set(G__34521_34524,G__34522_34525,G__34523_34526);
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"number",true);

var G__34527_34530 = com.rpl.specter.protocols.implicit_nav;
var G__34528_34531 = "number";
var G__34529_34532 = ((function (G__34527_34530,G__34528_34531){
return (function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
});})(G__34527_34530,G__34528_34531))
;
goog.object.set(G__34527_34530,G__34528_34531,G__34529_34532);
cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"boolean",true);

var G__34533_34536 = com.rpl.specter.protocols.implicit_nav;
var G__34534_34537 = "boolean";
var G__34535_34538 = ((function (G__34533_34536,G__34534_34537){
return (function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
});})(G__34533_34536,G__34534_34537))
;
goog.object.set(G__34533_34536,G__34534_34537,G__34535_34538);
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"function",true);

var G__34539_34542 = com.rpl.specter.protocols.implicit_nav;
var G__34540_34543 = "function";
var G__34541_34544 = ((function (G__34539_34542,G__34540_34543){
return (function (this$){
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.pred.call(null,this$));
});})(G__34539_34542,G__34540_34543))
;
goog.object.set(G__34539_34542,G__34540_34543,G__34541_34544);
cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.pred.call(null,this$__$1));
});
RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;

RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.regex_nav.call(null,this$__$1));
});


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
var G__34545 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34545) : next_fn.call(null,G__34545));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
var G__34546 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34546) : next_fn.call(null,G__34546));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj((function (v){
if(typeof com.rpl.specter.t_com$rpl$specter34547 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34547 = (function (v,meta34548){
this.v = v;
this.meta34548 = meta34548;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34547.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34549,meta34548__$1){
var self__ = this;
var _34549__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34547(self__.v,meta34548__$1));
});

com.rpl.specter.t_com$rpl$specter34547.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34549){
var self__ = this;
var _34549__$1 = this;
return self__.meta34548;
});

com.rpl.specter.t_com$rpl$specter34547.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34547.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn((((structure == null))?self__.v:structure));
});

com.rpl.specter.t_com$rpl$specter34547.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn((((structure == null))?self__.v:structure));
});

com.rpl.specter.t_com$rpl$specter34547.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta34548","meta34548",-748751545,null)], null);
});

com.rpl.specter.t_com$rpl$specter34547.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34547.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34547";

com.rpl.specter.t_com$rpl$specter34547.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34547");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34547.
 */
com.rpl.specter.__GT_t_com$rpl$specter34547 = (function com$rpl$specter$__GT_t_com$rpl$specter34547(v__$1,meta34548){
return (new com.rpl.specter.t_com$rpl$specter34547(v__$1,meta34548));
});

}

return (new com.rpl.specter.t_com$rpl$specter34547(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = (function (){var G__34550 = cljs.core.PersistentHashSet.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__34550) : com.rpl.specter.nil__GT_val.call(null,G__34550));
})();
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = (function (){var G__34551 = cljs.core.List.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__34551) : com.rpl.specter.nil__GT_val.call(null,G__34551));
})();
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = (function (){var G__34552 = cljs.core.PersistentVector.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__34552) : com.rpl.specter.nil__GT_val.call(null,G__34552));
})();


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
var G__34553 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34553) : next_fn.call(null,G__34553));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta(structure,(function (){var G__34554 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34554) : next_fn.call(null,G__34554));
})());
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34555 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34555 = (function (meta34556){
this.meta34556 = meta34556;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34555.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34557,meta34556__$1){
var self__ = this;
var _34557__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34555(meta34556__$1));
});

com.rpl.specter.t_com$rpl$specter34555.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34557){
var self__ = this;
var _34557__$1 = this;
return self__.meta34556;
});

com.rpl.specter.t_com$rpl$specter34555.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34555.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn(cljs.core.meta(structure));
});

com.rpl.specter.t_com$rpl$specter34555.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return cljs.core.with_meta(structure,next_fn(cljs.core.meta(structure)));
});

com.rpl.specter.t_com$rpl$specter34555.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34556","meta34556",1151891271,null)], null);
});

com.rpl.specter.t_com$rpl$specter34555.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34555.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34555";

com.rpl.specter.t_com$rpl$specter34555.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34555");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34555.
 */
com.rpl.specter.__GT_t_com$rpl$specter34555 = (function com$rpl$specter$__GT_t_com$rpl$specter34555(meta34556){
return (new com.rpl.specter.t_com$rpl$specter34555(meta34556));
});

}

return (new com.rpl.specter.t_com$rpl$specter34555(null));
})()
;


com.rpl.specter.NAME_select_STAR_ = (function com$rpl$specter$NAME_select_STAR_(structure,next_fn){
var G__34558 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34558) : next_fn.call(null,G__34558));
});

com.rpl.specter.NAME_transform_STAR_ = (function com$rpl$specter$NAME_transform_STAR_(structure,next_fn){
var new_name = (function (){var G__34559 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34559) : next_fn.call(null,G__34559));
})();
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0))));

}
}
});

/**
 * Navigates to the name portion of the keyword or symbol
 */
com.rpl.specter.NAME = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34560 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34560 = (function (meta34561){
this.meta34561 = meta34561;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34560.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34562,meta34561__$1){
var self__ = this;
var _34562__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34560(meta34561__$1));
});

com.rpl.specter.t_com$rpl$specter34560.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34562){
var self__ = this;
var _34562__$1 = this;
return self__.meta34561;
});

com.rpl.specter.t_com$rpl$specter34560.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34560.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn(cljs.core.name(structure));
});

com.rpl.specter.t_com$rpl$specter34560.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
var new_name = next_fn(cljs.core.name(structure));
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0))));

}
}
});

com.rpl.specter.t_com$rpl$specter34560.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34561","meta34561",-35284126,null)], null);
});

com.rpl.specter.t_com$rpl$specter34560.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34560.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34560";

com.rpl.specter.t_com$rpl$specter34560.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34560");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34560.
 */
com.rpl.specter.__GT_t_com$rpl$specter34560 = (function com$rpl$specter$__GT_t_com$rpl$specter34560(meta34561){
return (new com.rpl.specter.t_com$rpl$specter34560(meta34561));
});

}

return (new com.rpl.specter.t_com$rpl$specter34560(null));
})()
;


com.rpl.specter.NAMESPACE_select_STAR_ = (function com$rpl$specter$NAMESPACE_select_STAR_(structure,next_fn){
var G__34563 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34563) : next_fn.call(null,G__34563));
});

com.rpl.specter.NAMESPACE_transform_STAR_ = (function com$rpl$specter$NAMESPACE_transform_STAR_(structure,next_fn){
var name = cljs.core.name(structure);
var new_ns = (function (){var G__34564 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34564) : next_fn.call(null,G__34564));
})();
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0))));

}
}
});

/**
 * Navigates to the namespace portion of the keyword or symbol
 */
com.rpl.specter.NAMESPACE = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34565 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34565 = (function (meta34566){
this.meta34566 = meta34566;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34565.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34567,meta34566__$1){
var self__ = this;
var _34567__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34565(meta34566__$1));
});

com.rpl.specter.t_com$rpl$specter34565.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34567){
var self__ = this;
var _34567__$1 = this;
return self__.meta34566;
});

com.rpl.specter.t_com$rpl$specter34565.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34565.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
return next_fn(cljs.core.namespace(structure));
});

com.rpl.specter.t_com$rpl$specter34565.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32516__auto__,vals__32517__auto__,structure,next_fn__32518__auto__){
var self__ = this;
var this__32516__auto____$1 = this;
var next_fn = ((function (this__32516__auto____$1){
return (function (s__32519__auto__){
return (next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32518__auto__.cljs$core$IFn$_invoke$arity$2(vals__32517__auto__,s__32519__auto__) : next_fn__32518__auto__.call(null,vals__32517__auto__,s__32519__auto__));
});})(this__32516__auto____$1))
;
var name = cljs.core.name(structure);
var new_ns = next_fn(cljs.core.namespace(structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0))));

}
}
});

com.rpl.specter.t_com$rpl$specter34565.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34566","meta34566",-1425621575,null)], null);
});

com.rpl.specter.t_com$rpl$specter34565.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34565.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34565";

com.rpl.specter.t_com$rpl$specter34565.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34565");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34565.
 */
com.rpl.specter.__GT_t_com$rpl$specter34565 = (function com$rpl$specter$__GT_t_com$rpl$specter34565(meta34566){
return (new com.rpl.specter.t_com$rpl$specter34565(meta34566));
});

}

return (new com.rpl.specter.t_com$rpl$specter34565(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34575__delegate = function (path){
var builder__33126__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if(typeof com.rpl.specter.t_com$rpl$specter34568 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34568 = (function (path,late,meta34569){
this.path = path;
this.late = late;
this.meta34569 = meta34569;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34568.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34570,meta34569__$1){
var self__ = this;
var _34570__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34568(self__.path,self__.late,meta34569__$1));
});

com.rpl.specter.t_com$rpl$specter34568.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34570){
var self__ = this;
var _34570__$1 = this;
return self__.meta34569;
});

com.rpl.specter.t_com$rpl$specter34568.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34568.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33123__auto__,vals__33124__auto__,structure,next_fn__33125__auto__){
var self__ = this;
var this__33123__auto____$1 = this;
var G__34571 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33124__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__34572 = structure;
return (next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2(G__34571,G__34572) : next_fn__33125__auto__.call(null,G__34571,G__34572));
});

com.rpl.specter.t_com$rpl$specter34568.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33123__auto__,vals__33124__auto__,structure,next_fn__33125__auto__){
var self__ = this;
var this__33123__auto____$1 = this;
var G__34573 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33124__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__34574 = structure;
return (next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2(G__34573,G__34574) : next_fn__33125__auto__.call(null,G__34573,G__34574));
});

com.rpl.specter.t_com$rpl$specter34568.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34569","meta34569",1980890408,null)], null);
});

com.rpl.specter.t_com$rpl$specter34568.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34568.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34568";

com.rpl.specter.t_com$rpl$specter34568.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34568");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34568.
 */
com.rpl.specter.__GT_t_com$rpl$specter34568 = (function com$rpl$specter$__GT_t_com$rpl$specter34568(path__$1,late__$1,meta34569){
return (new com.rpl.specter.t_com$rpl$specter34568(path__$1,late__$1,meta34569));
});

}

return (new com.rpl.specter.t_com$rpl$specter34568(path,late,null));
}));
var curr_params__33127__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33127__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33126__auto__,curr_params__33127__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33126__auto__,curr_params__33127__auto__,null);
}
};
var G__34575 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34576__i = 0, G__34576__a = new Array(arguments.length -  0);
while (G__34576__i < G__34576__a.length) {G__34576__a[G__34576__i] = arguments[G__34576__i + 0]; ++G__34576__i;}
  path = new cljs.core.IndexedSeq(G__34576__a,0,null);
} 
return G__34575__delegate.call(this,path);};
G__34575.cljs$lang$maxFixedArity = 0;
G__34575.cljs$lang$applyTo = (function (arglist__34577){
var path = cljs.core.seq(arglist__34577);
return G__34575__delegate(path);
});
G__34575.cljs$core$IFn$_invoke$arity$variadic = G__34575__delegate;
return G__34575;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34585__delegate = function (path){
var builder__33126__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if(typeof com.rpl.specter.t_com$rpl$specter34578 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34578 = (function (path,late,meta34579){
this.path = path;
this.late = late;
this.meta34579 = meta34579;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34578.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34580,meta34579__$1){
var self__ = this;
var _34580__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34578(self__.path,self__.late,meta34579__$1));
});

com.rpl.specter.t_com$rpl$specter34578.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34580){
var self__ = this;
var _34580__$1 = this;
return self__.meta34579;
});

com.rpl.specter.t_com$rpl$specter34578.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34578.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33123__auto__,vals__33124__auto__,structure,next_fn__33125__auto__){
var self__ = this;
var this__33123__auto____$1 = this;
var G__34581 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33124__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__34582 = structure;
return (next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2(G__34581,G__34582) : next_fn__33125__auto__.call(null,G__34581,G__34582));
});

com.rpl.specter.t_com$rpl$specter34578.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33123__auto__,vals__33124__auto__,structure,next_fn__33125__auto__){
var self__ = this;
var this__33123__auto____$1 = this;
var G__34583 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33124__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__34584 = structure;
return (next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2(G__34583,G__34584) : next_fn__33125__auto__.call(null,G__34583,G__34584));
});

com.rpl.specter.t_com$rpl$specter34578.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34579","meta34579",964688306,null)], null);
});

com.rpl.specter.t_com$rpl$specter34578.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34578.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34578";

com.rpl.specter.t_com$rpl$specter34578.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34578");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34578.
 */
com.rpl.specter.__GT_t_com$rpl$specter34578 = (function com$rpl$specter$__GT_t_com$rpl$specter34578(path__$1,late__$1,meta34579){
return (new com.rpl.specter.t_com$rpl$specter34578(path__$1,late__$1,meta34579));
});

}

return (new com.rpl.specter.t_com$rpl$specter34578(path,late,null));
}));
var curr_params__33127__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33127__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33126__auto__,curr_params__33127__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33126__auto__,curr_params__33127__auto__,null);
}
};
var G__34585 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34586__i = 0, G__34586__a = new Array(arguments.length -  0);
while (G__34586__i < G__34586__a.length) {G__34586__a[G__34586__i] = arguments[G__34586__i + 0]; ++G__34586__i;}
  path = new cljs.core.IndexedSeq(G__34586__a,0,null);
} 
return G__34585__delegate.call(this,path);};
G__34585.cljs$lang$maxFixedArity = 0;
G__34585.cljs$lang$applyTo = (function (arglist__34587){
var path = cljs.core.seq(arglist__34587);
return G__34585__delegate(path);
});
G__34585.cljs$core$IFn$_invoke$arity$variadic = G__34585__delegate;
return G__34585;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj((function (val){
if(typeof com.rpl.specter.t_com$rpl$specter34588 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34588 = (function (val,meta34589){
this.val = val;
this.meta34589 = meta34589;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34588.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34590,meta34589__$1){
var self__ = this;
var _34590__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34588(self__.val,meta34589__$1));
});

com.rpl.specter.t_com$rpl$specter34588.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34590){
var self__ = this;
var _34590__$1 = this;
return self__.meta34589;
});

com.rpl.specter.t_com$rpl$specter34588.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34588.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33123__auto__,vals__33124__auto__,structure,next_fn__33125__auto__){
var self__ = this;
var this__33123__auto____$1 = this;
var G__34591 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33124__auto__,self__.val);
var G__34592 = structure;
return (next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2(G__34591,G__34592) : next_fn__33125__auto__.call(null,G__34591,G__34592));
});

com.rpl.specter.t_com$rpl$specter34588.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33123__auto__,vals__33124__auto__,structure,next_fn__33125__auto__){
var self__ = this;
var this__33123__auto____$1 = this;
var G__34593 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33124__auto__,self__.val);
var G__34594 = structure;
return (next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33125__auto__.cljs$core$IFn$_invoke$arity$2(G__34593,G__34594) : next_fn__33125__auto__.call(null,G__34593,G__34594));
});

com.rpl.specter.t_com$rpl$specter34588.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta34589","meta34589",1218844863,null)], null);
});

com.rpl.specter.t_com$rpl$specter34588.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34588.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34588";

com.rpl.specter.t_com$rpl$specter34588.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34588");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34588.
 */
com.rpl.specter.__GT_t_com$rpl$specter34588 = (function com$rpl$specter$__GT_t_com$rpl$specter34588(val__$1,meta34589){
return (new com.rpl.specter.t_com$rpl$specter34588(val__$1,meta34589));
});

}

return (new com.rpl.specter.t_com$rpl$specter34588(val,null));
}));
/**
 * Continues navigating on the given path with the collected vals reset to []. Once
 *   navigation leaves the scope of with-fresh-collected, the collected vals revert
 *   to what they were before.
 */
com.rpl.specter.with_fresh_collected = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34600__delegate = function (path){
var builder__33126__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if(typeof com.rpl.specter.t_com$rpl$specter34595 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34595 = (function (path,late,meta34596){
this.path = path;
this.late = late;
this.meta34596 = meta34596;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34595.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34597,meta34596__$1){
var self__ = this;
var _34597__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34595(self__.path,self__.late,meta34596__$1));
});

com.rpl.specter.t_com$rpl$specter34595.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34597){
var self__ = this;
var _34597__$1 = this;
return self__.meta34596;
});

com.rpl.specter.t_com$rpl$specter34595.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34595.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.select_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,((function (this$__$1){
return (function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
});})(this$__$1))
);
});

com.rpl.specter.t_com$rpl$specter34595.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.transform_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,((function (this$__$1){
return (function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
});})(this$__$1))
);
});

com.rpl.specter.t_com$rpl$specter34595.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34596","meta34596",-1677084891,null)], null);
});

com.rpl.specter.t_com$rpl$specter34595.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34595.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34595";

com.rpl.specter.t_com$rpl$specter34595.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34595");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34595.
 */
com.rpl.specter.__GT_t_com$rpl$specter34595 = (function com$rpl$specter$__GT_t_com$rpl$specter34595(path__$1,late__$1,meta34596){
return (new com.rpl.specter.t_com$rpl$specter34595(path__$1,late__$1,meta34596));
});

}

return (new com.rpl.specter.t_com$rpl$specter34595(path,late,null));
}));
var curr_params__33127__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33127__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33126__auto__,curr_params__33127__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33126__auto__,curr_params__33127__auto__,null);
}
};
var G__34600 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34601__i = 0, G__34601__a = new Array(arguments.length -  0);
while (G__34601__i < G__34601__a.length) {G__34601__a[G__34601__i] = arguments[G__34601__i + 0]; ++G__34601__i;}
  path = new cljs.core.IndexedSeq(G__34601__a,0,null);
} 
return G__34600__delegate.call(this,path);};
G__34600.cljs$lang$maxFixedArity = 0;
G__34600.cljs$lang$applyTo = (function (arglist__34602){
var path = cljs.core.seq(arglist__34602);
return G__34600__delegate(path);
});
G__34600.cljs$core$IFn$_invoke$arity$variadic = G__34600__delegate;
return G__34600;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter34603 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34603 = (function (meta34604){
this.meta34604 = meta34604;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34603.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34605,meta34604__$1){
var self__ = this;
var _34605__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34603(meta34604__$1));
});

com.rpl.specter.t_com$rpl$specter34603.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34605){
var self__ = this;
var _34605__$1 = this;
return self__.meta34604;
});

com.rpl.specter.t_com$rpl$specter34603.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34603.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__34606 = cljs.core.PersistentVector.EMPTY;
var G__34607 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__34606,G__34607) : next_fn.call(null,G__34606,G__34607));
});

com.rpl.specter.t_com$rpl$specter34603.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__34608 = cljs.core.PersistentVector.EMPTY;
var G__34609 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__34608,G__34609) : next_fn.call(null,G__34608,G__34609));
});

com.rpl.specter.t_com$rpl$specter34603.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34604","meta34604",1392069369,null)], null);
});

com.rpl.specter.t_com$rpl$specter34603.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34603.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34603";

com.rpl.specter.t_com$rpl$specter34603.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34603");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34603.
 */
com.rpl.specter.__GT_t_com$rpl$specter34603 = (function com$rpl$specter$__GT_t_com$rpl$specter34603(meta34604){
return (new com.rpl.specter.t_com$rpl$specter34603(meta34604));
});

}

return (new com.rpl.specter.t_com$rpl$specter34603(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__34618 = null;
var G__34618__2 = (function (cond_p,then_path){
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(cond_p,then_path,com.rpl.specter.STOP) : com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP));
});
var G__34618__3 = (function (cond_p,then_path,else_path){
var temp__5455__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(cond_p);
if(cljs.core.truth_(temp__5455__auto__)){
var afn = temp__5455__auto__;
var builder__33126__auto__ = com.rpl.specter.impl.direct_nav_obj(((function (afn,temp__5455__auto__){
return (function (late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter34612 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34612 = (function (cond_p,then_path,else_path,temp__5455__auto__,afn,late_then,late_else,meta34613){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5455__auto__ = temp__5455__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta34613 = meta34613;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34612.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (afn,temp__5455__auto__){
return (function (_34614,meta34613__$1){
var self__ = this;
var _34614__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34612(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5455__auto__,self__.afn,self__.late_then,self__.late_else,meta34613__$1));
});})(afn,temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34612.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (afn,temp__5455__auto__){
return (function (_34614){
var self__ = this;
var _34614__$1 = this;
return self__.meta34613;
});})(afn,temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34612.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34612.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (afn,temp__5455__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34612.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (afn,temp__5455__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34612.getBasis = ((function (afn,temp__5455__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5455__auto__","temp__5455__auto__",980956642,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta34613","meta34613",914794131,null)], null);
});})(afn,temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34612.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34612.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34612";

com.rpl.specter.t_com$rpl$specter34612.cljs$lang$ctorPrWriter = ((function (afn,temp__5455__auto__){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34612");
});})(afn,temp__5455__auto__))
;

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34612.
 */
com.rpl.specter.__GT_t_com$rpl$specter34612 = ((function (afn,temp__5455__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter34612(cond_p__$1,then_path__$1,else_path__$1,temp__5455__auto____$1,afn__$1,late_then__$1,late_else__$1,meta34613){
return (new com.rpl.specter.t_com$rpl$specter34612(cond_p__$1,then_path__$1,else_path__$1,temp__5455__auto____$1,afn__$1,late_then__$1,late_else__$1,meta34613));
});})(afn,temp__5455__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter34612(cond_p,then_path,else_path,temp__5455__auto__,afn,late_then,late_else,null));
});})(afn,temp__5455__auto__))
);
var curr_params__33127__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33127__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33126__auto__,curr_params__33127__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33126__auto__,curr_params__33127__auto__,null);
}
} else {
var builder__33126__auto__ = com.rpl.specter.impl.direct_nav_obj(((function (temp__5455__auto__){
return (function (late_cond,late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter34615 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34615 = (function (cond_p,then_path,else_path,temp__5455__auto__,late_cond,late_then,late_else,meta34616){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5455__auto__ = temp__5455__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta34616 = meta34616;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34615.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__5455__auto__){
return (function (_34617,meta34616__$1){
var self__ = this;
var _34617__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34615(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5455__auto__,self__.late_cond,self__.late_then,self__.late_else,meta34616__$1));
});})(temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34615.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__5455__auto__){
return (function (_34617){
var self__ = this;
var _34617__$1 = this;
return self__.meta34616;
});})(temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34615.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34615.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__5455__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,((function (this$__$1,temp__5455__auto__){
return (function (p1__34610_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__34610_SHARP_);
});})(this$__$1,temp__5455__auto__))
,self__.late_then,self__.late_else);
});})(temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34615.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__5455__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,((function (this$__$1,temp__5455__auto__){
return (function (p1__34611_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__34611_SHARP_);
});})(this$__$1,temp__5455__auto__))
,self__.late_then,self__.late_else);
});})(temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34615.getBasis = ((function (temp__5455__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5455__auto__","temp__5455__auto__",980956642,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta34616","meta34616",-1063578255,null)], null);
});})(temp__5455__auto__))
;

com.rpl.specter.t_com$rpl$specter34615.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34615.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34615";

com.rpl.specter.t_com$rpl$specter34615.cljs$lang$ctorPrWriter = ((function (temp__5455__auto__){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34615");
});})(temp__5455__auto__))
;

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34615.
 */
com.rpl.specter.__GT_t_com$rpl$specter34615 = ((function (temp__5455__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter34615(cond_p__$1,then_path__$1,else_path__$1,temp__5455__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta34616){
return (new com.rpl.specter.t_com$rpl$specter34615(cond_p__$1,then_path__$1,else_path__$1,temp__5455__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta34616));
});})(temp__5455__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter34615(cond_p,then_path,else_path,temp__5455__auto__,late_cond,late_then,late_else,null));
});})(temp__5455__auto__))
);
var curr_params__33127__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(cond_p) : com.rpl.specter.late_path.call(null,cond_p)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33127__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33126__auto__,curr_params__33127__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33126__auto__,curr_params__33127__auto__,null);
}
}
});
G__34618 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__34618__2.call(this,cond_p,then_path);
case 3:
return G__34618__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__34618.cljs$core$IFn$_invoke$arity$2 = G__34618__2;
G__34618.cljs$core$IFn$_invoke$arity$3 = G__34618__3;
return G__34618;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34623__delegate = function (conds){
var pairs = cljs.core.reverse(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),conds));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (pairs){
return (function (p,p__34619){
var vec__34620 = p__34619;
var tester = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34620,(0),null);
var apath = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34620,(1),null);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(tester,apath,p) : com.rpl.specter.if_path.call(null,tester,apath,p));
});})(pairs))
,com.rpl.specter.STOP,pairs);
};
var G__34623 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__34624__i = 0, G__34624__a = new Array(arguments.length -  0);
while (G__34624__i < G__34624__a.length) {G__34624__a[G__34624__i] = arguments[G__34624__i + 0]; ++G__34624__i;}
  conds = new cljs.core.IndexedSeq(G__34624__a,0,null);
} 
return G__34623__delegate.call(this,conds);};
G__34623.cljs$lang$maxFixedArity = 0;
G__34623.cljs$lang$applyTo = (function (arglist__34625){
var conds = cljs.core.seq(arglist__34625);
return G__34623__delegate(conds);
});
G__34623.cljs$core$IFn$_invoke$arity$variadic = G__34623__delegate;
return G__34623;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__34633 = null;
var G__34633__0 = (function (){
return com.rpl.specter.STAY;
});
var G__34633__1 = (function (path){
return path;
});
var G__34633__2 = (function (path1,path2){
var builder__33126__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late1,late2){
if(typeof com.rpl.specter.t_com$rpl$specter34626 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34626 = (function (path1,path2,late1,late2,meta34627){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta34627 = meta34627;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
com.rpl.specter.t_com$rpl$specter34626.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34628,meta34627__$1){
var self__ = this;
var _34628__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34626(self__.path1,self__.path2,self__.late1,self__.late2,meta34627__$1));
});

com.rpl.specter.t_com$rpl$specter34626.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34628){
var self__ = this;
var _34628__$1 = this;
return self__.meta34627;
});

com.rpl.specter.t_com$rpl$specter34626.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter34626.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_(self__.late1,vals,structure,next_fn);
if(cljs.core.reduced_QMARK_(res1)){
return res1;
} else {
var res2 = com.rpl.specter.protocols.select_STAR_(self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res1)){
return res2;
} else {
return res1;
}
}
});

com.rpl.specter.t_com$rpl$specter34626.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_(self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_(self__.late2,vals,s1,next_fn);
});

com.rpl.specter.t_com$rpl$specter34626.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta34627","meta34627",-2042983743,null)], null);
});

com.rpl.specter.t_com$rpl$specter34626.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter34626.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34626";

com.rpl.specter.t_com$rpl$specter34626.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"com.rpl.specter/t_com$rpl$specter34626");
});

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34626.
 */
com.rpl.specter.__GT_t_com$rpl$specter34626 = (function com$rpl$specter$__GT_t_com$rpl$specter34626(path1__$1,path2__$1,late1__$1,late2__$1,meta34627){
return (new com.rpl.specter.t_com$rpl$specter34626(path1__$1,path2__$1,late1__$1,late2__$1,meta34627));
});

}

return (new com.rpl.specter.t_com$rpl$specter34626(path1,path2,late1,late2,null));
}));
var curr_params__33127__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path1) : com.rpl.specter.late_path.call(null,path1)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path2) : com.rpl.specter.late_path.call(null,path2))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33127__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33126__auto__,curr_params__33127__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33126__auto__,curr_params__33127__auto__,null);
}
});
var G__34633__3 = (function() { 
var G__34634__delegate = function (path1,path2,paths){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(com.rpl.specter.multi_path,(com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path1,path2) : com.rpl.specter.multi_path.call(null,path1,path2)),paths);
};
var G__34634 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__34635__i = 0, G__34635__a = new Array(arguments.length -  2);
while (G__34635__i < G__34635__a.length) {G__34635__a[G__34635__i] = arguments[G__34635__i + 2]; ++G__34635__i;}
  paths = new cljs.core.IndexedSeq(G__34635__a,0,null);
} 
return G__34634__delegate.call(this,path1,path2,paths);};
G__34634.cljs$lang$maxFixedArity = 2;
G__34634.cljs$lang$applyTo = (function (arglist__34636){
var path1 = cljs.core.first(arglist__34636);
arglist__34636 = cljs.core.next(arglist__34636);
var path2 = cljs.core.first(arglist__34636);
var paths = cljs.core.rest(arglist__34636);
return G__34634__delegate(path1,path2,paths);
});
G__34634.cljs$core$IFn$_invoke$arity$variadic = G__34634__delegate;
return G__34634;
})()
;
G__34633 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__34633__0.call(this);
case 1:
return G__34633__1.call(this,path1);
case 2:
return G__34633__2.call(this,path1,path2);
default:
var G__34637 = null;
if (arguments.length > 2) {
var G__34638__i = 0, G__34638__a = new Array(arguments.length -  2);
while (G__34638__i < G__34638__a.length) {G__34638__a[G__34638__i] = arguments[G__34638__i + 2]; ++G__34638__i;}
G__34637 = new cljs.core.IndexedSeq(G__34638__a,0,null);
}
return G__34633__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__34637);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__34633.cljs$lang$maxFixedArity = 2;
G__34633.cljs$lang$applyTo = G__34633__3.cljs$lang$applyTo;
G__34633.cljs$core$IFn$_invoke$arity$0 = G__34633__0;
G__34633.cljs$core$IFn$_invoke$arity$1 = G__34633__1;
G__34633.cljs$core$IFn$_invoke$arity$2 = G__34633__2;
G__34633.cljs$core$IFn$_invoke$arity$variadic = G__34633__3.cljs$core$IFn$_invoke$arity$variadic;
return G__34633;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34639__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.STAY,path) : com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path));
};
var G__34639 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34640__i = 0, G__34640__a = new Array(arguments.length -  0);
while (G__34640__i < G__34640__a.length) {G__34640__a[G__34640__i] = arguments[G__34640__i + 0]; ++G__34640__i;}
  path = new cljs.core.IndexedSeq(G__34640__a,0,null);
} 
return G__34639__delegate.call(this,path);};
G__34639.cljs$lang$maxFixedArity = 0;
G__34639.cljs$lang$applyTo = (function (arglist__34641){
var path = cljs.core.seq(arglist__34641);
return G__34639__delegate(path);
});
G__34639.cljs$core$IFn$_invoke$arity$variadic = G__34639__delegate;
return G__34639;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34642__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path,com.rpl.specter.STAY) : com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY));
};
var G__34642 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34643__i = 0, G__34643__a = new Array(arguments.length -  0);
while (G__34643__i < G__34643__a.length) {G__34643__a[G__34643__i] = arguments[G__34643__i + 0]; ++G__34643__i;}
  path = new cljs.core.IndexedSeq(G__34643__a,0,null);
} 
return G__34642__delegate.call(this,path);};
G__34642.cljs$lang$maxFixedArity = 0;
G__34642.cljs$lang$applyTo = (function (arglist__34644){
var path = cljs.core.seq(arglist__34644);
return G__34642__delegate(path);
});
G__34642.cljs$core$IFn$_invoke$arity$variadic = G__34642__delegate;
return G__34642;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigate the data structure until reaching
 *        a value for which `afn` returns truthy. Has
 *        same semantics as clojure.walk.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__33133__auto__ = com.rpl.specter.pathcache34645;
var info__33133__auto____$1 = (((info__33133__auto__ == null))?(function (){var info34646 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1390,1390,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1171,1175,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,640,642,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",(21),(1),(2099),(2099),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",((cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,675,678,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache34645 = info34646;

return info34646;
})():info__33133__auto__);
var precompiled34647 = com.rpl.specter.impl.cached_path_info_precompiled(info__33133__auto____$1);
var dynamic_QMARK___33134__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33133__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33134__auto__)){
var G__34648 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,p], null),com.rpl.specter.ALL,p], null);
return (precompiled34647.cljs$core$IFn$_invoke$arity$1 ? precompiled34647.cljs$core$IFn$_invoke$arity$1(G__34648) : precompiled34647.call(null,G__34648));
} else {
return precompiled34647;
}
})());

return p;
}));
/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__33133__auto__ = com.rpl.specter.pathcache34649;
var info__33133__auto____$1 = (((info__33133__auto__ == null))?(function (){var info34650 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1390,1390,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1171,1175,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,640,642,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",(21),(1),(2099),(2099),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",((cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL_WITH_META,new cljs.core.Var(function(){return com.rpl.specter.ALL_WITH_META;},new cljs.core.Symbol("com.rpl.specter","ALL-WITH-META","com.rpl.specter/ALL-WITH-META",-1161868995,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),"com/rpl/specter.cljc",16,1,685,687,cljs.core.List.EMPTY,"Same as ALL, except maintains metadata on the structure.",(cljs.core.truth_(com.rpl.specter.ALL_WITH_META)?com.rpl.specter.ALL_WITH_META.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache34649 = info34650;

return info34650;
})():info__33133__auto__);
var precompiled34651 = com.rpl.specter.impl.cached_path_info_precompiled(info__33133__auto____$1);
var dynamic_QMARK___33134__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33133__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33134__auto__)){
var G__34652 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL_WITH_META,p], null),com.rpl.specter.ALL_WITH_META,p], null);
return (precompiled34651.cljs$core$IFn$_invoke$arity$1 ? precompiled34651.cljs$core$IFn$_invoke$arity$1(G__34652) : precompiled34651.call(null,G__34652));
} else {
return precompiled34651;
}
})());

return p;
}));
var empty__GT_NONE_34655 = (function (){var G__34653 = cljs.core.empty_QMARK_;
var G__34654 = com.rpl.specter.terminal_val(com.rpl.specter.NONE);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2(G__34653,G__34654) : com.rpl.specter.if_path.call(null,G__34653,G__34654));
})();
var compact_STAR__34656 = ((function (empty__GT_NONE_34655){
return (function (nav){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(nav,empty__GT_NONE_34655) : com.rpl.specter.multi_path.call(null,nav,empty__GT_NONE_34655));
});})(empty__GT_NONE_34655))
;
/**
 * During transforms, after each step of navigation in subpath check if the
 *  value is empty. If so, remove that value by setting it to NONE.
 */
com.rpl.specter.compact = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav(((function (empty__GT_NONE_34655,compact_STAR__34656){
return (function() { 
var G__34657__delegate = function (path){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(compact_STAR__34656,path);
};
var G__34657 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34658__i = 0, G__34658__a = new Array(arguments.length -  0);
while (G__34658__i < G__34658__a.length) {G__34658__a[G__34658__i] = arguments[G__34658__i + 0]; ++G__34658__i;}
  path = new cljs.core.IndexedSeq(G__34658__a,0,null);
} 
return G__34657__delegate.call(this,path);};
G__34657.cljs$lang$maxFixedArity = 0;
G__34657.cljs$lang$applyTo = (function (arglist__34659){
var path = cljs.core.seq(arglist__34659);
return G__34657__delegate(path);
});
G__34657.cljs$core$IFn$_invoke$arity$variadic = G__34657__delegate;
return G__34657;
})()
;})(empty__GT_NONE_34655,compact_STAR__34656))
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);

//# sourceMappingURL=com.rpl.specter.js.map
