goog.provide('examples.views');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('devcards.core');
goog.require('devcards.util.edn_renderer');
goog.require('reagent.core');
goog.require('reagent_dnd.core');
goog.require('reagent.ratom');
goog.require('examples.utils');
goog.require('examples.views.single_target');
goog.require('examples.views.multiple_targets');
goog.require('examples.views.stress_test');
goog.require('examples.views.drag_around_naive');
goog.require('examples.views.drag_around_custom');
goog.require('examples.views.nested_drag_sources');
goog.require('examples.views.nested_drop_targets');
goog.require('examples.views.simple_sortable');
examples.views.link = (function examples$views$link(page,url){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),url], null),page], null);
});
examples.views.link_col = (function examples$views$link_col(var_args){
var args__4502__auto__ = [];
var len__4499__auto___32641 = arguments.length;
var i__4500__auto___32642 = (0);
while(true){
if((i__4500__auto___32642 < len__4499__auto___32641)){
args__4502__auto__.push((arguments[i__4500__auto___32642]));

var G__32644 = (i__4500__auto___32642 + (1));
i__4500__auto___32642 = G__32644;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return examples.views.link_col.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

examples.views.link_col.cljs$core$IFn$_invoke$arity$variadic = (function (page,p__32635){
var vec__32636 = p__32635;
var url = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32636,(0),null);
var url__$1 = (function (){var or__3922__auto__ = url;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return ["#/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(page)].join('');
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.col","div.col",-1800797011),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.link,page,url__$1], null)], null);
});

examples.views.link_col.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
examples.views.link_col.cljs$lang$applyTo = (function (seq32619){
var G__32620 = cljs.core.first(seq32619);
var seq32619__$1 = cljs.core.next(seq32619);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32620,seq32619__$1);
});

examples.views.header = (function examples$views$header(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.grid-center.title","div.grid-center.title",-1404435198),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.link_col,"reagent-dnd","#/"], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.grid","div.grid",736588158),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.link_col,"about"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.link_col,"docs"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.link_col,"tutorial"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.link_col,"examples"], null)], null)], null);
});
examples.views.knight = (function examples$views$knight(state){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"opacity","opacity",397153780),(cljs.core.truth_(new cljs.core.Keyword(null,"dragging?","dragging?",-995941410).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state)))?0.1:(1)),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"background-color","background-color",570434026),(cljs.core.truth_(new cljs.core.Keyword(null,"dragging?","dragging?",-995941410).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state)))?new cljs.core.Keyword(null,"white","white",-483998618):new cljs.core.Keyword(null,"grey","grey",1875582333)),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"64px"], null)], null),"\u2658"], null);
});
examples.views.draggable = (function examples$views$draggable(state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent_dnd.core.drag_source,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"knight","knight",-1883332680),new cljs.core.Keyword(null,"end-drag","end-drag",1040662768),(function (state__$1){
return console.log("dropped on: ",cljs.core.clj__GT_js(new cljs.core.Keyword(null,"drop-result","drop-result",685902571).cljs$core$IFn$_invoke$arity$1(state__$1)));
}),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.knight,state], null),new cljs.core.Keyword(null,"begin-drag","begin-drag",-1601004463),(function (){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),(1)], null);
}),new cljs.core.Keyword(null,"state","state",-1988618099),state], null);
});
});
examples.views.square = (function examples$views$square(state){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"height","height",1025178622),"64px",new cljs.core.Keyword(null,"width","width",-384071477),"64px",new cljs.core.Keyword(null,"background-color","background-color",570434026),(cljs.core.truth_(new cljs.core.Keyword(null,"is-over?","is-over?",-228432368).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state)))?"#555":(cljs.core.truth_(new cljs.core.Keyword(null,"can-drop?","can-drop?",-1770906846).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state)))?"#777":"#999"
))], null)], null)], null);
});
examples.views.droppable = (function examples$views$droppable(state){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent_dnd.core.drop_target,new cljs.core.Keyword(null,"types","types",590030639),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"knight","knight",-1883332680)], null),new cljs.core.Keyword(null,"drop","drop",364481611),(function (state__$1){
console.log("dropped item: ",cljs.core.clj__GT_js(new cljs.core.Keyword(null,"item","item",249373802).cljs$core$IFn$_invoke$arity$1(state__$1)));

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),(5)], null);
}),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.square,state], null),new cljs.core.Keyword(null,"state","state",-1988618099),state], null);
});
});
examples.views.about_text = (function examples$views$about_text(drag_state,drop_state){
return (function (){
return examples.utils.document.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["\n# Reagent-dnd: Simple Drag & Drop for Reagent\nReagent-dnd is a set of [Reagent](https://reagent-project.github.io/) \ncomponents that help you create drag-and-drop\ninterfaces that don't directly manipulate the DOM. It's a very thin wrapper \naround the excellent [ReactDnD](https://gaearon.github.io/react-dnd/) library.\n\nI built it because I had trouble finding a good way to use drag-and-drop from\nClojureScript. I wanted something that:\n\nSome libraries manipulated the DOM, which made them unsuitable\nfor use with React or Reagent. Using the\n[disastrous](http://www.quirksmode.org/blog/archives/2009/09/the_html5_drag.html)\nHTML5 drag & drop API was painful and bug-prone. ReactDnD was a breath of fresh\nair--a simple drag & drop library that focused on how the operation changed\nyour *data* without changing the DOM state directly. I wanted a simple way to\nuse it with Reagent.\n  \n## What does it look like?\n",["\n```clojure\n","(defn knight [state]\n  [:span {:style {:opacity          (if (:dragging? @state) 0.1 1)\n                  :cursor           :move\n                  :background-color (if (:dragging? @state)\n                                      :white\n                                      :grey)\n                  :font-size        \"64px\"}}\n   \"\u2658\"])","\n```\n"].join(''),["\n```clojure\n","(defn draggable\n  [state]\n  (fn []\n    [dnd/drag-source\n     :type       :knight\n     :end-drag   (fn [state]\n                   (js/console.log \"dropped on: \" (clj->js (:drop-result state))))\n     :child      [knight state]\n     :begin-drag (fn [] {:id 1})\n     :state      state]))","\n```\n"].join(''),["\n```clojure\n","(defn square [state]\n  [:div {:style {:height           \"64px\"\n                 :width            \"64px\"\n                 :background-color (cond\n                                     (:is-over? @state) \"#555\"\n                                     (:can-drop? @state) \"#777\"\n                                     :default \"#999\")}}])","\n```\n"].join(''),["\n```clojure\n","(defn droppable\n  [state]\n  (fn []\n    [dnd/drop-target\n     :types [:knight]\n     :drop (fn [state]\n             (js/console.log \"dropped item: \" (clj->js (:item state)))\n             {:id 5})\n     :child [square state]\n     :state state]))","\n```\n"].join(''),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.draggable,drag_state], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.droppable,drop_state], null)], 0));
});
});
examples.views.about = (function examples$views$about(){
var drag_state = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var drop_state = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
return ((function (drag_state,drop_state){
return (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.utils.card,new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.about_text,drag_state,drop_state], null),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drag-state","drag-state",-909192848),drag_state,new cljs.core.Keyword(null,"drop-state","drop-state",-1460909430),drop_state], null)], null);
});
;})(drag_state,drop_state))
});
examples.views.link_to = (function examples$views$link_to(category,id){
var txt = examples.utils.make_title(id);
var url = examples.utils.make_url(category,id);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),url], null),txt], null);
});
examples.views.examples_components = (new cljs.core.PersistentArrayMap(null,(4),[new cljs.core.Keyword(null,"dustbin","dustbin",-1858295071),(new cljs.core.PersistentArrayMap(null,(3),[new cljs.core.Keyword(null,"single-target","single-target",-1489901181),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.single_target.view], null),new cljs.core.Keyword(null,"multiple-targets","multiple-targets",-245955838),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.multiple_targets.view], null),new cljs.core.Keyword(null,"stress-test","stress-test",1783881204),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.stress_test.view], null)],null)),new cljs.core.Keyword(null,"drag-around","drag-around",606848287),(new cljs.core.PersistentArrayMap(null,(2),[new cljs.core.Keyword(null,"naive","naive",1530963556),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.drag_around_naive.view], null),new cljs.core.Keyword(null,"custom","custom",340151948),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.drag_around_custom.view], null)],null)),new cljs.core.Keyword(null,"nested","nested",18943849),(new cljs.core.PersistentArrayMap(null,(2),[new cljs.core.Keyword(null,"drag-sources","drag-sources",-314298452),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.nested_drag_sources.view], null),new cljs.core.Keyword(null,"drop-targets","drop-targets",1469357824),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.nested_drop_targets.view], null)],null)),new cljs.core.Keyword(null,"sorted","sorted",-896746253),(new cljs.core.PersistentArrayMap(null,(1),[new cljs.core.Keyword(null,"simple-sorted","simple-sorted",-1482467422),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.simple_sortable.view], null)],null))],null));
examples.views.examples_sidebar = (function examples$views$examples_sidebar(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),(function (){var iter__4292__auto__ = (function examples$views$examples_sidebar_$_iter__32661(s__32662){
return (new cljs.core.LazySeq(null,(function (){
var s__32662__$1 = s__32662;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__32662__$1);
if(temp__5457__auto__){
var s__32662__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__32662__$2)){
var c__4290__auto__ = cljs.core.chunk_first(s__32662__$2);
var size__4291__auto__ = cljs.core.count(c__4290__auto__);
var b__32664 = cljs.core.chunk_buffer(size__4291__auto__);
if((function (){var i__32663 = (0);
while(true){
if((i__32663 < size__4291__auto__)){
var vec__32665 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4290__auto__,i__32663);
var ex_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32665,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32665,(1),null);
cljs.core.chunk_append(b__32664,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.sidebar-group","div.sidebar-group",1647298950),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4.sidebar-group","h4.sidebar-group",-225031011),examples.utils.make_title(ex_name)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__4292__auto__ = ((function (i__32663,vec__32665,ex_name,m,c__4290__auto__,size__4291__auto__,b__32664,s__32662__$2,temp__5457__auto__){
return (function examples$views$examples_sidebar_$_iter__32661_$_iter__32668(s__32669){
return (new cljs.core.LazySeq(null,((function (i__32663,vec__32665,ex_name,m,c__4290__auto__,size__4291__auto__,b__32664,s__32662__$2,temp__5457__auto__){
return (function (){
var s__32669__$1 = s__32669;
while(true){
var temp__5457__auto____$1 = cljs.core.seq(s__32669__$1);
if(temp__5457__auto____$1){
var s__32669__$2 = temp__5457__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__32669__$2)){
var c__4290__auto____$1 = cljs.core.chunk_first(s__32669__$2);
var size__4291__auto____$1 = cljs.core.count(c__4290__auto____$1);
var b__32671 = cljs.core.chunk_buffer(size__4291__auto____$1);
if((function (){var i__32670 = (0);
while(true){
if((i__32670 < size__4291__auto____$1)){
var vec__32672 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4290__auto____$1,i__32670);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32672,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32672,(1),null);
cljs.core.chunk_append(b__32671,cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),examples.views.link_to(ex_name,id)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),["sidebar-example-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join('')], null)));

var G__32691 = (i__32670 + (1));
i__32670 = G__32691;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32671),examples$views$examples_sidebar_$_iter__32661_$_iter__32668(cljs.core.chunk_rest(s__32669__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32671),null);
}
} else {
var vec__32675 = cljs.core.first(s__32669__$2);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32675,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32675,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),examples.views.link_to(ex_name,id)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),["sidebar-example-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join('')], null)),examples$views$examples_sidebar_$_iter__32661_$_iter__32668(cljs.core.rest(s__32669__$2)));
}
} else {
return null;
}
break;
}
});})(i__32663,vec__32665,ex_name,m,c__4290__auto__,size__4291__auto__,b__32664,s__32662__$2,temp__5457__auto__))
,null,null));
});})(i__32663,vec__32665,ex_name,m,c__4290__auto__,size__4291__auto__,b__32664,s__32662__$2,temp__5457__auto__))
;
return iter__4292__auto__(m);
})()], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),["sidebar-example-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ex_name)].join('')], null)));

var G__32692 = (i__32663 + (1));
i__32663 = G__32692;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32664),examples$views$examples_sidebar_$_iter__32661(cljs.core.chunk_rest(s__32662__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32664),null);
}
} else {
var vec__32678 = cljs.core.first(s__32662__$2);
var ex_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32678,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32678,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.sidebar-group","div.sidebar-group",1647298950),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4.sidebar-group","h4.sidebar-group",-225031011),examples.utils.make_title(ex_name)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__4292__auto__ = ((function (vec__32678,ex_name,m,s__32662__$2,temp__5457__auto__){
return (function examples$views$examples_sidebar_$_iter__32661_$_iter__32681(s__32682){
return (new cljs.core.LazySeq(null,((function (vec__32678,ex_name,m,s__32662__$2,temp__5457__auto__){
return (function (){
var s__32682__$1 = s__32682;
while(true){
var temp__5457__auto____$1 = cljs.core.seq(s__32682__$1);
if(temp__5457__auto____$1){
var s__32682__$2 = temp__5457__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__32682__$2)){
var c__4290__auto__ = cljs.core.chunk_first(s__32682__$2);
var size__4291__auto__ = cljs.core.count(c__4290__auto__);
var b__32684 = cljs.core.chunk_buffer(size__4291__auto__);
if((function (){var i__32683 = (0);
while(true){
if((i__32683 < size__4291__auto__)){
var vec__32685 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4290__auto__,i__32683);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32685,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32685,(1),null);
cljs.core.chunk_append(b__32684,cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),examples.views.link_to(ex_name,id)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),["sidebar-example-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join('')], null)));

var G__32693 = (i__32683 + (1));
i__32683 = G__32693;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32684),examples$views$examples_sidebar_$_iter__32661_$_iter__32681(cljs.core.chunk_rest(s__32682__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32684),null);
}
} else {
var vec__32688 = cljs.core.first(s__32682__$2);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32688,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32688,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),examples.views.link_to(ex_name,id)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),["sidebar-example-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join('')], null)),examples$views$examples_sidebar_$_iter__32661_$_iter__32681(cljs.core.rest(s__32682__$2)));
}
} else {
return null;
}
break;
}
});})(vec__32678,ex_name,m,s__32662__$2,temp__5457__auto__))
,null,null));
});})(vec__32678,ex_name,m,s__32662__$2,temp__5457__auto__))
;
return iter__4292__auto__(m);
})()], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),["sidebar-example-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ex_name)].join('')], null)),examples$views$examples_sidebar_$_iter__32661(cljs.core.rest(s__32662__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4292__auto__(examples.views.examples_components);
})()], null);
});
examples.views.api_docs = (function examples$views$api_docs(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),"api docs"], null);
});
examples.views.tutorial = (function examples$views$tutorial(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),"Tutorial"], null);
});
examples.views.examples_main = (function examples$views$examples_main(){
var example = (function (){var G__32694 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"example","example",-1755779144)], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__32694) : re_frame.core.subscribe.call(null,G__32694));
})();
return ((function (example){
return (function (){
var temp__5455__auto__ = (function (){var and__3911__auto__ = cljs.core.deref(example);
if(cljs.core.truth_(and__3911__auto__)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(examples.views.examples_components,cljs.core.deref(example));
} else {
return and__3911__auto__;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var component = temp__5455__auto__;
return component;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.single_target.view], null);
}
});
;})(example))
});
examples.views.examples = (function examples$views$examples(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.grid","div.grid",736588158),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.col-3","div.col-3",462800507),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.examples_sidebar], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.col","div.col",-1800797011),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.examples_main], null)], null)], null);
});
if(typeof examples.views.panels !== 'undefined'){
} else {
examples.views.panels = (function (){var method_table__4382__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4383__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4384__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4385__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4386__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("examples.views","panels"),cljs.core.identity,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4386__auto__,method_table__4382__auto__,prefer_table__4383__auto__,method_cache__4384__auto__,cached_hierarchy__4385__auto__));
})();
}
cljs.core._add_method(examples.views.panels,new cljs.core.Keyword(null,"about","about",1423892543),(function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.about], null);
}));
cljs.core._add_method(examples.views.panels,new cljs.core.Keyword(null,"api-docs","api-docs",1385402120),(function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.api_docs], null);
}));
cljs.core._add_method(examples.views.panels,new cljs.core.Keyword(null,"tutorial","tutorial",1017223195),(function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.tutorial], null);
}));
cljs.core._add_method(examples.views.panels,new cljs.core.Keyword(null,"examples","examples",-473712556),(function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.examples], null);
}));
cljs.core._add_method(examples.views.panels,new cljs.core.Keyword(null,"default","default",-1987822328),(function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632)], null);
}));
examples.views.page = (function examples$views$page(){
var active_panel = (function (){var G__32695 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"active-panel","active-panel",-1802545994)], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__32695) : re_frame.core.subscribe.call(null,G__32695));
})();
var page = ((function (active_panel){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.header], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.grid","div.grid",736588158),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.col-1_sm-12","div.col-1_sm-12",1551671239)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.col-10_sm-12","div.col-10_sm-12",-566625247),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),(function (){var G__32696 = cljs.core.deref(active_panel);
return (examples.views.panels.cljs$core$IFn$_invoke$arity$1 ? examples.views.panels.cljs$core$IFn$_invoke$arity$1(G__32696) : examples.views.panels.call(null,G__32696));
})()], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.col-1_sm-12","div.col-1_sm-12",1551671239)], null)], null)], null);
});})(active_panel))
;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent_dnd.core.with_drag_drop_context(reagent_dnd.core.html5_backend,page)], null);
});

//# sourceMappingURL=examples.views.js.map
