goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_30396 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));

try{try{var seq__30397 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__30398 = null;
var count__30399 = (0);
var i__30400 = (0);
while(true){
if((i__30400 < count__30399)){
var vec__30401 = chunk__30398.cljs$core$IIndexed$_nth$arity$2(null,i__30400);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30401,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30401,(1),null);
var temp__5455__auto___30417 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___30417)){
var effect_fn_30418 = temp__5455__auto___30417;
(effect_fn_30418.cljs$core$IFn$_invoke$arity$1 ? effect_fn_30418.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_30418.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__30419 = seq__30397;
var G__30420 = chunk__30398;
var G__30421 = count__30399;
var G__30422 = (i__30400 + (1));
seq__30397 = G__30419;
chunk__30398 = G__30420;
count__30399 = G__30421;
i__30400 = G__30422;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__30397);
if(temp__5457__auto__){
var seq__30397__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__30397__$1)){
var c__4319__auto__ = cljs.core.chunk_first(seq__30397__$1);
var G__30423 = cljs.core.chunk_rest(seq__30397__$1);
var G__30424 = c__4319__auto__;
var G__30425 = cljs.core.count(c__4319__auto__);
var G__30426 = (0);
seq__30397 = G__30423;
chunk__30398 = G__30424;
count__30399 = G__30425;
i__30400 = G__30426;
continue;
} else {
var vec__30404 = cljs.core.first(seq__30397__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30404,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30404,(1),null);
var temp__5455__auto___30427 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___30427)){
var effect_fn_30428 = temp__5455__auto___30427;
(effect_fn_30428.cljs$core$IFn$_invoke$arity$1 ? effect_fn_30428.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_30428.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__30429 = cljs.core.next(seq__30397__$1);
var G__30430 = null;
var G__30431 = (0);
var G__30432 = (0);
seq__30397 = G__30429;
chunk__30398 = G__30430;
count__30399 = G__30431;
i__30400 = G__30432;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__27192__auto___30433 = re_frame.interop.now();
var duration__27193__auto___30434 = (end__27192__auto___30433 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__27193__auto___30434,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__27192__auto___30433);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_30396;
}} else {
var seq__30407 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__30408 = null;
var count__30409 = (0);
var i__30410 = (0);
while(true){
if((i__30410 < count__30409)){
var vec__30411 = chunk__30408.cljs$core$IIndexed$_nth$arity$2(null,i__30410);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30411,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30411,(1),null);
var temp__5455__auto___30435 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___30435)){
var effect_fn_30436 = temp__5455__auto___30435;
(effect_fn_30436.cljs$core$IFn$_invoke$arity$1 ? effect_fn_30436.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_30436.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__30437 = seq__30407;
var G__30438 = chunk__30408;
var G__30439 = count__30409;
var G__30440 = (i__30410 + (1));
seq__30407 = G__30437;
chunk__30408 = G__30438;
count__30409 = G__30439;
i__30410 = G__30440;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__30407);
if(temp__5457__auto__){
var seq__30407__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__30407__$1)){
var c__4319__auto__ = cljs.core.chunk_first(seq__30407__$1);
var G__30441 = cljs.core.chunk_rest(seq__30407__$1);
var G__30442 = c__4319__auto__;
var G__30443 = cljs.core.count(c__4319__auto__);
var G__30444 = (0);
seq__30407 = G__30441;
chunk__30408 = G__30442;
count__30409 = G__30443;
i__30410 = G__30444;
continue;
} else {
var vec__30414 = cljs.core.first(seq__30407__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30414,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30414,(1),null);
var temp__5455__auto___30445 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___30445)){
var effect_fn_30446 = temp__5455__auto___30445;
(effect_fn_30446.cljs$core$IFn$_invoke$arity$1 ? effect_fn_30446.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_30446.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__30447 = cljs.core.next(seq__30407__$1);
var G__30448 = null;
var G__30449 = (0);
var G__30450 = (0);
seq__30407 = G__30447;
chunk__30408 = G__30448;
count__30409 = G__30449;
i__30410 = G__30450;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__30451 = cljs.core.seq(value);
var chunk__30452 = null;
var count__30453 = (0);
var i__30454 = (0);
while(true){
if((i__30454 < count__30453)){
var map__30455 = chunk__30452.cljs$core$IIndexed$_nth$arity$2(null,i__30454);
var map__30455__$1 = ((((!((map__30455 == null)))?(((((map__30455.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30455.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30455):map__30455);
var effect = map__30455__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30455__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30455__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__30451,chunk__30452,count__30453,i__30454,map__30455,map__30455__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__30451,chunk__30452,count__30453,i__30454,map__30455,map__30455__$1,effect,ms,dispatch))
,ms);
}


var G__30465 = seq__30451;
var G__30466 = chunk__30452;
var G__30467 = count__30453;
var G__30468 = (i__30454 + (1));
seq__30451 = G__30465;
chunk__30452 = G__30466;
count__30453 = G__30467;
i__30454 = G__30468;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__30451);
if(temp__5457__auto__){
var seq__30451__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__30451__$1)){
var c__4319__auto__ = cljs.core.chunk_first(seq__30451__$1);
var G__30471 = cljs.core.chunk_rest(seq__30451__$1);
var G__30472 = c__4319__auto__;
var G__30473 = cljs.core.count(c__4319__auto__);
var G__30474 = (0);
seq__30451 = G__30471;
chunk__30452 = G__30472;
count__30453 = G__30473;
i__30454 = G__30474;
continue;
} else {
var map__30462 = cljs.core.first(seq__30451__$1);
var map__30462__$1 = ((((!((map__30462 == null)))?(((((map__30462.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30462.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30462):map__30462);
var effect = map__30462__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30462__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30462__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__30451,chunk__30452,count__30453,i__30454,map__30462,map__30462__$1,effect,ms,dispatch,seq__30451__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__30451,chunk__30452,count__30453,i__30454,map__30462,map__30462__$1,effect,ms,dispatch,seq__30451__$1,temp__5457__auto__))
,ms);
}


var G__30479 = cljs.core.next(seq__30451__$1);
var G__30480 = null;
var G__30481 = (0);
var G__30482 = (0);
seq__30451 = G__30479;
chunk__30452 = G__30480;
count__30453 = G__30481;
i__30454 = G__30482;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value], 0));
} else {
var seq__30485 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__30486 = null;
var count__30487 = (0);
var i__30488 = (0);
while(true){
if((i__30488 < count__30487)){
var event = chunk__30486.cljs$core$IIndexed$_nth$arity$2(null,i__30488);
re_frame.router.dispatch(event);


var G__30493 = seq__30485;
var G__30494 = chunk__30486;
var G__30495 = count__30487;
var G__30496 = (i__30488 + (1));
seq__30485 = G__30493;
chunk__30486 = G__30494;
count__30487 = G__30495;
i__30488 = G__30496;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__30485);
if(temp__5457__auto__){
var seq__30485__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__30485__$1)){
var c__4319__auto__ = cljs.core.chunk_first(seq__30485__$1);
var G__30497 = cljs.core.chunk_rest(seq__30485__$1);
var G__30498 = c__4319__auto__;
var G__30499 = cljs.core.count(c__4319__auto__);
var G__30500 = (0);
seq__30485 = G__30497;
chunk__30486 = G__30498;
count__30487 = G__30499;
i__30488 = G__30500;
continue;
} else {
var event = cljs.core.first(seq__30485__$1);
re_frame.router.dispatch(event);


var G__30501 = cljs.core.next(seq__30485__$1);
var G__30502 = null;
var G__30503 = (0);
var G__30504 = (0);
seq__30485 = G__30501;
chunk__30486 = G__30502;
count__30487 = G__30503;
i__30488 = G__30504;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__30507 = cljs.core.seq(value);
var chunk__30508 = null;
var count__30509 = (0);
var i__30510 = (0);
while(true){
if((i__30510 < count__30509)){
var event = chunk__30508.cljs$core$IIndexed$_nth$arity$2(null,i__30510);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__30516 = seq__30507;
var G__30517 = chunk__30508;
var G__30518 = count__30509;
var G__30519 = (i__30510 + (1));
seq__30507 = G__30516;
chunk__30508 = G__30517;
count__30509 = G__30518;
i__30510 = G__30519;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__30507);
if(temp__5457__auto__){
var seq__30507__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__30507__$1)){
var c__4319__auto__ = cljs.core.chunk_first(seq__30507__$1);
var G__30523 = cljs.core.chunk_rest(seq__30507__$1);
var G__30524 = c__4319__auto__;
var G__30525 = cljs.core.count(c__4319__auto__);
var G__30526 = (0);
seq__30507 = G__30523;
chunk__30508 = G__30524;
count__30509 = G__30525;
i__30510 = G__30526;
continue;
} else {
var event = cljs.core.first(seq__30507__$1);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__30527 = cljs.core.next(seq__30507__$1);
var G__30528 = null;
var G__30529 = (0);
var G__30530 = (0);
seq__30507 = G__30527;
chunk__30508 = G__30528;
count__30509 = G__30529;
i__30510 = G__30530;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return (clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(value) : clear_event.call(null,value));
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref(re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
