goog.provide('reagent_dnd.drag_source');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('reagent_dnd.react_dnd');
goog.require('reagent_dnd.validate');
goog.require('reagent_dnd.util');
goog.require('reagent_dnd.monitor');
goog.require('reagent_dnd.connect');
var module$node_modules$react_dom$index=shadow.js.require("module$node_modules$react_dom$index", {});
reagent_dnd.drag_source.args_desc = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.Keyword(null,"required","required",1807647006),true,new cljs.core.Keyword(null,"type","type",1174270348),"string | hiccup",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),reagent_dnd.validate.string_or_hiccup_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"the thing to be dragged"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"required","required",1807647006),true,new cljs.core.Keyword(null,"type","type",1174270348),"keyword",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.keyword_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"the type of thing to be dragged. e.g. :card or :list"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"required","required",1807647006),true,new cljs.core.Keyword(null,"type","type",1174270348),"atom",new cljs.core.Keyword(null,"description","description",-1428560544),"an atom (or ratom) to contain the drag-state"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"begin-drag","begin-drag",-1601004463),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"-> serializable",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"a function returning the 'dragged item'"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"dragging?","dragging?",-995941410),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"-> boolean",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"a function identifying whether this represents the currently\ndragged component (e.g. if a kanban card moves as you drag it)"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"end-drag","end-drag",1040662768),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"(did-drop?, drop-result) -> any",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"a function called when dragging stops, guaranteed to be\ncalled once for every begin-drag call. did-drop? is true if drop-target\nhandled this drop, drop-result is the result of the drop target's :drop, if\nany"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"can-drag?","can-drag?",-1990014886),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"-> boolean",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"a function returning a boolean indicating whether this\ncomponent can be dragged"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"drag-preview","drag-preview",-1973822141),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"",new cljs.core.Keyword(null,"description","description",-1428560544),"a function returning the drag preview, or the drag preview\nitself"], null)], null);
reagent_dnd.drag_source.options = (function reagent_dnd$drag_source$options(p__32219){
var map__32220 = p__32219;
var map__32220__$1 = ((((!((map__32220 == null)))?(((((map__32220.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32220.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32220):map__32220);
var begin_drag = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32220__$1,new cljs.core.Keyword(null,"begin-drag","begin-drag",-1601004463),cljs.core.constantly(cljs.core.PersistentArrayMap.EMPTY));
var dragging_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32220__$1,new cljs.core.Keyword(null,"dragging?","dragging?",-995941410));
var end_drag = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32220__$1,new cljs.core.Keyword(null,"end-drag","end-drag",1040662768));
var can_drag_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32220__$1,new cljs.core.Keyword(null,"can-drag?","can-drag?",-1990014886));
var options = ({});
(options["beginDrag"] = ((function (options,map__32220,map__32220__$1,begin_drag,dragging_QMARK_,end_drag,can_drag_QMARK_){
return (function (props){
var result = (begin_drag.cljs$core$IFn$_invoke$arity$0 ? begin_drag.cljs$core$IFn$_invoke$arity$0() : begin_drag.call(null));
if(cljs.core.truth_(reagent_dnd.util.serializable_QMARK_(result))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Not Serializable: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([result], 0)))].join('')),"\n","(util/serializable? result)"].join('')));
}

return reagent_dnd.util.serialize(result);
});})(options,map__32220,map__32220__$1,begin_drag,dragging_QMARK_,end_drag,can_drag_QMARK_))
);

if(cljs.core.truth_(can_drag_QMARK_)){
(options["canDrag"] = ((function (options,map__32220,map__32220__$1,begin_drag,dragging_QMARK_,end_drag,can_drag_QMARK_){
return (function (props,monitor){
var G__32226 = reagent_dnd.monitor.monitor__GT_cljsmon.cljs$core$IFn$_invoke$arity$variadic(monitor,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"except","except",1116893347),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"can-drag?","can-drag?",-1990014886)], null)], 0));
return (can_drag_QMARK_.cljs$core$IFn$_invoke$arity$1 ? can_drag_QMARK_.cljs$core$IFn$_invoke$arity$1(G__32226) : can_drag_QMARK_.call(null,G__32226));
});})(options,map__32220,map__32220__$1,begin_drag,dragging_QMARK_,end_drag,can_drag_QMARK_))
);
} else {
}

if(cljs.core.truth_(end_drag)){
(options["endDrag"] = ((function (options,map__32220,map__32220__$1,begin_drag,dragging_QMARK_,end_drag,can_drag_QMARK_){
return (function (props,monitor,component){
var G__32227 = reagent_dnd.monitor.monitor__GT_cljsmon(monitor);
return (end_drag.cljs$core$IFn$_invoke$arity$1 ? end_drag.cljs$core$IFn$_invoke$arity$1(G__32227) : end_drag.call(null,G__32227));
});})(options,map__32220,map__32220__$1,begin_drag,dragging_QMARK_,end_drag,can_drag_QMARK_))
);
} else {
}

if(cljs.core.truth_(dragging_QMARK_)){
(options["isDragging"] = ((function (options,map__32220,map__32220__$1,begin_drag,dragging_QMARK_,end_drag,can_drag_QMARK_){
return (function (props,monitor){
var G__32229 = reagent_dnd.monitor.monitor__GT_cljsmon.cljs$core$IFn$_invoke$arity$variadic(monitor,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"except","except",1116893347),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dragging?","dragging?",-995941410)], null)], 0));
return (dragging_QMARK_.cljs$core$IFn$_invoke$arity$1 ? dragging_QMARK_.cljs$core$IFn$_invoke$arity$1(G__32229) : dragging_QMARK_.call(null,G__32229));
});})(options,map__32220,map__32220__$1,begin_drag,dragging_QMARK_,end_drag,can_drag_QMARK_))
);
} else {
}

return options;
});
reagent_dnd.drag_source.component = (function reagent_dnd$drag_source$component(var_args){
var args__4502__auto__ = [];
var len__4499__auto___32262 = arguments.length;
var i__4500__auto___32263 = (0);
while(true){
if((i__4500__auto___32263 < len__4499__auto___32262)){
args__4502__auto__.push((arguments[i__4500__auto___32263]));

var G__32265 = (i__4500__auto___32263 + (1));
i__4500__auto___32263 = G__32265;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return reagent_dnd.drag_source.component.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});

reagent_dnd.drag_source.component.cljs$core$IFn$_invoke$arity$variadic = (function (p__32233){
var map__32235 = p__32233;
var map__32235__$1 = ((((!((map__32235 == null)))?(((((map__32235.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32235.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32235):map__32235);
var args = map__32235__$1;
var child = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32235__$1,new cljs.core.Keyword(null,"child","child",623967545));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32235__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32235__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var begin_drag = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32235__$1,new cljs.core.Keyword(null,"begin-drag","begin-drag",-1601004463));
var dragging_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32235__$1,new cljs.core.Keyword(null,"dragging?","dragging?",-995941410));
var end_drag = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32235__$1,new cljs.core.Keyword(null,"end-drag","end-drag",1040662768));
var can_drag_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32235__$1,new cljs.core.Keyword(null,"can-drag?","can-drag?",-1990014886));
var drag_preview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32235__$1,new cljs.core.Keyword(null,"drag-preview","drag-preview",-1973822141));
if(cljs.core.truth_(((!(goog.DEBUG))?true:reagent_dnd.validate.validate_args.cljs$core$IFn$_invoke$arity$variadic(reagent_dnd.validate.extract_arg_data(reagent_dnd.drag_source.args_desc),args,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["drag-source"], 0))))){
} else {
throw (new Error("Assert failed: (validate-args-macro args-desc args \"drag-source\")"));
}

var options = reagent_dnd.drag_source.options(cljs.core.select_keys(args,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"begin-drag","begin-drag",-1601004463),new cljs.core.Keyword(null,"dragging?","dragging?",-995941410),new cljs.core.Keyword(null,"end-drag","end-drag",1040662768),new cljs.core.Keyword(null,"can-drag?","can-drag?",-1990014886)], null)));
var wrapper = (function (){var G__32240 = cljs.core.clj__GT_js(type);
var G__32241 = options;
var G__32242 = reagent_dnd.monitor.props;
return (reagent_dnd.react_dnd.drag_source.cljs$core$IFn$_invoke$arity$3 ? reagent_dnd.react_dnd.drag_source.cljs$core$IFn$_invoke$arity$3(G__32240,G__32241,G__32242) : reagent_dnd.react_dnd.drag_source.call(null,G__32240,G__32241,G__32242));
})();
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent.core.adapt_react_class((function (){var G__32247 = reagent.core.reactify_component(reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),((function (options,wrapper,map__32235,map__32235__$1,args,child,type,state,begin_drag,dragging_QMARK_,end_drag,can_drag_QMARK_,drag_preview){
return (function (this$){
var f = (reagent_dnd.monitor.props__GT_cljscon(reagent.core.props(this$))["connect-drag-preview"]);
if(cljs.core.truth_(drag_preview)){
if(cljs.core.fn_QMARK_(drag_preview)){
var G__32252 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),(drag_preview.cljs$core$IFn$_invoke$arity$0 ? drag_preview.cljs$core$IFn$_invoke$arity$0() : drag_preview.call(null))], null);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__32252) : f.call(null,G__32252));
} else {
var G__32253 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),drag_preview], null);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__32253) : f.call(null,G__32253));
}
} else {
return null;
}
});})(options,wrapper,map__32235,map__32235__$1,args,child,type,state,begin_drag,dragging_QMARK_,end_drag,can_drag_QMARK_,drag_preview))
,new cljs.core.Keyword(null,"component-will-update","component-will-update",335247566),((function (options,wrapper,map__32235,map__32235__$1,args,child,type,state,begin_drag,dragging_QMARK_,end_drag,can_drag_QMARK_,drag_preview){
return (function (this$,p__32254){
var vec__32256 = p__32254;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32256,(0),null);
var next_props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32256,(1),null);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(state,cljs.core.merge,reagent_dnd.monitor.props__GT_cljsmon(next_props));
});})(options,wrapper,map__32235,map__32235__$1,args,child,type,state,begin_drag,dragging_QMARK_,end_drag,can_drag_QMARK_,drag_preview))
,new cljs.core.Keyword(null,"render","render",-1408033454),((function (options,wrapper,map__32235,map__32235__$1,args,child,type,state,begin_drag,dragging_QMARK_,end_drag,can_drag_QMARK_,drag_preview){
return (function (this$){
var connect_drag_source = (reagent_dnd.monitor.props__GT_cljscon(reagent.core.props(reagent.core.current_component()))["connect-drag-source"]);
var G__32259 = reagent.core.as_element(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),child], null));
return (connect_drag_source.cljs$core$IFn$_invoke$arity$1 ? connect_drag_source.cljs$core$IFn$_invoke$arity$1(G__32259) : connect_drag_source.call(null,G__32259));
});})(options,wrapper,map__32235,map__32235__$1,args,child,type,state,begin_drag,dragging_QMARK_,end_drag,can_drag_QMARK_,drag_preview))
], null)));
return (wrapper.cljs$core$IFn$_invoke$arity$1 ? wrapper.cljs$core$IFn$_invoke$arity$1(G__32247) : wrapper.call(null,G__32247));
})())], null);
});

reagent_dnd.drag_source.component.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
reagent_dnd.drag_source.component.cljs$lang$applyTo = (function (seq32232){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32232));
});


//# sourceMappingURL=reagent_dnd.drag_source.js.map
