# invoke

A very basic wrapper for `clojure.lang.Reflector`, designed to make dynamic Java interops a little easier.

**Note**: This project is still in development!

## Install

Add the following dependency to your `project.clj` file:

    [ceviche/invoke "0.1.0-SNAPSHOT"]

## Usage

Let's say you want to do this:

```clojure
(. myJavaObject methodName arg1 arg2)
```

...but the args are in a collection, like `[arg1 arg2]`.  How can you use `apply` to call the Java method dynamically?

Well, you can use `clojure.lang.Reflector`, like this:

```clojure
(clojure.lang.Reflector/invokeInstanceMethod myJavaObject "methodName" (to-array [arg1 arg2]))
```

That's a little verbose!  Notice, in particular, that `clojure.lang.Reflector/invokeInstanceMethod` requires any list of arguments to be converted to a Java array.  How inconvenient!

`invoke` makes things a little easier:

```clojure
(require '[invoke.core :as invoke])

(invoke/instance-method myJavaObject "methodName" arg1 arg2)
;; equivalent to the above:
(apply invoke/instance-method myJavaObject "methodName" [arg1 arg2])
```

You have probably also deduced that another use case for `invoke` is when you have the name of a method in string form (like `"methodName"` above).

Here's how to use `invoke` to dynamically call a constructor:

```clojure
(invoke/constructor MyJavaClass arg1 arg2)
;; equivalent:
(apply invoke/constructor MyJavaClass [arg1 arg2])
```

