(ns invoke.core)

(defn constructor
"Invokes the constructor of the given class, with optional variadic args"
  [cls & args]
  (clojure.lang.Reflector/invokeConstructor cls (to-array args)))

(defn instance-method [target method-name & args]
"Invokes the string method-name on the given target object, with optional variadic args"
  (clojure.lang.Reflector/invokeInstanceMethod target method-name (to-array args)))
